package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class ImportPupitriPopupUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EDITABLE = "editable";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVzW8bRRQfu3GaOGnTxvRLpKhNK0EPHUMrJERQ6adFIhcikkoVvjDenSRTZmeGmbftRhGo/Af8CXDngsSNE+LAmQMXxL+AEAeuiDdrezebjOXkgKVdr9783u99v/nuT9Jwllx9xrKM2lSBSDhdu/f06Uf9ZzyCh9xFVhjQlgx+tTqp98hcXMgdkGu9rldvD9XbD3RitOJqn/ZKlzQd7ErudjgHIJerGpFz7Y3ieCUzqR2xFk6FWL/5+6/61/HLb+uEZAa9a2IoVyZplZFMdUldxEAW0dJz1pZMbaMbVqht9PeUlz2QzLkPWcI/J1+Sk10ybZhFMiDLRw8558j1MwOkJRBpYT01Ai09FEzqbSDrW5aKLcsTbimkAIKmgroX6AmNtAIkptpwy0BoRSMG0Q531BkeCfxf3c+4rk1qnqwak5ucBjLDYwGsLzmQsz4k6sOk97WWnKkSNpswodaZ4hLIxUoKB25segqPnS1UTgNCPusIybus7/UWPX82VFjLhR66UBopNIBcDxjxrmpLPeBR/llVX4yYtTp1XBZG/ckrVdSpCsoLL1QBM9fX8kDfPOhxLq1i5yOmIi7vY02wDqRVwQ+kHrlUJuU5kyJmwMvDq0OEJa9WYsaup2XXl21Z65GGTVGMlegdHpSP8WgwIhcPjIgnzE//Pd/67cc/fuiM5mIWbZ8LQveNNfarsb7LQHjTC4OhSEHI9mNmVnrIwiXuhHzmlwKObQyP0Tm0N2g2r04/YG4HKRonf//p5/Of/nqC1DukKTWLO8zjV7EvdixmQcs4M+/fzT2afzGD7zP41IE0QIDvmUuD2aiMEB2eNRIdM2zCKewxnmF2lgLZKVzsz/7yT2vj+7ujDNXQ40tj4WWWGp+QaaGkUDzfHcO1ENwVc8bxNNbl+IcWAglvBDMczBv5+2YoJzPS938HNcncXjFXX/gE8Aw31LVQrrYElzEt0Fnq6W/n8fuvt8mhqZ7kyRQaRHvYEnQP3lgOFmhESBHIlcMdtnwDHV3weqOFKfx4vXsMChqXmjndBRZF3MA9mc89PsDtE8dxvze2mHTYImdiYfN67j5Sfp0VR6E8lLvqeMVY2Kvsn7Igr48vSEUj5Exg8x29MLfGZbVCOrE4d45J838XqLrnj5KOQR1agxginST5Zer3O5AmriJ0dNVft2R6JJ0Xb72jHiuOSBHh1guo0qQ4ngO8VTeF2RxrJxRH5Yo5ehjnKvSjW+dAICdYHB+K4rWg5tg4woaCq6N6902KpYaJlmxXI5icfg/12JW+UDFerXcOsdf8uzmR0Ytf+tdXYYbLyPAf+8lbPfMKAAA=";
    private static final Log log = LogFactory.getLog(ImportPupitriPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected FileEditor carrouselFile;
    protected JLabel carrouselFileLabel;
    protected Boolean editable;
    protected final ImportPupitriPopupUIHandler handler = new ImportPupitriPopupUIHandler();
    protected ImportPupitriPopupUI importPupitriDialog = this;
    protected Table mainPanel;
    protected FileEditor trunkFile;
    protected JLabel trunkFileLabel;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void open() {
        handler.open();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ImportPupitriPopupUI(TuttiUIContext context) {
        super(context.getMainUI());
            TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI() {
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.validate();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public FileEditor getCarrouselFile() {
        return carrouselFile;
    }

    public JLabel getCarrouselFileLabel() {
        return carrouselFileLabel;
    }

    public Boolean getEditable() {
        return editable;
    }

    public ImportPupitriPopupUIHandler getHandler() {
        return handler;
    }

    public Table getMainPanel() {
        return mainPanel;
    }

    public FileEditor getTrunkFile() {
        return trunkFile;
    }

    public JLabel getTrunkFileLabel() {
        return trunkFileLabel;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToImportPupitriDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(trunkFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(trunkFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(carrouselFileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(carrouselFile, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.common.cancel"));
        cancelButton.setToolTipText(t("tutti.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCarrouselFile() {
        $objectMap.put("carrouselFile", carrouselFile = new FileEditor());
        
        carrouselFile.setName("carrouselFile");
        carrouselFile.setAcceptAllFileFilterUsed(false);
        carrouselFile.setDirectoryEnabled(false);
    }

    protected void createCarrouselFileLabel() {
        $objectMap.put("carrouselFileLabel", carrouselFileLabel = new JLabel());
        
        carrouselFileLabel.setName("carrouselFileLabel");
        carrouselFileLabel.setText(t("tutti.importPupitri.field.carrouselFile"));
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new Table());
        
        mainPanel.setName("mainPanel");
    }

    protected void createTrunkFile() {
        $objectMap.put("trunkFile", trunkFile = new FileEditor());
        
        trunkFile.setName("trunkFile");
        trunkFile.setAcceptAllFileFilterUsed(false);
        trunkFile.setDirectoryEnabled(false);
    }

    protected void createTrunkFileLabel() {
        $objectMap.put("trunkFileLabel", trunkFileLabel = new JLabel());
        
        trunkFileLabel.setName("trunkFileLabel");
        trunkFileLabel.setText(t("tutti.importPupitri.field.trunkFile"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("tutti.common.validate"));
        validateButton.setToolTipText(t("tutti.common.validate"));
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToImportPupitriDialog();
        addChildrenToMainPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 12 property setters
        trunkFileLabel.setLabelFor(trunkFile);
        trunkFile.setExts(t("tutti.importPupitri.trunkFile.extension"));
        trunkFile.setExtsDescription(t("tutti.importPupitri.trunkFile.extension.description"));
        carrouselFileLabel.setLabelFor(carrouselFile);
        carrouselFile.setExts(t("tutti.importPupitri.carrouselFile.extension"));
        carrouselFile.setExtsDescription(t("tutti.importPupitri.carrouselFile.extension.description"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.common.cancel.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("add"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.common.validate.mnemonic"),'Z'));
        // late initializer
        importPupitriDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("importPupitriDialog", importPupitriDialog);
        createEditable();
        createMainPanel();
        createTrunkFileLabel();
        createTrunkFile();
        createCarrouselFileLabel();
        createCarrouselFile();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createValidateButton();
        // inline creation of importPupitriDialog
        setName("importPupitriDialog");
        importPupitriDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(t("tutti.importPupitri.title"));
        setModal(true);
        
        $completeSetup();
        handler.afterInit(this);
    }

}