/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.JdbcTypeFamilyInformation;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.VarbinaryTypeDescriptor;
import org.jboss.logging.Logger;

public class SqlTypeDescriptorRegistry {
    public static final SqlTypeDescriptorRegistry INSTANCE = new SqlTypeDescriptorRegistry();
    private static final Logger log = Logger.getLogger(SqlTypeDescriptorRegistry.class);
    private ConcurrentHashMap<Integer, SqlTypeDescriptor> descriptorMap = new ConcurrentHashMap();

    public void addDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        this.descriptorMap.put(sqlTypeDescriptor.getSqlType(), sqlTypeDescriptor);
    }

    public SqlTypeDescriptor getDescriptor(int jdbcTypeCode) {
        JdbcTypeFamilyInformation.Family family;
        SqlTypeDescriptor descriptor = this.descriptorMap.get(jdbcTypeCode);
        if (descriptor != null) {
            return descriptor;
        }
        if (JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode)) {
            log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", (Object)jdbcTypeCode);
        }
        if ((family = JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode)) != null) {
            for (int potentialAlternateTypeCode : family.getTypeCodes()) {
                if (potentialAlternateTypeCode == jdbcTypeCode) continue;
                SqlTypeDescriptor potentialAlternateDescriptor = this.descriptorMap.get(potentialAlternateTypeCode);
                if (potentialAlternateDescriptor != null) {
                    return potentialAlternateDescriptor;
                }
                if (!JdbcTypeNameMapper.isStandardTypeCode(potentialAlternateTypeCode)) continue;
                log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", (Object)potentialAlternateTypeCode);
            }
        }
        ObjectSqlTypeDescriptor fallBackDescriptor = new ObjectSqlTypeDescriptor(jdbcTypeCode);
        this.addDescriptor(fallBackDescriptor);
        return fallBackDescriptor;
    }

    public static class ObjectSqlTypeDescriptor
    implements SqlTypeDescriptor {
        private final int jdbcTypeCode;

        public ObjectSqlTypeDescriptor(int jdbcTypeCode) {
            this.jdbcTypeCode = jdbcTypeCode;
        }

        @Override
        public int getSqlType() {
            return this.jdbcTypeCode;
        }

        @Override
        public boolean canBeRemapped() {
            return true;
        }

        @Override
        public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
            if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaTypeClass())) {
                return VarbinaryTypeDescriptor.INSTANCE.getBinder(javaTypeDescriptor);
            }
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setObject(index, value, ObjectSqlTypeDescriptor.this.jdbcTypeCode);
                }
            };
        }

        public ValueExtractor getExtractor(JavaTypeDescriptor javaTypeDescriptor) {
            if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaTypeClass())) {
                return VarbinaryTypeDescriptor.INSTANCE.getExtractor(javaTypeDescriptor);
            }
            return new BasicExtractor(javaTypeDescriptor, this){

                protected Object doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                    return rs.getObject(name);
                }

                protected Object doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return statement.getObject(index);
                }

                protected Object doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return statement.getObject(name);
                }
            };
        }
    }
}

