// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.sale;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.SaleMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.survey.declaration.DeclaredDocumentReference;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.landing.Landing;
import fr.ifremer.adagio.core.dao.data.survey.takeOver.TakeOver;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.SaleType;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.sale.TakeOverType;
import fr.ifremer.adagio.core.dao.referential.seller.Seller;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe plusieurs
 * produits vendus (Produce).
 * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
 * s'étale sur plusieurs jours,
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Sale
    implements Serializable, Comparable<Sale>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 6001382796842166650L;

    // Generate 12 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Date saleStartDate;

    /**
     * Date de vente, ou date de début de la vente si la période de vente est connue (ex :
     * déclaration de vente mensuelle des viviers).
     * @return this.saleStartDate Date
     */
    public Date getSaleStartDate()
    {
        return this.saleStartDate;
    }

    /**
     * Date de vente, ou date de début de la vente si la période de vente est connue (ex :
     * déclaration de vente mensuelle des viviers).
     * @param saleStartDateIn Date
     */
    public void setSaleStartDate(Date saleStartDateIn)
    {
        this.saleStartDate = saleStartDateIn;
    }

    private Date saleEndDate;

    /**
     * Date de fin de la vente (Optionnel). Si non renseigné, signifie que la période de la vente
     * n'est pas connue ou que la vente est très ponctuelle dans le temps.
     * NE PAS RENSEIGNER pour les ventes ponctuelles, sur une journée.
     * @return this.saleEndDate Date
     */
    public Date getSaleEndDate()
    {
        return this.saleEndDate;
    }

    /**
     * Date de fin de la vente (Optionnel). Si non renseigné, signifie que la période de la vente
     * n'est pas connue ou que la vente est très ponctuelle dans le temps.
     * NE PAS RENSEIGNER pour les ventes ponctuelles, sur une journée.
     * @param saleEndDateIn Date
     */
    public void setSaleEndDate(Date saleEndDateIn)
    {
        this.saleEndDate = saleEndDateIn;
    }

    private String synchronizationStatus;

    /**
     * 
     * @return this.synchronizationStatus String
     */
    public String getSynchronizationStatus()
    {
        return this.synchronizationStatus;
    }

    /**
     * 
     * @param synchronizationStatusIn String
     */
    public void setSynchronizationStatus(String synchronizationStatusIn)
    {
        this.synchronizationStatus = synchronizationStatusIn;
    }

    private String comments;

    /**
     * 
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * 
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date validationDate;

    /**
     * 
     * @return this.validationDate Date
     */
    public Date getValidationDate()
    {
        return this.validationDate;
    }

    /**
     * 
     * @param validationDateIn Date
     */
    public void setValidationDate(Date validationDateIn)
    {
        this.validationDate = validationDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 20 associations
    private Location saleLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.saleLocation Location
     */
    public Location getSaleLocation()
    {
        return this.saleLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param saleLocationIn Location
     */
    public void setSaleLocation(Location saleLocationIn)
    {
        this.saleLocation = saleLocationIn;
    }

    private SaleType saleType;

    /**
     * @deprecated
     * Type de vente qui peuvent être effectuée à l'issu d'une marée.
     * Par exemple :
     * - Enchères sous criée
     * - Vente de gré à gré
     * mais aussi, en cas de non vente :
     * - Enchère sous criée - détruit
     * - Enchère sous criée - retrait sanitaire
     * @return this.saleType SaleType
     */
    public SaleType getSaleType()
    {
        return this.saleType;
    }

    /**
     * @deprecated
     * Type de vente qui peuvent être effectuée à l'issu d'une marée.
     * Par exemple :
     * - Enchères sous criée
     * - Vente de gré à gré
     * mais aussi, en cas de non vente :
     * - Enchère sous criée - détruit
     * - Enchère sous criée - retrait sanitaire
     * @param saleTypeIn SaleType
     */
    public void setSaleType(SaleType saleTypeIn)
    {
        this.saleType = saleTypeIn;
    }

    private Department recorderDepartment;

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private CatchBatch catchBatch;

    /**
     * Capture réalisée au cours d'une opération, et sur laquelle un échantillonnage est réalisé.
     * La capture porte donc l'arbre d''échantillonnage.
     * @return this.catchBatch CatchBatch
     */
    public CatchBatch getCatchBatch()
    {
        return this.catchBatch;
    }

    /**
     * Capture réalisée au cours d'une opération, et sur laquelle un échantillonnage est réalisé.
     * La capture porte donc l'arbre d''échantillonnage.
     * @param catchBatchIn CatchBatch
     */
    public void setCatchBatch(CatchBatch catchBatchIn)
    {
        this.catchBatch = catchBatchIn;
    }

    private FishingTrip fishingTrip;

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @return this.fishingTrip FishingTrip
     */
    public FishingTrip getFishingTrip()
    {
        return this.fishingTrip;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param fishingTripIn FishingTrip
     */
    public void setFishingTrip(FishingTrip fishingTripIn)
    {
        this.fishingTrip = fishingTripIn;
    }

    private Collection<SaleOrigin> saleOrigins = new HashSet<SaleOrigin>();

    /**
     * Définie l'origine d'une vente.
     * Par exemple, une vente recopié depuis une vente déclarée pour identifier le programme de la
     * vente
     * qui à serie à copier les données.
     * il peut éventuellement y avoir plusieurs programme d'origine à la vente. Par exemple, cela
     * pourrait
     * etre le cas de ventes reconstituées à partir de différentes sources de données...
     * @return this.saleOrigins Collection<SaleOrigin>
     */
    public Collection<SaleOrigin> getSaleOrigins()
    {
        return this.saleOrigins;
    }

    /**
     * Définie l'origine d'une vente.
     * Par exemple, une vente recopié depuis une vente déclarée pour identifier le programme de la
     * vente
     * qui à serie à copier les données.
     * il peut éventuellement y avoir plusieurs programme d'origine à la vente. Par exemple, cela
     * pourrait
     * etre le cas de ventes reconstituées à partir de différentes sources de données...
     * @param saleOriginsIn Collection<SaleOrigin>
     */
    public void setSaleOrigins(Collection<SaleOrigin> saleOriginsIn)
    {
        this.saleOrigins = saleOriginsIn;
    }

    /**
     * Définie l'origine d'une vente.
     * Par exemple, une vente recopié depuis une vente déclarée pour identifier le programme de la
     * vente
     * qui à serie à copier les données.
     * il peut éventuellement y avoir plusieurs programme d'origine à la vente. Par exemple, cela
     * pourrait
     * etre le cas de ventes reconstituées à partir de différentes sources de données...
     * @param elementToAdd SaleOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSaleOrigins(SaleOrigin elementToAdd)
    {
        return this.saleOrigins.add(elementToAdd);
    }

    /**
     * Définie l'origine d'une vente.
     * Par exemple, une vente recopié depuis une vente déclarée pour identifier le programme de la
     * vente
     * qui à serie à copier les données.
     * il peut éventuellement y avoir plusieurs programme d'origine à la vente. Par exemple, cela
     * pourrait
     * etre le cas de ventes reconstituées à partir de différentes sources de données...
     * @param elementToRemove SaleOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSaleOrigins(SaleOrigin elementToRemove)
    {
        return this.saleOrigins.remove(elementToRemove);
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private QualityFlag qualityFlag;

    /**
     * Indice qualité d'une donnée.
     * Actuellement, les indices qualités identifiés sont :
     * 0 - Non qualifiée,
     * 1 - Bonne,
     * 2 - Hors statistiques,
     * 3 - Douteuse,
     * 4 - Fausse,
     * 5 - Corrigée,
     * 8 - Incomplète,
     * 9 - Absente.
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Indice qualité d'une donnée.
     * Actuellement, les indices qualités identifiés sont :
     * 0 - Non qualifiée,
     * 1 - Bonne,
     * 2 - Hors statistiques,
     * 3 - Douteuse,
     * 4 - Fausse,
     * 5 - Corrigée,
     * 8 - Incomplète,
     * 9 - Absente.
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Seller seller;

    /**
     * Vendeur, en charge de la vente d'un ensemble de produits d'un navire.
     * @return this.seller Seller
     */
    public Seller getSeller()
    {
        return this.seller;
    }

    /**
     * Vendeur, en charge de la vente d'un ensemble de produits d'un navire.
     * @param sellerIn Seller
     */
    public void setSeller(Seller sellerIn)
    {
        this.seller = sellerIn;
    }

    private TakeOverType takeOverType;

    /**
     * Type de prise en charge, qui peuvent être effectuées à l'issue d'une marée.
     * - En Criée
     * - Hors criée
     * - Indéterminé
     * - Hors criée généré
     * (Remplace SaleType, qui mélangeait plusieurs aspects comme le type de transaction, etc.)
     * @since 3.5.0
     * @return this.takeOverType TakeOverType
     */
    public TakeOverType getTakeOverType()
    {
        return this.takeOverType;
    }

    /**
     * Type de prise en charge, qui peuvent être effectuées à l'issue d'une marée.
     * - En Criée
     * - Hors criée
     * - Indéterminé
     * - Hors criée généré
     * (Remplace SaleType, qui mélangeait plusieurs aspects comme le type de transaction, etc.)
     * @since 3.5.0
     * @param takeOverTypeIn TakeOverType
     */
    public void setTakeOverType(TakeOverType takeOverTypeIn)
    {
        this.takeOverType = takeOverTypeIn;
    }

    private DeclaredDocumentReference declaredDocumentReference;

    /**
     * Reference du document déclaratif ayant servi à renseigner la vente.
     * Exemple : vente RIC.
     * @return this.declaredDocumentReference DeclaredDocumentReference
     */
    public DeclaredDocumentReference getDeclaredDocumentReference()
    {
        return this.declaredDocumentReference;
    }

    /**
     * Reference du document déclaratif ayant servi à renseigner la vente.
     * Exemple : vente RIC.
     * @param declaredDocumentReferenceIn DeclaredDocumentReference
     */
    public void setDeclaredDocumentReference(DeclaredDocumentReference declaredDocumentReferenceIn)
    {
        this.declaredDocumentReference = declaredDocumentReferenceIn;
    }

    private Landing landing;

    /**
     * Débarquement à la suite d'une marée en mer.
     * @return this.landing Landing
     */
    public Landing getLanding()
    {
        return this.landing;
    }

    /**
     * Débarquement à la suite d'une marée en mer.
     * @param landingIn Landing
     */
    public void setLanding(Landing landingIn)
    {
        this.landing = landingIn;
    }

    private TakeOver takeOver;

    /**
     * Prise en charge, d'une marée ou d'un débarquement, par un organisme (Seller) chargé de mettre
     * en
     * vente les produits débarqués.
     * @return this.takeOver TakeOver
     */
    public TakeOver getTakeOver()
    {
        return this.takeOver;
    }

    /**
     * Prise en charge, d'une marée ou d'un débarquement, par un organisme (Seller) chargé de mettre
     * en
     * vente les produits débarqués.
     * @param takeOverIn TakeOver
     */
    public void setTakeOver(TakeOver takeOverIn)
    {
        this.takeOver = takeOverIn;
    }

    private Collection<Produce> produces = new HashSet<Produce>();

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @return this.produces Collection<Produce>
     */
    public Collection<Produce> getProduces()
    {
        return this.produces;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param producesIn Collection<Produce>
     */
    public void setProduces(Collection<Produce> producesIn)
    {
        this.produces = producesIn;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param elementToAdd Produce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addProduces(Produce elementToAdd)
    {
        return this.produces.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param elementToRemove Produce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeProduces(Produce elementToRemove)
    {
        return this.produces.remove(elementToRemove);
    }

    private Collection<FishingArea> fishingAreas = new HashSet<FishingArea>();

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Zones de pêche liées à la vente.
     * </p>
     * <p>
     * =&gt; Il faut utiliser de préférence Produce.fishingArea, plus facile à
     * exploiter car Produce est lié à l'espèce commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * Ce lien vers FishingArea a été nécessaire pour Allegro, afin de stocker
     * les zones de pêche récupérée dans WAO, à partir d'une référence de plan
     * d'échantillonnage.
     * </p>
     * </body>
     * </html>
     * @return this.fishingAreas Collection<FishingArea>
     */
    public Collection<FishingArea> getFishingAreas()
    {
        return this.fishingAreas;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Zones de pêche liées à la vente.
     * </p>
     * <p>
     * =&gt; Il faut utiliser de préférence Produce.fishingArea, plus facile à
     * exploiter car Produce est lié à l'espèce commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * Ce lien vers FishingArea a été nécessaire pour Allegro, afin de stocker
     * les zones de pêche récupérée dans WAO, à partir d'une référence de plan
     * d'échantillonnage.
     * </p>
     * </body>
     * </html>
     * @param fishingAreasIn Collection<FishingArea>
     */
    public void setFishingAreas(Collection<FishingArea> fishingAreasIn)
    {
        this.fishingAreas = fishingAreasIn;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Zones de pêche liées à la vente.
     * </p>
     * <p>
     * =&gt; Il faut utiliser de préférence Produce.fishingArea, plus facile à
     * exploiter car Produce est lié à l'espèce commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * Ce lien vers FishingArea a été nécessaire pour Allegro, afin de stocker
     * les zones de pêche récupérée dans WAO, à partir d'une référence de plan
     * d'échantillonnage.
     * </p>
     * </body>
     * </html>
     * @param elementToAdd FishingArea
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addFishingAreas(FishingArea elementToAdd)
    {
        return this.fishingAreas.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Zones de pêche liées à la vente.
     * </p>
     * <p>
     * =&gt; Il faut utiliser de préférence Produce.fishingArea, plus facile à
     * exploiter car Produce est lié à l'espèce commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * Ce lien vers FishingArea a été nécessaire pour Allegro, afin de stocker
     * les zones de pêche récupérée dans WAO, à partir d'une référence de plan
     * d'échantillonnage.
     * </p>
     * </body>
     * </html>
     * @param elementToRemove FishingArea
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeFishingAreas(FishingArea elementToRemove)
    {
        return this.fishingAreas.remove(elementToRemove);
    }

    private Collection<SurveyMeasurement> surveyMeasurements = new HashSet<SurveyMeasurement>();

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @return this.surveyMeasurements Collection<SurveyMeasurement>
     */
    public Collection<SurveyMeasurement> getSurveyMeasurements()
    {
        return this.surveyMeasurements;
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param surveyMeasurementsIn Collection<SurveyMeasurement>
     */
    public void setSurveyMeasurements(Collection<SurveyMeasurement> surveyMeasurementsIn)
    {
        this.surveyMeasurements = surveyMeasurementsIn;
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param elementToAdd SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSurveyMeasurements(SurveyMeasurement elementToAdd)
    {
        return this.surveyMeasurements.add(elementToAdd);
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param elementToRemove SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSurveyMeasurements(SurveyMeasurement elementToRemove)
    {
        return this.surveyMeasurements.remove(elementToRemove);
    }

    private Collection<SaleMeasurement> saleMeasurements = new HashSet<SaleMeasurement>();

    /**
     * Caractéristiques sur la vente (données economiques, ou caractéristiques de l'observation,
     * etc.).
     * @return this.saleMeasurements Collection<SaleMeasurement>
     */
    public Collection<SaleMeasurement> getSaleMeasurements()
    {
        return this.saleMeasurements;
    }

    /**
     * Caractéristiques sur la vente (données economiques, ou caractéristiques de l'observation,
     * etc.).
     * @param saleMeasurementsIn Collection<SaleMeasurement>
     */
    public void setSaleMeasurements(Collection<SaleMeasurement> saleMeasurementsIn)
    {
        this.saleMeasurements = saleMeasurementsIn;
    }

    /**
     * Caractéristiques sur la vente (données economiques, ou caractéristiques de l'observation,
     * etc.).
     * @param elementToAdd SaleMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSaleMeasurements(SaleMeasurement elementToAdd)
    {
        return this.saleMeasurements.add(elementToAdd);
    }

    /**
     * Caractéristiques sur la vente (données economiques, ou caractéristiques de l'observation,
     * etc.).
     * @param elementToRemove SaleMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSaleMeasurements(SaleMeasurement elementToRemove)
    {
        return this.saleMeasurements.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Sale instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Sale))
        {
            return false;
        }
        final Sale that = (Sale)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Sale}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Sale}.
         * @return new SaleImpl()
         */
        public static Sale newInstance()
        {
            return new SaleImpl();
        }

        /**
         * Constructs a new instance of {@link Sale}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param synchronizationStatus String
         * @param creationDate Date
         * @param recorderDepartment Department
         * @param program Program
         * @param vessel Vessel
         * @param qualityFlag QualityFlag
         * @return newInstance
         */
        public static Sale newInstance(String synchronizationStatus, Date creationDate, Department recorderDepartment, Program program, Vessel vessel, QualityFlag qualityFlag)
        {
            final Sale entity = new SaleImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setCreationDate(creationDate);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Sale}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param saleStartDate Date
         * @param saleEndDate Date
         * @param synchronizationStatus String
         * @param comments String
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param saleLocation Location
         * @param saleType SaleType
         * @param recorderDepartment Department
         * @param recorderPerson Person
         * @param catchBatch CatchBatch
         * @param fishingTrip FishingTrip
         * @param saleOrigins Collection<SaleOrigin>
         * @param program Program
         * @param vessel Vessel
         * @param qualityFlag QualityFlag
         * @param seller Seller
         * @param takeOverType TakeOverType
         * @param declaredDocumentReference DeclaredDocumentReference
         * @param landing Landing
         * @param takeOver TakeOver
         * @param produces Collection<Produce>
         * @param fishingAreas Collection<FishingArea>
         * @param surveyMeasurements Collection<SurveyMeasurement>
         * @param saleMeasurements Collection<SaleMeasurement>
         * @return newInstance Sale
         */
        public static Sale newInstance(Date saleStartDate, Date saleEndDate, String synchronizationStatus, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Location saleLocation, SaleType saleType, Department recorderDepartment, Person recorderPerson, CatchBatch catchBatch, FishingTrip fishingTrip, Collection<SaleOrigin> saleOrigins, Program program, Vessel vessel, QualityFlag qualityFlag, Seller seller, TakeOverType takeOverType, DeclaredDocumentReference declaredDocumentReference, Landing landing, TakeOver takeOver, Collection<Produce> produces, Collection<FishingArea> fishingAreas, Collection<SurveyMeasurement> surveyMeasurements, Collection<SaleMeasurement> saleMeasurements)
        {
            final Sale entity = new SaleImpl();
            entity.setSaleStartDate(saleStartDate);
            entity.setSaleEndDate(saleEndDate);
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setSaleLocation(saleLocation);
            entity.setSaleType(saleType);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setRecorderPerson(recorderPerson);
            entity.setCatchBatch(catchBatch);
            entity.setFishingTrip(fishingTrip);
            entity.setSaleOrigins(saleOrigins);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setQualityFlag(qualityFlag);
            entity.setSeller(seller);
            entity.setTakeOverType(takeOverType);
            entity.setDeclaredDocumentReference(declaredDocumentReference);
            entity.setLanding(landing);
            entity.setTakeOver(takeOver);
            entity.setProduces(produces);
            entity.setFishingAreas(fishingAreas);
            entity.setSurveyMeasurements(surveyMeasurements);
            entity.setSaleMeasurements(saleMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Sale o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getSaleStartDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSaleStartDate().compareTo(o.getSaleStartDate()));
            }
            if (this.getSaleEndDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSaleEndDate().compareTo(o.getSaleEndDate()));
            }
            if (this.getSynchronizationStatus() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSynchronizationStatus().compareTo(o.getSynchronizationStatus()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getValidationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidationDate().compareTo(o.getValidationDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Sale.java merge-point
}