/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaDao;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaUpdateException;
import fr.ifremer.adagio.core.dao.technical.Version;
import fr.ifremer.adagio.core.dao.technical.VersionNotFoundException;
import fr.ifremer.adagio.core.service.DatabaseSchemaService;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.VersionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="databaseSchemaService")
public class DatabaseSchemaServiceImpl
implements DatabaseSchemaService {
    private static final Log log = LogFactory.getLog(DatabaseSchemaServiceImpl.class);
    @Autowired
    private AdagioConfiguration config;
    @Autowired
    protected DatabaseSchemaDao databaseSchemaDao;

    @Override
    public org.nuiton.util.Version getDbVersion() {
        Version version;
        try {
            if (!this.isDbLoaded()) {
                throw new VersionNotFoundException("db is not open");
            }
            version = this.databaseSchemaDao.getSchemaVersion();
        }
        catch (VersionNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not find db version", (Throwable)e);
            }
            version = null;
        }
        return version == null ? null : VersionUtil.valueOf((String)version.toString());
    }

    @Override
    public org.nuiton.util.Version getApplicationVersion() {
        Version version = this.databaseSchemaDao.getSchemaVersionIfUpdate();
        return VersionUtil.valueOf((String)version.toString());
    }

    @Override
    public void updateSchema() {
        try {
            this.databaseSchemaDao.updateSchema();
        }
        catch (DatabaseSchemaUpdateException e) {
            throw new AdagioTechnicalException(e.getCause());
        }
    }

    @Override
    public boolean isDbLoaded() {
        return this.databaseSchemaDao.isDbLoaded();
    }

    @Override
    public boolean isDbExists() {
        return this.databaseSchemaDao.isDbExists();
    }

    @Override
    public void generateStatusReport(File outputFile) throws IOException {
        this.databaseSchemaDao.generateStatusReport(outputFile);
    }

    @Override
    public void generateDiffReport(File outputFile) throws IOException {
        this.databaseSchemaDao.generateDiffReport(outputFile, this.config.getLiquibaseDiffTypes());
    }

    @Override
    public void generateDiffChangeLog(File outputFile) throws IOException {
        this.databaseSchemaDao.generateDiffChangeLog(outputFile, this.config.getLiquibaseDiffTypes());
    }
}

