/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.DaoUtils;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.dao.SynchroTableDaoImpl;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroMetadataUtils;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroBaseService;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import fr.ifremer.adagio.synchro.service.SynchroPendingOperationBuffer;
import fr.ifremer.adagio.synchro.service.SynchroResult;
import fr.ifremer.adagio.synchro.service.SynchroServiceUtils;
import fr.ifremer.adagio.synchro.service.data.DataSynchroService;
import fr.ifremer.adagio.synchro.type.ProgressionModel;
import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.nuiton.i18n.I18n;
import org.nuiton.util.TimeLog;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;

@Service(value="dataSynchroService")
@Lazy
public class DataSynchroServiceImpl
extends SynchroBaseService
implements DataSynchroService {
    private static final Log log = LogFactory.getLog(DataSynchroServiceImpl.class);
    private static final TimeLog TIME = new TimeLog(DataSynchroServiceImpl.class);

    public DataSynchroServiceImpl(DataSource dataSource, SynchroConfiguration config) {
        super(dataSource, config);
    }

    public DataSynchroServiceImpl() {
    }

    @Override
    public SynchroContext createSynchroContext(File sourceDbDirectory) {
        String dbName = this.config.getDbName();
        Properties targetConnectionProperties = this.config.getConnectionProperties();
        Properties sourceConnectionProperties = new Properties(targetConnectionProperties);
        sourceConnectionProperties.setProperty("hibernate.connection.url", DaoUtils.getJdbcUrl(sourceDbDirectory, dbName));
        Set<String> tableToIncludes = this.config.getImportDataTablesIncludes();
        SynchroContext context = SynchroContext.newContext(tableToIncludes, sourceConnectionProperties, targetConnectionProperties, new SynchroResult());
        return context;
    }

    @Override
    public SynchroContext createSynchroContext(Properties sourceConnectionProperties) {
        Properties targetConnectionProperties = this.config.getConnectionProperties();
        Set<String> tableToIncludes = this.config.getImportDataTablesIncludes();
        SynchroContext context = SynchroContext.newContext(tableToIncludes, sourceConnectionProperties, targetConnectionProperties, new SynchroResult());
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(SynchroContext synchroContext) {
        Preconditions.checkNotNull((Object)synchroContext);
        Properties sourceConnectionProperties = synchroContext.getSourceConnectionProperties();
        Preconditions.checkNotNull((Object)sourceConnectionProperties);
        Properties targetConnectionProperties = synchroContext.getTargetConnectionProperties();
        Preconditions.checkNotNull((Object)targetConnectionProperties);
        Set<String> tableNames = synchroContext.getTableNames();
        Predicate<String> tableFilter = synchroContext.getTableFilter();
        if (CollectionUtils.isEmpty(tableNames) && tableFilter == null) {
            log.info((Object)I18n.t((String)"adagio.persistence.synchronizeData.prepare.noTableFilter", (Object[])new Object[0]));
        }
        SynchroResult result = synchroContext.getResult();
        Preconditions.checkNotNull((Object)result);
        result.setLocalUrl(this.getUrl(targetConnectionProperties));
        result.setRemoteUrl(this.getUrl(sourceConnectionProperties));
        Connection targetConnection = null;
        Connection sourceConnection = null;
        try {
            ProgressionModel progressionModel = result.getProgressionModel();
            progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeData.prepare.step1", (Object[])new Object[0]));
            targetConnection = this.createConnection(targetConnectionProperties);
            progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeData.prepare.step2", (Object[])new Object[0]));
            sourceConnection = this.createConnection(sourceConnectionProperties);
            SynchroDatabaseMetadata targetMeta = SynchroDatabaseMetadata.loadDatabaseMetadata(targetConnection, this.getDialect(targetConnectionProperties), this.getConfiguration(targetConnectionProperties), synchroContext, tableNames, tableFilter, null, true);
            SynchroDatabaseMetadata sourceMeta = SynchroDatabaseMetadata.loadDatabaseMetadata(sourceConnection, this.getDialect(sourceConnectionProperties), this.getConfiguration(sourceConnectionProperties), synchroContext, tableNames, tableFilter, null, true);
            progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeData.prepare.step3", (Object[])new Object[0]));
            SynchroServiceUtils.checkSchemas(sourceMeta, targetMeta, true, false, result);
            if (result.isSuccess()) {
                Set<String> rootTableNames = targetMeta.getLoadedRootTableNames();
                if (rootTableNames.size() == 0 && log.isWarnEnabled()) {
                    log.warn((Object)I18n.t((String)"adagio.persistence.synchronizeData.prepare.noRootTable", (Object[])new Object[0]));
                }
                for (String tableName : rootTableNames) {
                    long t0 = TimeLog.getTime();
                    progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeData.prepare.step4", (Object[])new Object[]{tableName}));
                    SynchroTableMetadata sourceTable = sourceMeta.getTable(tableName);
                    SynchroTableMetadata targetTable = targetMeta.getTable(tableName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Prepare table: " + tableName));
                    }
                    this.prepareRootTable(sourceTable, targetTable, sourceConnection, targetConnection, result);
                    TIME.log(t0, "prepare table " + tableName);
                }
                long totalRows = result.getTotalRows();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Total rows to update: " + totalRows));
                }
                targetConnection.rollback();
            }
            this.releaseConnection(sourceConnection);
            this.releaseConnection(targetConnection);
        }
        catch (SQLException e) {
            try {
                if (targetConnection != null) {
                    targetConnection.rollback();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            result.setError(e);
        }
        finally {
            this.releaseConnection(sourceConnection);
            this.releaseConnection(targetConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(SynchroContext synchroContext) {
        Preconditions.checkNotNull((Object)synchroContext);
        Properties sourceConnectionProperties = synchroContext.getSourceConnectionProperties();
        Preconditions.checkNotNull((Object)sourceConnectionProperties);
        Properties targetConnectionProperties = synchroContext.getTargetConnectionProperties();
        Preconditions.checkNotNull((Object)targetConnectionProperties);
        Set<String> tableNames = synchroContext.getTableNames();
        Predicate<String> tableFilter = synchroContext.getTableFilter();
        SynchroResult result = synchroContext.getResult();
        Preconditions.checkNotNull((Object)result);
        Connection targetConnection = null;
        Connection sourceConnection = null;
        try {
            sourceConnection = this.createConnection(sourceConnectionProperties);
            targetConnection = this.createConnection(targetConnectionProperties);
            Predicate<SynchroColumnMetadata> columnFilter = null;
            if (!result.getMissingOptionalColumnNameMaps().isEmpty()) {
                columnFilter = SynchroMetadataUtils.newExcludeColumnPredicate(result.getMissingOptionalColumnNameMaps());
            }
            SynchroDatabaseMetadata dbMetas = SynchroDatabaseMetadata.loadDatabaseMetadata(targetConnection, this.getDialect(targetConnectionProperties), this.getConfiguration(targetConnectionProperties), synchroContext, tableNames, tableFilter, columnFilter, true);
            ProgressionModel progressionModel = result.getProgressionModel();
            progressionModel.setTotal(result.getTotalRows());
            for (String tableName : dbMetas.getLoadedRootTableNames()) {
                long countToUpdate;
                SynchroTableMetadata table = dbMetas.getTable(tableName);
                long t0 = TimeLog.getTime();
                progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeData.synchronize.step1", (Object[])new Object[]{tableName}));
                if (log.isInfoEnabled()) {
                    log.info((Object)("Synchronize root table: " + tableName));
                }
                if ((countToUpdate = (long)result.getNbRows(tableName)) <= 0L) continue;
                SynchroPendingOperationBuffer tableBuffer = new SynchroPendingOperationBuffer(tableName);
                this.synchronizeRootTable(table, synchroContext, sourceConnection, targetConnection, result, tableBuffer);
                TIME.log(t0, "synchronize table " + tableName);
                if (tableBuffer.isEmpty()) continue;
                Set<Integer> updatedRemoteIds = tableBuffer.getRemoteIdsMap().keySet();
                this.synchronizeChildTables(table, updatedRemoteIds, synchroContext, sourceConnection, targetConnection, result, true);
            }
            if (log.isInfoEnabled()) {
                long totalInserts = result.getTotalInserts();
                long totalUpdates = result.getTotalUpdates();
                log.info((Object)("Total rows to treat: " + result.getTotalRows()));
                log.info((Object)("Total rows inserted: " + totalInserts));
                log.info((Object)("Total rows  updated: " + totalUpdates));
                log.info((Object)("Total rows  treated: " + (totalInserts + totalUpdates)));
            }
            progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeData.synchronize.step2", (Object[])new Object[0]));
            targetConnection.commit();
        }
        catch (SQLException e) {
            try {
                if (targetConnection != null) {
                    targetConnection.rollback();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            result.setError(e);
        }
        catch (Exception e) {
            try {
                if (targetConnection != null) {
                    targetConnection.rollback();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            result.setError(e);
        }
        finally {
            this.releaseConnection(sourceConnection);
            this.releaseConnection(targetConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareRootTable(SynchroTableMetadata sourceTable, SynchroTableMetadata targetTable, Connection sourceConnection, Connection targetConnection, SynchroResult result) throws SQLException {
        String tablePrefix = sourceTable.getTableLogPrefix();
        String tableName = sourceTable.getName();
        SynchroTableDaoImpl targetDao = new SynchroTableDaoImpl(targetConnection, targetTable, false);
        SynchroTableDaoImpl sourceDao = new SynchroTableDaoImpl(sourceConnection, sourceTable, false);
        try {
            Timestamp updateDate = targetDao.getLastUpdateDate();
            if (updateDate != null) {
                updateDate = new Timestamp(DateUtils.setMilliseconds((Date)updateDate, (int)0).getTime());
                updateDate = new Timestamp(DateUtils.addSeconds((Date)updateDate, (int)1).getTime());
            }
            long countToUpdate = sourceDao.countDataToUpdate(updateDate);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("%s nb rows to update: %s", tablePrefix, countToUpdate));
            }
            result.setUpdateDate(tableName, updateDate);
            result.addRows(tableName, (int)countToUpdate);
        }
        finally {
            IOUtils.closeQuietly((Closeable)targetDao);
            IOUtils.closeQuietly((Closeable)sourceDao);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeRootTable(SynchroTableMetadata table, SynchroContext context, Connection sourceConnection, Connection targetConnection, SynchroResult result, SynchroPendingOperationBuffer tableBuffer) throws SQLException {
        String tableName = table.getName();
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.persistence.synchronizeData.synchronizeTable", (Object[])new Object[]{tableName}));
        SynchroTableDaoImpl sourceDao = new SynchroTableDaoImpl(sourceConnection, table, false);
        SynchroTableDaoImpl targetDao = new SynchroTableDaoImpl(targetConnection, table, true);
        Timestamp updateDate = result.getUpdateDate(tableName);
        ResultSet dataToUpdate = null;
        try {
            dataToUpdate = sourceDao.getDataToUpdate(updateDate);
            this.updateTableUsingRemoteId(targetDao, dataToUpdate, result, tableBuffer);
        }
        finally {
            DaoUtils.closeSilently(dataToUpdate);
            IOUtils.closeQuietly((Closeable)targetDao);
            IOUtils.closeQuietly((Closeable)sourceDao);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeChildTable(SynchroTableMetadata table, String joinColumnName, Set<Integer> joinColumnIds, Connection sourceConnection, Connection targetConnection, SynchroResult result, SynchroPendingOperationBuffer tableBuffer) throws SQLException {
        String tableName = table.getName();
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.persistence.synchronizeData.synchronizeTable", (Object[])new Object[]{tableName}));
        SynchroTableDaoImpl sourceDao = new SynchroTableDaoImpl(sourceConnection, table, false);
        SynchroTableDaoImpl targetDao = new SynchroTableDaoImpl(targetConnection, table, true);
        try {
            ResultSet dataToUpdate = sourceDao.getDataByFk(joinColumnName, joinColumnIds);
            try {
                if (table.isWithRemoteIdColumn()) {
                    this.updateTableUsingRemoteId(targetDao, dataToUpdate, result, tableBuffer);
                } else {
                    this.updateTableNoRemoteId(targetDao, dataToUpdate, result, tableBuffer);
                }
            }
            finally {
                DaoUtils.closeSilently(dataToUpdate);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)targetDao);
            IOUtils.closeQuietly((Closeable)sourceDao);
        }
    }

    protected void updateTableUsingRemoteId(SynchroTableDao targetDao, ResultSet incomingData, SynchroResult result, SynchroPendingOperationBuffer tableBuffer) throws SQLException {
        SynchroTableMetadata table = targetDao.getTable();
        Preconditions.checkArgument((boolean)table.isWithRemoteIdColumn());
        boolean enableGeneratedIdFirst = table.getInsertStrategy() == SynchroTableMetadata.TableInsertStrategy.GENERATE_ID_FIRST;
        String tableName = table.getName();
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        Map<Integer, Integer> existingRemoteIdsMap = targetDao.getExistingRemoteIdsMap();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " existing rows: " + existingRemoteIdsMap.size()));
        }
        result.addTableName(tableName);
        int countR = 0;
        while (incomingData.next()) {
            boolean doUpdate;
            Integer remoteId = table.getId(incomingData);
            Integer localId = existingRemoteIdsMap.get(remoteId);
            boolean bl = doUpdate = localId != null;
            if (doUpdate) {
                ArrayList pk = Lists.newArrayList((Object[])new Object[]{localId});
                targetDao.executeUpdate((List<Object>)pk, incomingData);
            } else if (enableGeneratedIdFirst) {
                localId = targetDao.executeInsertAndReturnId(incomingData);
            } else {
                targetDao.executeInsert(incomingData);
            }
            this.reportProgress(result, targetDao, ++countR, tablePrefix);
        }
        targetDao.flush();
        int insertCount = targetDao.getInsertCount();
        int updateCount = targetDao.getUpdateCount();
        result.addInserts(tableName, insertCount);
        result.addUpdates(tableName, updateCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (inserts: %s, updates: %s)", tablePrefix, insertCount + updateCount, insertCount, updateCount));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s INSERT count: %s", tablePrefix, insertCount));
            log.debug((Object)String.format("%s UPDATE count: %s", tablePrefix, updateCount));
        }
        result.getProgressionModel().increments(countR % 1000);
    }

    protected void updateTableNoRemoteId(SynchroTableDao targetDao, ResultSet incomingData, SynchroResult result, SynchroPendingOperationBuffer tableBuffer) throws SQLException {
        SynchroTableMetadata table = targetDao.getTable();
        Preconditions.checkArgument((!table.isWithRemoteIdColumn() ? 1 : 0) != 0);
        String tableName = table.getName();
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        Set<String> existingIds = targetDao.getExistingPrimaryKeys();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " existing rows: " + existingIds.size()));
        }
        result.addTableName(tableName);
        int countR = 0;
        boolean hasChildTables = table.hasChildJoins();
        ArrayList updatedPks = null;
        if (hasChildTables) {
            updatedPks = Lists.newArrayList();
        }
        while (incomingData.next()) {
            List<Object> pk = targetDao.getPk(incomingData);
            String pkStr = table.toPkStr(pk);
            boolean doUpdate = existingIds.contains(pkStr);
            if (doUpdate) {
                targetDao.executeUpdate(pk, incomingData);
            } else {
                targetDao.executeInsert(incomingData);
            }
            if (hasChildTables) {
                updatedPks.add(pk);
            }
            this.reportProgress(result, targetDao, ++countR, tablePrefix);
        }
        targetDao.flush();
        if (hasChildTables && !updatedPks.isEmpty()) {
            tableBuffer.addPks(updatedPks);
        }
        int insertCount = targetDao.getInsertCount();
        int updateCount = targetDao.getUpdateCount();
        result.addInserts(tableName, insertCount);
        result.addUpdates(tableName, updateCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (inserts: %s, updates: %s)", tablePrefix, insertCount + updateCount, insertCount, updateCount));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s INSERT count: %s", tablePrefix, insertCount));
            log.debug((Object)String.format("%s UPDATE count: %s", tablePrefix, updateCount));
        }
        result.getProgressionModel().increments(countR % 1000);
    }

    Connection createConnection(Properties connectionProperties) throws SQLException {
        return this.createConnection(connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    String getUrl(Properties connectionProperties) {
        return connectionProperties.getProperty("hibernate.connection.url");
    }

    Dialect getDialect(Properties connectionProperties) {
        return Dialect.getDialect((Properties)connectionProperties);
    }

    Configuration getConfiguration(Properties connectionProperties) {
        return new Configuration().setProperties(connectionProperties);
    }

    Connection createConnection(String jdbcUrl, String user, String password) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)jdbcUrl));
        if (jdbcUrl.equals(this.config.getJdbcURL()) && this.dataSource != null) {
            return DataSourceUtils.getConnection((DataSource)this.dataSource);
        }
        Connection connection = DriverManager.getConnection(jdbcUrl, user, password);
        connection.setAutoCommit(false);
        return connection;
    }

    void releaseConnection(Connection connection) {
        DaoUtils.closeSilently(connection);
    }

    protected Properties getRemoteProperties(File dbDirectory) {
        Properties sourceConnectionProperties = new Properties();
        SynchroConfiguration config = SynchroConfiguration.getInstance();
        String jdbcUrl = DaoUtils.getJdbcUrl(dbDirectory, config.getDbName());
        DaoUtils.fillConnectionProperties(sourceConnectionProperties, jdbcUrl, config.getJdbcUsername(), config.getJdbcPassword());
        return sourceConnectionProperties;
    }

    protected void synchronizeChildTables(SynchroTableMetadata parentTable, Set<Integer> parentRemoteIds, SynchroContext context, Connection sourceConnection, Connection targetConnection, SynchroResult result, boolean enableLogCount) throws SQLException {
        Preconditions.checkNotNull((Object)parentTable);
        Preconditions.checkNotNull(parentRemoteIds);
        Preconditions.checkArgument((!parentRemoteIds.isEmpty() ? 1 : 0) != 0);
        ArrayList updatedTables = Lists.newArrayList();
        ArrayList updatedTablesBuffers = Lists.newArrayList();
        for (SynchroJoinMetadata join : parentTable.getChildJoins()) {
            long t0 = TimeLog.getTime();
            SynchroTableMetadata table = join.getTargetTable();
            String tableName = table.getName();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Synchronize table: %s (as child of %s)", tableName, parentTable.getName()));
            }
            SynchroPendingOperationBuffer penginOperationBuffer = new SynchroPendingOperationBuffer(tableName);
            String joinColumnName = join.getTargetColumn().getName();
            this.synchronizeChildTable(table, joinColumnName, parentRemoteIds, sourceConnection, targetConnection, result, penginOperationBuffer);
            TIME.log(t0, "synchronize table " + tableName);
            if (penginOperationBuffer.isEmpty()) continue;
            updatedTables.add(table);
            updatedTablesBuffers.add(penginOperationBuffer);
        }
        for (int i = 0; i < updatedTables.size(); ++i) {
            SynchroTableMetadata table = (SynchroTableMetadata)updatedTables.get(i);
            SynchroPendingOperationBuffer tableBuffer = (SynchroPendingOperationBuffer)updatedTablesBuffers.get(i);
            Set<Integer> updatedRemoteIds = tableBuffer.getRemoteIdsMap().keySet();
            this.synchronizeChildTables(table, updatedRemoteIds, context, sourceConnection, targetConnection, result, false);
        }
    }
}

