/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.DefineDataSourceSetUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.mozilla.javascript.Scriptable;

class QueryExecutionHelper {
    private DataEngine dataEngine;
    private IModelAdapter modelAdaptor;
    private DataSessionContext sessionContext;
    private boolean useResultHints;
    private DataSetHandle major;
    private DataRequestSession session;

    QueryExecutionHelper(DataEngine dataEngine, IModelAdapter modelAdaptor, DataSessionContext sessionContext, DataRequestSession session) {
        this(dataEngine, modelAdaptor, sessionContext, true, session);
    }

    QueryExecutionHelper(DataEngine dataEngine, IModelAdapter modelAdaptor, DataSessionContext sessionContext, boolean useResultHints, DataRequestSession session) {
        this.dataEngine = dataEngine;
        this.modelAdaptor = modelAdaptor;
        this.sessionContext = sessionContext;
        this.useResultHints = useResultHints;
        this.session = session;
    }

    IQueryResults executeQuery(IQueryDefinition queryDefn) throws BirtException {
        return this.executeQuery(queryDefn, null, null, null, null);
    }

    IQueryResults executeQuery(IQueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt, Scriptable scope) throws BirtException {
        return this.executeQuery(queryDefn, paramBindingIt, filterIt, bindingIt, true, false, scope);
    }

    IQueryResults executeQuery(IQueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt, boolean keepDataSetFilter, boolean disAllowAggregation, Scriptable scope) throws BirtException {
        this.populateQueryDefn(queryDefn, paramBindingIt, filterIt, bindingIt, disAllowAggregation);
        this.defineDataSourceDataSet(queryDefn, keepDataSetFilter, disAllowAggregation);
        return this.dataEngine.prepare(queryDefn, this.sessionContext.getAppContext()).execute(scope);
    }

    private void defineDataSourceDataSet(IQueryDefinition queryDefn, boolean keepDataSetFilter, boolean allowAggregation) throws AdapterException, BirtException {
        String dataSetName = queryDefn.getDataSetName();
        ModuleHandle module = this.sessionContext.getModuleHandle();
        if (module != null) {
            List l = module.getAllDataSets();
            DataSetHandle handle = null;
            int i = 0;
            while (i < l.size()) {
                if (((DataSetHandle)l.get(i)).getQualifiedName() != null && ((DataSetHandle)l.get(i)).getQualifiedName().equals(dataSetName)) {
                    handle = (DataSetHandle)l.get(i);
                    break;
                }
                ++i;
            }
            this.major = handle;
            this.defineDataSet(handle, new DataSetHandleProcessContext(this.major, this.useResultHints, keepDataSetFilter, allowAggregation));
            DefineDataSourceSetUtil.prepareForTransientQuery(this.sessionContext, (DataEngineImpl)this.dataEngine, handle, queryDefn, null);
        }
    }

    private void populateQueryDefn(IQueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt, boolean disAllowAggregation) throws AdapterException {
        try {
            List filters;
            while (bindingIt != null && bindingIt.hasNext()) {
                Object computedBinding = bindingIt.next();
                IBinding binding = null;
                if (computedBinding instanceof ComputedColumnHandle) {
                    binding = this.modelAdaptor.adaptBinding((ComputedColumnHandle)computedBinding);
                } else if (computedBinding instanceof ComputedColumn) {
                    binding = this.adaptBinding((ComputedColumn)computedBinding);
                }
                if (binding == null || disAllowAggregation && binding.getAggrFunction() != null) continue;
                queryDefn.addBinding(binding);
            }
            List parameterBindings = this.convertParamterBindings(paramBindingIt);
            if (parameterBindings != null) {
                queryDefn.getInputParamBindings().addAll(parameterBindings);
            }
            if ((filters = this.convertFilters(filterIt)) != null) {
                queryDefn.getFilters().addAll(filters);
            }
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private IBinding adaptBinding(ComputedColumn structure) {
        block4: {
            try {
                if (structure != null) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        Binding result = new Binding(structure.getName());
        if (structure.getExpression() != null) {
            ScriptExpression expr = this.modelAdaptor.adaptExpression(structure.getExpressionProperty("expression"));
            result.setExpression(expr);
        }
        result.setDisplayName(structure.getDisplayName());
        result.setDataType(DataAdapterUtil.adaptModelDataType(structure.getDataType()));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private List convertFilters(Iterator filterIt) throws AdapterException {
        if (filterIt == null) {
            return null;
        }
        filters = new ArrayList<FilterDefinition>();
        ** GOTO lbl10
        {
            filter = this.modelAdaptor.adaptFilter((FilterConditionHandle)filterIt.next());
            filters.add(filter);
            do {
                if (filterIt.hasNext()) continue block0;
lbl10:
                // 2 sources

            } while (filterIt.hasNext());
        }
        return filters;
    }

    private List convertParamterBindings(Iterator paramBindingIt) {
        if (paramBindingIt == null) {
            return null;
        }
        ArrayList<InputParameterBinding> parameterBindings = new ArrayList<InputParameterBinding>();
        while (paramBindingIt.hasNext()) {
            InputParameterBinding inputParamBinding;
            StructureHandle paramBinding;
            Object paramObj = paramBindingIt.next();
            if (paramObj instanceof ParamBindingHandle) {
                paramBinding = (ParamBindingHandle)paramObj;
                if (((ParamBindingHandle)paramBinding).getExpression() == null) continue;
                ScriptExpression paramValueExpr = new ScriptExpression(((ParamBindingHandle)paramBinding).getExpression());
                inputParamBinding = new InputParameterBinding(((ParamBindingHandle)paramBinding).getParamName(), (IBaseExpression)paramValueExpr);
                parameterBindings.add(inputParamBinding);
                continue;
            }
            if (!(paramObj instanceof OdaDataSetParameterHandle)) continue;
            if (((OdaDataSetParameterHandle)paramObj).getParamName() != null) {
                String defaultValueExpr = ExpressionUtil.createJSParameterExpression(((OdaDataSetParameterHandle)paramObj).getParamName());
                InputParameterBinding inputParamBinding2 = new InputParameterBinding(((OdaDataSetParameterHandle)paramObj).getName(), (IBaseExpression)this.modelAdaptor.adaptExpression(defaultValueExpr, ((OdaDataSetParameterHandle)paramObj).getDataType()));
                parameterBindings.add(inputParamBinding2);
                continue;
            }
            paramBinding = (OdaDataSetParameterHandle)paramObj;
            ExpressionHandle handle = paramBinding.getExpressionProperty("defaultValue");
            inputParamBinding = new InputParameterBinding(((DataSetParameterHandle)paramBinding).getName(), (IBaseExpression)this.session.getModelAdaptor().adaptExpression((Expression)handle.getValue()));
            parameterBindings.add(inputParamBinding);
        }
        return parameterBindings;
    }

    private void defineDataSet(DataSetHandle handle, DataSetHandleProcessContext procesCtx) throws AdapterException, BirtException {
        if (handle == null) {
            return;
        }
        DefineDataSourceSetUtil.defineDataSourceAndDataSet(handle, this.dataEngine, this.modelAdaptor, procesCtx);
        this.preDefineDataSet(handle);
    }

    private void preDefineDataSet(DataSetHandle handle) throws BirtException {
        if (handle instanceof JointDataSetHandle) {
            Iterator iter = ((JointDataSetHandle)handle).dataSetsIterator();
            while (iter.hasNext()) {
                DataSetHandle dsHandle = (DataSetHandle)iter.next();
                if (dsHandle == null) continue;
                this.preDefineDataSet(dsHandle);
            }
        }
        if (handle instanceof DerivedDataSetHandle) {
            List<DataSetHandle> inputDataSet = ((DerivedDataSetHandle)handle).getInputDataSets();
            int i = 0;
            while (i < inputDataSet.size()) {
                this.preDefineDataSet(inputDataSet.get(i));
                ++i;
            }
        }
    }

    static class DataSetHandleProcessContext {
        private DataSetHandle root;
        private boolean useResultHints;
        private boolean keepDataSetFilters;
        private boolean allowAggregations;

        public DataSetHandleProcessContext(DataSetHandle handle, boolean useResultHints, boolean keepDataSetFilters, boolean allowAggregations) {
            this.root = handle;
            this.useResultHints = useResultHints;
            this.keepDataSetFilters = keepDataSetFilters;
            this.allowAggregations = allowAggregations;
        }

        public void process(IBaseDataSetDesign baseDataSetDesign, DataSetHandle current) {
            this.processUseResultHints(baseDataSetDesign, current);
            this.processFilters(baseDataSetDesign, current);
            this.processAggregations(baseDataSetDesign, current);
        }

        protected void processUseResultHints(IBaseDataSetDesign baseDataSetDesign, DataSetHandle current) {
            if (!this.useResultHints && current.equals(this.root)) {
                baseDataSetDesign.getResultSetHints().clear();
            }
        }

        protected void processFilters(IBaseDataSetDesign baseDataSetDesign, DataSetHandle current) {
            if (!this.keepDataSetFilters && baseDataSetDesign.getFilters() != null) {
                baseDataSetDesign.getFilters().clear();
            }
        }

        protected void processAggregations(IBaseDataSetDesign baseDataSetDesign, DataSetHandle current) {
            List computedColumns;
            if (this.allowAggregations && (computedColumns = baseDataSetDesign.getComputedColumns()) != null && computedColumns.size() != 0) {
                int i = 0;
                while (i < computedColumns.size()) {
                    IComputedColumn computedColumn = (IComputedColumn)computedColumns.get(i);
                    if (computedColumn.getAggregateFunction() != null) {
                        computedColumns.set(i, new org.eclipse.birt.data.engine.api.querydefn.ComputedColumn(computedColumn.getName(), "null"));
                    }
                    ++i;
                }
            }
        }
    }
}

