/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import org.apache.poi.openxml4j.util.Nullable;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument;
import org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.PropertiesDocument;

public class POIXMLProperties {
    private OPCPackage pkg;
    private CoreProperties core;
    private ExtendedProperties ext;
    private CustomProperties cust;
    private PackagePart extPart;
    private PackagePart custPart;
    private static final PropertiesDocument NEW_EXT_INSTANCE = PropertiesDocument.Factory.newInstance();
    private static final org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument NEW_CUST_INSTANCE;

    public POIXMLProperties(OPCPackage docPackage) throws IOException, OpenXML4JException, XmlException {
        this.pkg = docPackage;
        this.core = new CoreProperties((PackagePropertiesPart)this.pkg.getPackageProperties());
        PackageRelationshipCollection extRel = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
        if (extRel.size() == 1) {
            this.extPart = this.pkg.getPart(extRel.getRelationship(0));
            PropertiesDocument props = PropertiesDocument.Factory.parse(this.extPart.getInputStream());
            this.ext = new ExtendedProperties(props);
        } else {
            this.extPart = null;
            this.ext = new ExtendedProperties((PropertiesDocument)NEW_EXT_INSTANCE.copy());
        }
        PackageRelationshipCollection custRel = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties");
        if (custRel.size() == 1) {
            this.custPart = this.pkg.getPart(custRel.getRelationship(0));
            org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument props = PropertiesDocument.Factory.parse(this.custPart.getInputStream());
            this.cust = new CustomProperties(props);
        } else {
            this.custPart = null;
            this.cust = new CustomProperties((org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument)NEW_CUST_INSTANCE.copy());
        }
    }

    public CoreProperties getCoreProperties() {
        return this.core;
    }

    public ExtendedProperties getExtendedProperties() {
        return this.ext;
    }

    public CustomProperties getCustomProperties() {
        return this.cust;
    }

    public void commit() throws IOException {
        OutputStream out;
        HashMap<String, String> map;
        XmlOptions xmlOptions;
        PackagePartName prtname;
        if (this.extPart == null && !NEW_EXT_INSTANCE.toString().equals(this.ext.props.toString())) {
            try {
                prtname = PackagingURIHelper.createPartName("/docProps/app.xml");
                this.pkg.addRelationship(prtname, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
                this.extPart = this.pkg.createPart(prtname, "application/vnd.openxmlformats-officedocument.extended-properties+xml");
            }
            catch (InvalidFormatException e) {
                throw new POIXMLException(e);
            }
        }
        if (this.custPart == null && !NEW_CUST_INSTANCE.toString().equals(this.cust.props.toString())) {
            try {
                prtname = PackagingURIHelper.createPartName("/docProps/custom.xml");
                this.pkg.addRelationship(prtname, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties");
                this.custPart = this.pkg.createPart(prtname, "application/vnd.openxmlformats-officedocument.custom-properties+xml");
            }
            catch (InvalidFormatException e) {
                throw new POIXMLException(e);
            }
        }
        if (this.extPart != null) {
            xmlOptions = new XmlOptions(POIXMLDocumentPart.DEFAULT_XML_OPTIONS);
            map = new HashMap<String, String>();
            map.put("http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes", "vt");
            xmlOptions.setSaveSuggestedPrefixes(map);
            out = this.extPart.getOutputStream();
            this.ext.props.save(out, xmlOptions);
            out.close();
        }
        if (this.custPart != null) {
            xmlOptions = new XmlOptions(POIXMLDocumentPart.DEFAULT_XML_OPTIONS);
            map = new HashMap();
            map.put("http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes", "vt");
            xmlOptions.setSaveSuggestedPrefixes(map);
            out = this.custPart.getOutputStream();
            this.cust.props.save(out, xmlOptions);
            out.close();
        }
    }

    static {
        NEW_EXT_INSTANCE.addNewProperties();
        NEW_CUST_INSTANCE = PropertiesDocument.Factory.newInstance();
        NEW_CUST_INSTANCE.addNewProperties();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CoreProperties {
        private PackagePropertiesPart part;

        private CoreProperties(PackagePropertiesPart part) {
            this.part = part;
        }

        public String getCategory() {
            return this.part.getCategoryProperty().getValue();
        }

        public void setCategory(String category) {
            this.part.setCategoryProperty(category);
        }

        public String getContentStatus() {
            return this.part.getContentStatusProperty().getValue();
        }

        public void setContentStatus(String contentStatus) {
            this.part.setContentStatusProperty(contentStatus);
        }

        public String getContentType() {
            return this.part.getContentTypeProperty().getValue();
        }

        public void setContentType(String contentType) {
            this.part.setContentTypeProperty(contentType);
        }

        public Date getCreated() {
            return this.part.getCreatedProperty().getValue();
        }

        public void setCreated(Nullable<Date> date) {
            this.part.setCreatedProperty(date);
        }

        public void setCreated(String date) {
            this.part.setCreatedProperty(date);
        }

        public String getCreator() {
            return this.part.getCreatorProperty().getValue();
        }

        public void setCreator(String creator) {
            this.part.setCreatorProperty(creator);
        }

        public String getDescription() {
            return this.part.getDescriptionProperty().getValue();
        }

        public void setDescription(String description) {
            this.part.setDescriptionProperty(description);
        }

        public String getIdentifier() {
            return this.part.getIdentifierProperty().getValue();
        }

        public void setIdentifier(String identifier) {
            this.part.setIdentifierProperty(identifier);
        }

        public String getKeywords() {
            return this.part.getKeywordsProperty().getValue();
        }

        public void setKeywords(String keywords) {
            this.part.setKeywordsProperty(keywords);
        }

        public Date getLastPrinted() {
            return this.part.getLastPrintedProperty().getValue();
        }

        public void setLastPrinted(Nullable<Date> date) {
            this.part.setLastPrintedProperty(date);
        }

        public void setLastPrinted(String date) {
            this.part.setLastPrintedProperty(date);
        }

        public Date getModified() {
            return this.part.getModifiedProperty().getValue();
        }

        public void setModified(Nullable<Date> date) {
            this.part.setModifiedProperty(date);
        }

        public void setModified(String date) {
            this.part.setModifiedProperty(date);
        }

        public String getSubject() {
            return this.part.getSubjectProperty().getValue();
        }

        public void setSubjectProperty(String subject) {
            this.part.setSubjectProperty(subject);
        }

        public void setTitle(String title) {
            this.part.setTitleProperty(title);
        }

        public String getTitle() {
            return this.part.getTitleProperty().getValue();
        }

        public String getRevision() {
            return this.part.getRevisionProperty().getValue();
        }

        public void setRevision(String revision) {
            try {
                Long.valueOf(revision);
                this.part.setRevisionProperty(revision);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public PackagePropertiesPart getUnderlyingProperties() {
            return this.part;
        }
    }

    public class CustomProperties {
        public static final String FORMAT_ID = "{D5CDD505-2E9C-101B-9397-08002B2CF9AE}";
        private org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument props;

        private CustomProperties(org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument props) {
            this.props = props;
        }

        public CTProperties getUnderlyingProperties() {
            return this.props.getProperties();
        }

        private CTProperty add(String name) {
            if (this.contains(name)) {
                throw new IllegalArgumentException("A property with this name already exists in the custom properties");
            }
            CTProperty p = this.props.getProperties().addNewProperty();
            int pid = this.nextPid();
            p.setPid(pid);
            p.setFmtid(FORMAT_ID);
            p.setName(name);
            return p;
        }

        public void addProperty(String name, String value) {
            CTProperty p = this.add(name);
            p.setLpwstr(value);
        }

        public void addProperty(String name, double value) {
            CTProperty p = this.add(name);
            p.setR8(value);
        }

        public void addProperty(String name, int value) {
            CTProperty p = this.add(name);
            p.setI4(value);
        }

        public void addProperty(String name, boolean value) {
            CTProperty p = this.add(name);
            p.setBool(value);
        }

        protected int nextPid() {
            int propid = 1;
            for (CTProperty p : this.props.getProperties().getPropertyList()) {
                if (p.getPid() <= propid) continue;
                propid = p.getPid();
            }
            return propid + 1;
        }

        public boolean contains(String name) {
            for (CTProperty p : this.props.getProperties().getPropertyList()) {
                if (!p.getName().equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    public class ExtendedProperties {
        private PropertiesDocument props;

        private ExtendedProperties(PropertiesDocument props) {
            this.props = props;
        }

        public org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties getUnderlyingProperties() {
            return this.props.getProperties();
        }
    }
}

