/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardMethodMetadata
implements MethodMetadata {
    private final Method introspectedMethod;
    private final boolean nestedAnnotationsAsMap;

    public StandardMethodMetadata(Method introspectedMethod) {
        this(introspectedMethod, false);
    }

    public StandardMethodMetadata(Method introspectedMethod, boolean nestedAnnotationsAsMap) {
        Assert.notNull(introspectedMethod, "Method must not be null");
        this.introspectedMethod = introspectedMethod;
        this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
    }

    public final Method getIntrospectedMethod() {
        return this.introspectedMethod;
    }

    @Override
    public String getMethodName() {
        return this.introspectedMethod.getName();
    }

    @Override
    public String getDeclaringClassName() {
        return this.introspectedMethod.getDeclaringClass().getName();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && !Modifier.isPrivate(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.introspectedMethod.getAnnotations()) {
            if (ann.annotationType().getName().equals(annotationType)) {
                return true;
            }
            for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
                if (!metaAnn.annotationType().getName().equals(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.introspectedMethod.getAnnotations()) {
            if (ann.annotationType().getName().equals(annotationType)) {
                return AnnotationUtils.getAnnotationAttributes(ann, true, this.nestedAnnotationsAsMap);
            }
            for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
                if (!metaAnn.annotationType().getName().equals(annotationType)) continue;
                return AnnotationUtils.getAnnotationAttributes(metaAnn, true, this.nestedAnnotationsAsMap);
            }
        }
        return null;
    }
}

