/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import org.eclipse.birt.chart.factory.DataRowExpressionEvaluatorAdapter;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;

public final class BIRTQueryResultSetEvaluator
extends DataRowExpressionEvaluatorAdapter {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.reportitem/trace");
    private IQueryResultSet set;

    public BIRTQueryResultSetEvaluator(IQueryResultSet set) {
        this.set = set;
    }

    @Override
    public Object evaluate(String expression) {
        try {
            this.exprCodec.decode(expression);
            if (this.exprCodec.isConstant()) {
                return this.exprCodec.getExpression();
            }
            return this.set.evaluate(this.exprCodec.getType(), this.exprCodec.getExpression());
        }
        catch (BirtException e) {
            logger.log(e);
            return null;
        }
    }

    @Override
    public Object evaluateGlobal(String expression) {
        return this.evaluate(expression);
    }

    @Override
    public boolean next() {
        try {
            return this.set.next();
        }
        catch (BirtException e) {
            logger.log(e);
            return false;
        }
    }

    @Override
    public void close() {
        this.set.close();
    }

    @Override
    public boolean first() {
        try {
            return this.set.next();
        }
        catch (BirtException e) {
            logger.log(e);
            return false;
        }
    }
}

