/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.TuttiValidationDataContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import java.util.ArrayList;
import java.util.List;

public class GenericFormatImportValidationDataContext
extends TuttiValidationDataContextSupport {
    private Cruise cruise;
    private TuttiProtocol protocol;
    private FishingOperation fishingOperation;
    private final GenericFormatImportContext importContext;

    public GenericFormatImportValidationDataContext(GenericFormatImportContext importContext) {
        this.importContext = importContext;
    }

    @Override
    protected List<Program> loadExistingPrograms() {
        return Lists.newArrayList();
    }

    @Override
    protected List<TuttiProtocol> loadExistingProtocols() {
        return Lists.newArrayList();
    }

    @Override
    protected List<FishingOperation> loadExistingFishingOperations() {
        ArrayList<FishingOperation> result = new ArrayList<FishingOperation>();
        if (this.cruise != null) {
            GenericFormatImportCruiseContext cruiseContext = this.importContext.getCruiseContext(this.cruise);
            Iterable<FishingOperation> importedFishingOperations = cruiseContext.getFishingOperations();
            Iterables.addAll(result, importedFishingOperations);
            if (this.fishingOperation != null) {
                result.remove(this.fishingOperation);
            }
        }
        return result;
    }

    @Override
    protected Program getProgram() {
        return this.importContext.getImportRequest().getProgram();
    }

    @Override
    protected Cruise getCruise() {
        return this.cruise;
    }

    @Override
    protected TuttiProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    protected FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
        this.resetExistingFishingOperations();
    }

    public void setProtocol(TuttiProtocol protocol) {
        this.protocol = protocol;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
        this.resetExistingFishingOperations();
    }
}

