/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatResultSupport;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class GenericFormatImportResult
extends GenericFormatResultSupport {
    private static final long serialVersionUID = 1L;
    private final Map<String, GenericFormatImportCruiseResult> cruiseResults = new LinkedHashMap<String, GenericFormatImportCruiseResult>();

    public GenericFormatImportResult(GenericFormatImportContext importContext) {
        super(importContext);
    }

    public Set<Cruise> getImportedCruises() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.cruiseResults.values(), GenericFormatImportCruiseResult.TO_CRUISE_FUNCTION));
    }

    public Cruise getCruise(Cruise importRowCruise) {
        Cruise result = null;
        for (GenericFormatImportCruiseResult importCruiseResult : this.cruiseResults.values()) {
            Cruise cruise = importCruiseResult.getCruise();
            boolean equals = Cruises.equals((Cruise)importRowCruise, (Cruise)cruise);
            if (!equals) continue;
            result = cruise;
            break;
        }
        return result;
    }

    public GenericFormatImportCruiseResult getImportedCruiseResult(String cruiseId) {
        return this.cruiseResults.get(cruiseId);
    }

    public Set<FishingOperation> getImportedFishingOperations(Cruise cruise) {
        GenericFormatImportCruiseResult importCruiseResult = this.getImportedCruiseResult(cruise.getId());
        return ImmutableSet.copyOf(importCruiseResult.getFishingOperations());
    }

    public Collection<String> getImportedFishingOperationIds(Cruise cruise) {
        GenericFormatImportCruiseResult importCruiseResult = this.getImportedCruiseResult(cruise.getId());
        return ImmutableSet.copyOf(importCruiseResult.getFishingOperationIds());
    }

    public void addFishingOperationCheckError(Cruise cruise, String fishingOperationId, String checkError) {
        GenericFormatImportCruiseResult importedCruiseResult = this.getImportedCruiseResult(cruise.getId());
        GenericFormatImportOperationResult fishingOperationResult = importedCruiseResult.getFishingOperationResult(fishingOperationId);
        fishingOperationResult.addCheckError(checkError);
    }

    public void flushContext(GenericFormatImportCruiseContext cruiseContext) {
        Cruise cruise = cruiseContext.getCruise();
        GenericFormatImportCruiseResult cruiseResult = new GenericFormatImportCruiseResult(cruiseContext);
        this.cruiseResults.put(cruise.getId(), cruiseResult);
    }
}

