/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchive;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatServiceSupport;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchRow;
import fr.ifremer.tutti.service.genericformat.csv.CatchRow;
import fr.ifremer.tutti.service.genericformat.csv.GearCaracteristicRow;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationRow;
import fr.ifremer.tutti.service.genericformat.csv.MarineLitterRow;
import fr.ifremer.tutti.service.genericformat.csv.OperationRow;
import fr.ifremer.tutti.service.genericformat.csv.ParameterRow;
import fr.ifremer.tutti.service.genericformat.csv.SampleCategoryRow;
import fr.ifremer.tutti.service.genericformat.csv.SpeciesExportRow;
import fr.ifremer.tutti.service.genericformat.csv.SurveyRow;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForCatch;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForGearCaracteristics;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSampleCategory;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSpecies;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSurvey;
import fr.ifremer.tutti.service.referential.csv.GearRow;
import fr.ifremer.tutti.service.referential.csv.PersonRow;
import fr.ifremer.tutti.service.referential.csv.SpeciesRow;
import fr.ifremer.tutti.service.referential.csv.VesselRow;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryGear;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryPerson;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporarySpecies;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryVessel;
import fr.ifremer.tutti.util.Numbers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class GenericFormatExportService
extends GenericFormatServiceSupport {
    private static final Log log = LogFactory.getLog(GenericFormatExportService.class);

    public int getExportProgramNbSteps(String programId) {
        List<Cruise> allCruise = this.persistenceService.getAllCruise(programId);
        int result = 8;
        for (Cruise cruise : allCruise) {
            result += this.getCruiseNbStep(cruise.getId());
        }
        return result;
    }

    public int getExportCruiseNbSteps(String cruiseId) {
        int result = this.getCruiseNbStep(cruiseId) + 8;
        return result;
    }

    public void exportProgram(String programId, File exportFile, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)programId);
        Preconditions.checkNotNull((Object)exportFile);
        Program program = this.persistenceService.getProgram(programId);
        Preconditions.checkNotNull((Object)program);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will export program: " + programId));
        }
        List<Cruise> allCruise = this.persistenceService.getAllCruise(programId);
        ApplicationBusinessException checkError = null;
        try {
            this.checkProgramCruises(progressionModel, allCruise);
        }
        catch (ApplicationBusinessException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Got a check cruise error", (Throwable)e);
            }
            checkError = e;
        }
        GenericFormatArchive genericFormatArchive = GenericFormatArchive.forExport(exportFile, this.context.getConfig().getTmpDirectory());
        try (GenericFormatExportContext exportContext = this.createExportContext(progressionModel, genericFormatArchive);){
            for (Cruise cruise : allCruise) {
                cruise = this.persistenceService.getCruise(cruise.getId());
                this.exportCruise(exportContext, cruise);
            }
            this.terminatesExport(exportContext);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not create program export", (Throwable)e);
        }
        genericFormatArchive.createZip(progressionModel);
        if (checkError != null) {
            throw checkError;
        }
    }

    public void exportCruise(String cruiseId, File exportFile, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)cruiseId);
        Preconditions.checkNotNull((Object)exportFile);
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will export cruise: " + cruiseId));
        }
        ApplicationBusinessException checkError = null;
        try {
            List<String> fishingOperationIds = this.persistenceService.getAllFishingOperationIds(cruise.getId());
            String error = this.getCruiseErrors(cruise, fishingOperationIds, progressionModel);
            if (error != null) {
                throw new ApplicationBusinessException(error);
            }
        }
        catch (ApplicationBusinessException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Got a check cruise error", (Throwable)e);
            }
            checkError = e;
        }
        GenericFormatArchive genericFormatArchive = GenericFormatArchive.forExport(exportFile, this.context.getConfig().getTmpDirectory());
        try (GenericFormatExportContext exportContext = this.createExportContext(progressionModel, genericFormatArchive);){
            this.exportCruise(exportContext, cruise);
            this.terminatesExport(exportContext);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not create cruise export", (Throwable)e);
        }
        genericFormatArchive.createZip(progressionModel);
        if (checkError != null) {
            throw checkError;
        }
    }

    public File exportFishingOperation(String cruiseId, String fishingOperationId) {
        Preconditions.checkNotNull((Object)cruiseId);
        ProgressionModel progressionModel = new ProgressionModel();
        progressionModel.setTotal(1000);
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will export cruise: " + cruiseId));
        }
        ApplicationBusinessException checkError = null;
        try {
            String error = this.getCruiseErrors(cruise, Lists.newArrayList((Object[])new String[]{fishingOperationId}), progressionModel);
            if (error != null) {
                throw new ApplicationBusinessException(error);
            }
        }
        catch (ApplicationBusinessException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Got a check cruise error", (Throwable)e);
            }
            checkError = e;
        }
        GenericFormatArchive genericFormatArchive = GenericFormatArchive.forExport(null, this.context.getConfig().getTmpDirectory());
        try (GenericFormatExportContext exportContext = this.createExportContext(progressionModel, genericFormatArchive);){
            FishingOperation fishingOperation = this.persistenceService.getFishingOperation(fishingOperationId);
            this.exportCruise(exportContext, cruise, Lists.newArrayList((Object[])new FishingOperation[]{fishingOperation}));
            this.terminatesExport(exportContext);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not create cruise export", (Throwable)e);
        }
        if (checkError != null) {
            throw checkError;
        }
        return genericFormatArchive.getWorkingDirectoryPath();
    }

    public void exportSampleCategoryModel(File exportFile) {
        ProgressionModel progressionModel = new ProgressionModel();
        progressionModel.setTotal(1000);
        GenericFormatArchive genericFormatArchive = GenericFormatArchive.forExport(null, this.context.getConfig().getTmpDirectory());
        try (GenericFormatExportContext exportContext = this.createExportContext(progressionModel, genericFormatArchive);){
            SampleCategoryModel sampleCategoryModel = exportContext.getSampleCategoryModel();
            this.exportSampleCategoryModel(exportContext, sampleCategoryModel);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not export sample category model", (Throwable)e);
        }
        try {
            Files.copy(genericFormatArchive.getSampleCategoryModelPath(), exportFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not copy csv file to export file", (Throwable)e);
        }
    }

    protected GenericFormatExportContext createExportContext(ProgressionModel progressionModel, GenericFormatArchive genericFormatArchive) {
        return new GenericFormatExportContext(progressionModel, genericFormatArchive, ';', this.persistenceService, this.weightComputingService, (Decorator<FishingOperation>)this.fishingOperationDecorator, this.context.getSampleCategoryModel());
    }

    protected void checkProgramCruises(ProgressionModel progressionModel, List<Cruise> allCruise) {
        ArrayList<String> errorsByCruise = new ArrayList<String>();
        for (Cruise cruise : allCruise) {
            List<String> allFishingOperation;
            String error = this.getCruiseErrors(cruise = this.persistenceService.getCruise(cruise.getId()), allFishingOperation = this.persistenceService.getAllFishingOperationIds(cruise.getId()), progressionModel);
            if (error == null) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Found some errors on cruise: " + cruise.getName()));
            }
            errorsByCruise.add(error);
        }
        if (!errorsByCruise.isEmpty()) {
            String errorMessage = Joiner.on((String)"\n").join(errorsByCruise);
            throw new ApplicationBusinessException(errorMessage);
        }
    }

    protected void terminatesExport(GenericFormatExportContext exportContext) {
        SampleCategoryModel sampleCategoryModel = exportContext.getSampleCategoryModel();
        this.exportSampleCategoryModel(exportContext, sampleCategoryModel);
        this.exportProtocol(exportContext);
        List<Gear> temporaryGears = this.referentialTemporaryGearService.getTemporaryGears();
        this.exportTemporaryGears(exportContext, temporaryGears);
        List<Person> temporaryPersons = this.referentialTemporaryPersonService.getTemporaryPersons();
        this.exportTemporaryPersons(exportContext, temporaryPersons);
        List<Species> temporarySpeciess = this.referentialTemporarySpeciesService.getTemporarySpeciess();
        this.exportTemporarySpeciess(exportContext, temporarySpeciess);
        List<Vessel> temporaryVessels = this.referentialTemporaryVesselService.getTemporaryVessels();
        this.exportTemporaryVessels(exportContext, temporaryVessels);
        this.exportSpecies(exportContext);
    }

    protected void exportTemporaryGears(GenericFormatExportContext exportContext, List<Gear> temporaryGears) {
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportTemporaryGear", (Object[])new Object[]{temporaryGears.size()}));
        try {
            CsvProducerForTemporaryGear producerForTemporarySpecies = exportContext.getProducerForTemporaryGear();
            List<GearRow> dataToExport = producerForTemporarySpecies.getDataToExport(temporaryGears);
            producerForTemporarySpecies.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not export temporary gear", (Throwable)e);
        }
    }

    protected void exportTemporaryPersons(GenericFormatExportContext exportContext, List<Person> temporaryPersons) {
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportTemporaryPerson", (Object[])new Object[]{temporaryPersons.size()}));
        try {
            CsvProducerForTemporaryPerson producerForTemporarySpecies = exportContext.getProducerForTemporaryPerson();
            List<PersonRow> dataToExport = producerForTemporarySpecies.getDataToExport(temporaryPersons);
            producerForTemporarySpecies.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not export temporary person", (Throwable)e);
        }
    }

    protected void exportTemporarySpeciess(GenericFormatExportContext exportContext, List<Species> temporarySpeciess) {
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportTemporarySpecies", (Object[])new Object[]{temporarySpeciess.size()}));
        try {
            CsvProducerForTemporarySpecies producerForTemporarySpecies = exportContext.getProducerForTemporarySpecies();
            List<SpeciesRow> dataToExport = producerForTemporarySpecies.getDataToExport(temporarySpeciess);
            producerForTemporarySpecies.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not export temporary species", (Throwable)e);
        }
    }

    protected void exportTemporaryVessels(GenericFormatExportContext exportContext, List<Vessel> temporaryVessels) {
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportTemporaryVessel", (Object[])new Object[]{temporaryVessels.size()}));
        try {
            CsvProducerForTemporaryVessel producerForTemporaryVessel = exportContext.getProducerForTemporaryVessel();
            List<VesselRow> dataToExport = producerForTemporaryVessel.getDataToExport(temporaryVessels);
            producerForTemporaryVessel.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not export temporary vessels", (Throwable)e);
        }
    }

    protected void exportSampleCategoryModel(GenericFormatExportContext exportContext, SampleCategoryModel sampleCategoryModel) {
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportSampleCategoyModel", (Object[])new Object[]{sampleCategoryModel.getNbSampling()}));
        try {
            CsvProducerForSampleCategory producerForSampleCategory = exportContext.getProducerForSampleCategory();
            List<SampleCategoryRow> dataToExport = producerForSampleCategory.getDataToExport(sampleCategoryModel);
            producerForSampleCategory.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not export sample categories gear", (Throwable)e);
        }
    }

    protected void exportProtocol(GenericFormatExportContext exportContext) {
        boolean protocolFilled = this.context.getDataContext().isProtocolFilled();
        if (protocolFilled) {
            TuttiProtocol protocol = this.persistenceService.getProtocol();
            exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportProtocol", (Object[])new Object[]{protocol.getName()}));
            this.protocolImportExportService.exportProtocol(protocol, exportContext.getProtocolFile());
        } else {
            exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.skipProtocolExport", (Object[])new Object[0]));
        }
    }

    protected void exportCruise(GenericFormatExportContext exportContext, Cruise cruise) {
        List<FishingOperation> operations = this.persistenceService.getAllFishingOperation(cruise.getId());
        this.exportCruise(exportContext, cruise, operations);
    }

    protected void exportCruise(GenericFormatExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        this.exportSurvey(exportContext, cruise);
        this.exportGearCaracteristics(exportContext, cruise);
        for (FishingOperation operation : operations) {
            FishingOperation loadedOperation = this.persistenceService.getFishingOperation(operation.getId());
            this.exportOperation(exportContext, cruise, loadedOperation);
        }
    }

    private void exportSurvey(GenericFormatExportContext exportContext, Cruise cruise) {
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.exportCruise.exportSurvey", (Object[])new Object[]{cruise.getName()}));
        List<TuttiLocation> allCountry = this.persistenceService.getAllCountry();
        String countryId = this.context.getConfig().getExportCountryId();
        TuttiLocation country = (TuttiLocation)TuttiEntities.splitById(allCountry).get(countryId);
        try {
            CsvProducerForSurvey producerForSurvey = exportContext.getProducerForSurvey();
            SurveyRow surveyRow = producerForSurvey.getDataToExport(cruise, country);
            producerForSurvey.write(surveyRow);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.genericFormat.export.survey.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportGearCaracteristics(GenericFormatExportContext exportContext, Cruise cruise) {
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.exportCruise.exportGearCaracteristics", (Object[])new Object[]{cruise.getName()}));
        try {
            CsvProducerForGearCaracteristics producerForGearCaracteristics = exportContext.getProducerForGearCaracteristics();
            ArrayList rows = Lists.newArrayList();
            for (Gear gear : cruise.getGear()) {
                CaracteristicMap caracteristics = this.persistenceService.getGearCaracteristics(cruise.getId(), gear.getId(), gear.getRankOrder());
                Gear gearWithCaracteristics = Gears.newGear((Gear)gear);
                gearWithCaracteristics.setCaracteristics(caracteristics);
                List<GearCaracteristicRow> dataToExport = producerForGearCaracteristics.getDataToExport(cruise, gearWithCaracteristics);
                rows.addAll(dataToExport);
            }
            producerForGearCaracteristics.write(rows);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.genericFormat.export.gearCaracteristics.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportOperation(GenericFormatExportContext exportContext, Cruise cruise, FishingOperation operation) {
        GenericFormatExportOperationContext operationContext = exportContext.newOperationContext(cruise, operation);
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.exportCruise.exportOperation", (Object[])new Object[]{cruise.getName(), operationContext.getOperationLabel()}));
        CatchBatch catchBatch = operationContext.getCatchBatch();
        OperationRow operationRow = exportContext.getProducerForOperation().getDataToExport(cruise, operation, catchBatch);
        operationContext.setOperationRow(operationRow);
        List<ParameterRow> parameterRows = exportContext.getProducerForParameter().getDataToExport(cruise, operation);
        operationContext.setParameterRows(parameterRows);
        boolean withCatchBatch = operationContext.isWithCatchBatch();
        if (withCatchBatch) {
            List<MarineLitterRow> marineLitterRows = exportContext.getProducerForMarineLitter().getDataToExport(operationContext);
            operationContext.setMarineLitterRows(marineLitterRows);
            List<IndividualObservationRow> individualObservationRows = exportContext.getProducerForIndividualObservation().getDataToExport(operationContext);
            operationContext.setIndividualObservationRows(individualObservationRows);
            exportContext.getProducerForSpecies().prepareIndividualRows(individualObservationRows);
            List<AccidentalCatchRow> accidentalCatchRows = exportContext.getProducerForAccidentalCatch().getDataToExport(operationContext);
            operationContext.setAccidentalCatchRows(accidentalCatchRows);
            exportContext.getProducerForSpecies().prepareAccidentalRows(accidentalCatchRows);
            List<CatchRow> catchRows = this.exportCatch(exportContext, operationContext);
            operationContext.setCatchRows(catchRows);
        }
        try {
            exportContext.getProducerForOperation().write(operationContext.getOperationRow());
            exportContext.getProducerForParameter().write(operationContext.getParameterRows());
            exportContext.getProducerForMarineLitter().write(operationContext.getMarineLitterRows());
            exportContext.getProducerForIndividualObservation().write(operationContext.getIndividualObservationRows());
            exportContext.getProducerForAccidentalCatch().write(operationContext.getAccidentalCatchRows());
            exportContext.getProducerForCatch().write(operationContext.getCatchRows());
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.genericFormat.export.operation.error", (Object[])new Object[]{operationContext.getOperationLabel(), operationContext.getCruise().getName()}), (Throwable)e);
        }
    }

    protected List<CatchRow> exportCatch(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        CatchBatch catchBatch = operationContext.getCatchBatch();
        BatchContainer<SpeciesBatch> rootSpeciesBatch = operationContext.getRootSpeciesBatch();
        BatchContainer<BenthosBatch> rootBenthosBatch = operationContext.getRootBenthosBatch();
        CsvProducerForSpecies producerForSpecies = exportContext.getProducerForSpecies();
        producerForSpecies.prepareSpeciesBatchRows(rootSpeciesBatch);
        producerForSpecies.prepareBenthosBatchRows(rootBenthosBatch);
        Float totalWeight = (Float)Numbers.getValueOrComputedValue((Number)catchBatch.getCatchTotalWeight(), (Number)catchBatch.getCatchTotalComputedWeight());
        Float totalUnsortedWeight = catchBatch.getCatchTotalUnsortedComputedWeight();
        Float totalSortedSpeciesWeight = (Float)Numbers.getValueOrComputedValue((Number)catchBatch.getSpeciesTotalSortedWeight(), (Number)catchBatch.getSpeciesTotalSortedComputedWeight());
        Float totalSampleSortedSpeciesWeight = catchBatch.getSpeciesTotalSampleSortedComputedWeight();
        Float totalSortedBenthosWeight = (Float)Numbers.getValueOrComputedValue((Number)catchBatch.getBenthosTotalSortedWeight(), (Number)catchBatch.getBenthosTotalSortedComputedWeight());
        Float totalSampleSortedBenthosWeight = catchBatch.getBenthosTotalSampleSortedComputedWeight();
        Float totalSortedWeight = catchBatch.getCatchTotalSortedComputedWeight();
        Float catchRaisingFactor = Float.valueOf(totalWeight == null || totalUnsortedWeight == null || totalSortedWeight == null ? 1.0f : (totalWeight.floatValue() - totalUnsortedWeight.floatValue()) / totalSortedWeight.floatValue());
        Float speciesCatchRaisingFactor = Float.valueOf(totalSampleSortedSpeciesWeight == null || totalSortedSpeciesWeight == null || totalSampleSortedSpeciesWeight == null ? 1.0f : (totalSampleSortedSpeciesWeight.floatValue() == 0.0f ? 0.0f : totalSortedSpeciesWeight.floatValue() / totalSampleSortedSpeciesWeight.floatValue() * catchRaisingFactor.floatValue()));
        Float benthosCatchRaisingFactor = Float.valueOf(totalSampleSortedBenthosWeight == null || totalSortedBenthosWeight == null || totalSampleSortedBenthosWeight == null ? 1.0f : (totalSampleSortedBenthosWeight.floatValue() == 0.0f ? 0.0f : totalSortedBenthosWeight.floatValue() / totalSampleSortedBenthosWeight.floatValue() * catchRaisingFactor.floatValue()));
        if (log.isDebugEnabled()) {
            String message = "\ncatchTotalWeight               : " + totalWeight + "\ncatchTotalUnsortedWeight       : " + totalUnsortedWeight + "\ntotalSampleSortedSpeciesWeight : " + totalSampleSortedSpeciesWeight + "\ntotalSampleSortedBenthosWeight : " + totalSampleSortedBenthosWeight + "\ntotalSortedWeight              : " + totalSortedWeight + "\ncatchRaisingFactor             : " + catchRaisingFactor + "\nspeciesCatchRaisingFactor      : " + speciesCatchRaisingFactor + "\nbenthosCatchRaisingFactor      : " + benthosCatchRaisingFactor;
            log.debug((Object)message);
        }
        CsvProducerForCatch producerForCatch = exportContext.getProducerForCatch();
        List<CatchRow> rows = producerForCatch.getDataToExport(operationContext, speciesCatchRaisingFactor, benthosCatchRaisingFactor);
        return rows;
    }

    protected void exportSpecies(GenericFormatExportContext exportContext) {
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportSpecies", (Object[])new Object[0]));
        try {
            CsvProducerForSpecies producerForSpecies = exportContext.getProducerForSpecies();
            List<SpeciesExportRow> rows = producerForSpecies.getDataToExport();
            producerForSpecies.write(rows);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.genericFormat.export.species.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected int getCruiseNbStep(String cruiseId) {
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise);
        List<String> allFishingOperationIds = this.persistenceService.getAllFishingOperationIds(cruiseId);
        int nbFishingOperations = allFishingOperationIds.size();
        int result = 1 + nbFishingOperations + 1 + 1 + nbFishingOperations;
        return result;
    }

    protected String getCruiseErrors(Cruise cruise, Collection<String> fishingOperationIds, ProgressionModel progressionModel) {
        String result;
        Map<String, String> errors = this.getFishingOperationsErrors(cruise, fishingOperationIds, progressionModel);
        if (!errors.isEmpty()) {
            StringBuilder errorMessageBuilder = new StringBuilder();
            for (String error : errors.values()) {
                errorMessageBuilder.append("<li>").append(error).append("</li>");
            }
            String cruiseStr = this.cruiseDecorator.toString((Object)cruise);
            result = I18n.t((String)"tutti.service.genericFormat.invalid.cruise", (Object[])new Object[]{cruiseStr, errorMessageBuilder.toString()});
        } else {
            result = null;
        }
        return result;
    }

    protected Map<String, String> getFishingOperationsErrors(Cruise cruise, Collection<String> fishingOperationIds, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)progressionModel);
        progressionModel.increments(I18n.t((String)"tutti.service.genericFormat.checkCruise", (Object[])new Object[]{cruise.getName()}));
        LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>();
        for (String fishingOperationId : fishingOperationIds) {
            FishingOperation fishingOperation = this.persistenceService.getFishingOperation(fishingOperationId);
            progressionModel.increments(I18n.t((String)"tutti.service.genericFormat.checkCruiseFishingOperation", (Object[])new Object[]{cruise.getName(), this.fishingOperationDecorator.toString((Object)fishingOperation)}));
            Set<String> errorsForOperation = this.checkFishingOperation(fishingOperationId);
            if (errorsForOperation.isEmpty()) continue;
            String fishingOperationStr = this.fishingOperationDecorator.toString((Object)fishingOperation);
            StringBuilder sb = new StringBuilder();
            for (String error : errorsForOperation) {
                sb.append("<li>").append(error).append("</li>");
            }
            String errorMessage = I18n.t((String)"tutti.service.genericFormat.invalid.fishingOperation", (Object[])new Object[]{fishingOperationStr, sb.toString()});
            errors.put(fishingOperationId, errorMessage);
        }
        return errors;
    }
}

