/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.referential.AbstractPersons;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntities;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Persons
extends AbstractPersons {
    public static final Predicate<Person> IS_TEMPORARY = new Predicate<Person>(){

        public boolean apply(Person input) {
            return Persons.isTemporary(input);
        }
    };
    public static final Function<Person, String> GET_FULL_NAME = new Function<Person, String>(){

        public String apply(Person input) {
            return StringUtils.trimToEmpty((String)input.getFirstName()) + " " + StringUtils.trimToEmpty((String)input.getLastName());
        }
    };

    public static boolean isTemporary(Person person) {
        Preconditions.checkNotNull((Object)person);
        Preconditions.checkNotNull((Object)person.getId());
        return TuttiReferentialEntities.isStatusTemporary(person) && Persons.isTemporaryId(person.getIdAsInt());
    }

    public static boolean isTemporaryId(Integer id) {
        Preconditions.checkNotNull((Object)id);
        return id < 0;
    }

    public static Map<String, Person> splitByFullName(List<Person> persons) {
        return Maps.uniqueIndex(persons, GET_FULL_NAME);
    }
}

