/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.cache.BasicCachedList;
import org.eclipse.birt.data.engine.cache.ICachedObject;
import org.eclipse.birt.data.engine.cache.ICachedObjectCreator;
import org.eclipse.birt.data.engine.impl.DataEngineSession;

public class CachedList
extends BasicCachedList {
    private ICachedObjectCreator creator;

    public CachedList(String tempDir, ClassLoader loader, ICachedObjectCreator creator) {
        super(tempDir, loader);
        this.creator = creator;
    }

    public CachedList(String tempDir, ClassLoader loader, ICachedObjectCreator creator, List list) {
        super(tempDir, loader, list);
        this.creator = creator;
    }

    @Override
    protected void writeObject(DataOutputStream oos, Object object) throws IOException {
        if (object == null) {
            IOUtil.writeInt(oos, Integer.MAX_VALUE);
            return;
        }
        ICachedObject cachedObject = (ICachedObject)object;
        Object[] objects = cachedObject.getFieldValues();
        IOUtil.writeInt(oos, objects.length);
        int i = 0;
        while (i < objects.length) {
            IOUtil.writeObject(oos, objects[i]);
            ++i;
        }
    }

    @Override
    protected Object readObject(DataInputStream dis) throws IOException {
        int fieldCount = IOUtil.readInt(dis);
        if (fieldCount == Integer.MAX_VALUE) {
            return null;
        }
        Object[] objects = new Object[fieldCount];
        int i = 0;
        while (i < objects.length) {
            objects[i] = IOUtil.readObject(dis, DataEngineSession.getCurrentClassLoader());
            ++i;
        }
        return this.creator.createInstance(objects);
    }
}

