/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import java.util.Collection;
import java.util.List;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface PersonPersistenceService
extends TuttiPersistenceServiceImplementor {
    @Cacheable(value={"persons"})
    public List<Person> getAllPerson();

    @Cacheable(value={"personById"}, key="#personId")
    public Person getPerson(Integer var1);

    public boolean isTemporaryPersonUsed(Integer var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"persons", "personById"}, allEntries=true)
    public Collection<Person> importTemporaryPerson(Collection<Person> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache", "persons", "personById"}, allEntries=true)
    public void replacePerson(Person var1, Person var2, boolean var3);

    @Transactional(readOnly=false)
    @CacheEvict(value={"persons", "personById"}, allEntries=true)
    public void deleteTemporaryPersons(Collection<Integer> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"persons", "personById"}, allEntries=true)
    public void deleteTemporaryPerson(Integer var1);
}

