/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothConnectionAccess;
import com.intel.bluetooth.BluetoothServerConnection;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import com.intel.bluetooth.WeakVectorFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.Connection;

public abstract class RemoteDeviceHelper {
    private static Hashtable stackDevicesCashed = new Hashtable();

    private RemoteDeviceHelper() {
    }

    private static synchronized Hashtable devicesCashed(BluetoothStack bluetoothStack) {
        Hashtable devicesCashed = (Hashtable)stackDevicesCashed.get(bluetoothStack);
        if (devicesCashed == null) {
            devicesCashed = new Hashtable();
            stackDevicesCashed.put(bluetoothStack, devicesCashed);
        }
        return devicesCashed;
    }

    private static RemoteDeviceWithExtendedInfo getCashedDeviceWithExtendedInfo(BluetoothStack bluetoothStack, long address) {
        Long key = new Long(address);
        return (RemoteDeviceWithExtendedInfo)RemoteDeviceHelper.devicesCashed(bluetoothStack).get(key);
    }

    static RemoteDevice getCashedDevice(BluetoothStack bluetoothStack, long address) {
        return RemoteDeviceHelper.getCashedDeviceWithExtendedInfo(bluetoothStack, address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RemoteDevice createRemoteDevice(BluetoothStack bluetoothStack, long address, String name, boolean paired) {
        RemoteDeviceWithExtendedInfo dev = RemoteDeviceHelper.getCashedDeviceWithExtendedInfo(bluetoothStack, address);
        if (dev == null) {
            Object saveID = BlueCoveImpl.getCurrentThreadBluetoothStackID();
            try {
                BlueCoveImpl.setThreadBluetoothStack(bluetoothStack);
                dev = new RemoteDeviceWithExtendedInfo(bluetoothStack, address, name);
            }
            finally {
                if (saveID != null) {
                    BlueCoveImpl.setThreadBluetoothStackID(saveID);
                }
            }
            RemoteDeviceHelper.devicesCashed(bluetoothStack).put(new Long(address), dev);
            DebugLog.debug0x("new devicesCashed", address);
        } else if (!Utils.isStringSet(dev.name)) {
            dev.name = name;
        } else if (Utils.isStringSet(name)) {
            dev.name = name;
        }
        if (paired) {
            dev.paired = paired;
        }
        return dev;
    }

    private static BluetoothStack getBluetoothStack() throws RuntimeException {
        try {
            return BlueCoveImpl.instance().getBluetoothStack();
        }
        catch (BluetoothStateException e) {
            throw (RuntimeException)UtilsJavaSE.initCause(new RuntimeException("Can't initialize bluetooth support"), e);
        }
    }

    private static RemoteDeviceWithExtendedInfo remoteDeviceImpl(RemoteDevice device) {
        return (RemoteDeviceWithExtendedInfo)RemoteDeviceHelper.createRemoteDevice(null, device);
    }

    static RemoteDevice createRemoteDevice(BluetoothStack bluetoothStack, RemoteDevice device) throws RuntimeException {
        if (device instanceof RemoteDeviceWithExtendedInfo) {
            return device;
        }
        if (bluetoothStack == null) {
            bluetoothStack = RemoteDeviceHelper.getBluetoothStack();
        }
        return RemoteDeviceHelper.createRemoteDevice(bluetoothStack, RemoteDeviceHelper.getAddress(device), null, false);
    }

    public static String getFriendlyName(RemoteDevice device, long address, boolean alwaysAsk) throws IOException {
        String name = null;
        if (!(device instanceof RemoteDeviceWithExtendedInfo)) {
            device = RemoteDeviceHelper.createRemoteDevice(null, device);
        }
        name = ((RemoteDeviceWithExtendedInfo)device).name;
        if (alwaysAsk || !Utils.isStringSet(name)) {
            name = ((RemoteDeviceWithExtendedInfo)device).bluetoothStack.getRemoteDeviceFriendlyName(address);
            if (Utils.isStringSet(name)) {
                ((RemoteDeviceWithExtendedInfo)device).name = name;
            } else {
                throw new IOException("Can't query remote device");
            }
        }
        return name;
    }

    public static RemoteDevice getRemoteDevice(Connection conn) throws IOException {
        if (!(conn instanceof BluetoothConnectionAccess)) {
            throw new IllegalArgumentException("Not a Bluetooth connection " + conn.getClass().getName());
        }
        return RemoteDeviceHelper.createRemoteDevice(((BluetoothConnectionAccess)((Object)conn)).getBluetoothStack(), ((BluetoothConnectionAccess)((Object)conn)).getRemoteAddress(), null, false);
    }

    public static RemoteDevice[] retrieveDevices(BluetoothStack bluetoothStack, int option) {
        if (option != 1 && option != 0) {
            throw new IllegalArgumentException("invalid option");
        }
        RemoteDevice[] impl = bluetoothStack.retrieveDevices(option);
        if (impl != null) {
            if (impl.length == 0) {
                return null;
            }
            return impl;
        }
        Hashtable devicesCashed = RemoteDeviceHelper.devicesCashed(bluetoothStack);
        switch (option) {
            case 1: {
                if (devicesCashed.size() == 0) {
                    return null;
                }
                Vector<RemoteDeviceWithExtendedInfo> devicesPaired = new Vector<RemoteDeviceWithExtendedInfo>();
                Enumeration en = devicesCashed.elements();
                while (en.hasMoreElements()) {
                    RemoteDeviceWithExtendedInfo d = (RemoteDeviceWithExtendedInfo)en.nextElement();
                    if (!d.isTrustedDevice()) continue;
                    devicesPaired.addElement(d);
                }
                if (devicesPaired.size() == 0) {
                    return null;
                }
                return RemoteDeviceHelper.remoteDeviceListToArray(devicesPaired);
            }
            case 0: {
                if (devicesCashed.size() == 0) {
                    return null;
                }
                RemoteDevice[] devices = new RemoteDevice[devicesCashed.size()];
                int k = 0;
                Enumeration en = devicesCashed.elements();
                while (en.hasMoreElements()) {
                    devices[k++] = (RemoteDevice)en.nextElement();
                }
                return devices;
            }
        }
        throw new IllegalArgumentException("invalid option");
    }

    static RemoteDevice[] remoteDeviceListToArray(Vector devices) {
        RemoteDevice[] devicesArray = new RemoteDevice[devices.size()];
        int i = 0;
        Enumeration en = devices.elements();
        while (en.hasMoreElements()) {
            devicesArray[i++] = (RemoteDevice)en.nextElement();
        }
        return devicesArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int openConnections() {
        Hashtable devicesCashed;
        int c = 0;
        Hashtable hashtable = devicesCashed = RemoteDeviceHelper.devicesCashed(RemoteDeviceHelper.getBluetoothStack());
        synchronized (hashtable) {
            Enumeration en = devicesCashed.elements();
            while (en.hasMoreElements()) {
                c += ((RemoteDeviceWithExtendedInfo)en.nextElement()).connectionsCount();
            }
        }
        return c;
    }

    public static int openConnections(long address) {
        RemoteDeviceWithExtendedInfo dev = RemoteDeviceHelper.getCashedDeviceWithExtendedInfo(RemoteDeviceHelper.getBluetoothStack(), address);
        if (dev == null) {
            return 0;
        }
        return dev.connectionsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int connectedDevices() {
        Hashtable devicesCashed;
        int c = 0;
        Hashtable hashtable = devicesCashed = RemoteDeviceHelper.devicesCashed(RemoteDeviceHelper.getBluetoothStack());
        synchronized (hashtable) {
            Enumeration en = devicesCashed.elements();
            while (en.hasMoreElements()) {
                if (!((RemoteDeviceWithExtendedInfo)en.nextElement()).hasConnections()) continue;
                ++c;
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdownConnections(BluetoothStack bluetoothStack) {
        Hashtable devicesCashed;
        Hashtable hashtable = devicesCashed = RemoteDeviceHelper.devicesCashed(bluetoothStack);
        synchronized (hashtable) {
            Enumeration en = devicesCashed.elements();
            while (en.hasMoreElements()) {
                ((RemoteDeviceWithExtendedInfo)en.nextElement()).shutdownConnections();
            }
        }
    }

    public static String formatBluetoothAddress(String address) {
        String s = address.toUpperCase();
        return "000000000000".substring(s.length()) + s;
    }

    public static String getBluetoothAddress(long address) {
        return RemoteDeviceHelper.formatBluetoothAddress(Utils.toHexString(address));
    }

    public static long getAddress(String bluetoothAddress) {
        if (bluetoothAddress.indexOf(45) != -1) {
            throw new IllegalArgumentException("Illegal bluetoothAddress {" + bluetoothAddress + "}");
        }
        try {
            return Long.parseLong(bluetoothAddress, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal bluetoothAddress {" + bluetoothAddress + "}; should be hex number");
        }
    }

    static long getAddress(RemoteDevice device) {
        if (device instanceof RemoteDeviceWithExtendedInfo) {
            return ((RemoteDeviceWithExtendedInfo)device).addressLong;
        }
        return RemoteDeviceHelper.getAddress(device.getBluetoothAddress());
    }

    static void setStackAttributes(BluetoothStack bluetoothStack, RemoteDevice device, Object key, Object value) {
        RemoteDeviceWithExtendedInfo devInfo = (RemoteDeviceWithExtendedInfo)RemoteDeviceHelper.createRemoteDevice(bluetoothStack, device);
        devInfo.setStackAttributes(key, value);
    }

    static Object getStackAttributes(BluetoothStack bluetoothStack, RemoteDevice device, Object key) {
        RemoteDeviceWithExtendedInfo devInfo = null;
        devInfo = device instanceof RemoteDeviceWithExtendedInfo ? (RemoteDeviceWithExtendedInfo)device : RemoteDeviceHelper.getCashedDeviceWithExtendedInfo(bluetoothStack, RemoteDeviceHelper.getAddress(device));
        if (devInfo != null) {
            return devInfo.getStackAttributes(key);
        }
        return null;
    }

    static void connected(BluetoothConnectionAccess connection) throws IOException {
        RemoteDeviceWithExtendedInfo device = (RemoteDeviceWithExtendedInfo)RemoteDeviceHelper.getRemoteDevice((Connection)((Object)connection));
        connection.setRemoteDevice(device);
        device.addConnection(connection);
    }

    static void disconnected(BluetoothConnectionAccess connection) {
        RemoteDevice d = connection.getRemoteDevice();
        if (d != null) {
            ((RemoteDeviceWithExtendedInfo)d).removeConnection(connection);
            connection.setRemoteDevice(null);
        }
    }

    public static boolean authenticate(RemoteDevice device) throws IOException {
        return RemoteDeviceHelper.remoteDeviceImpl(device).authenticate();
    }

    public static boolean authenticate(RemoteDevice device, String passkey) throws IOException {
        return RemoteDeviceHelper.remoteDeviceImpl(device).authenticate(passkey);
    }

    public static void removeAuthentication(RemoteDevice device) throws IOException {
        RemoteDeviceHelper.remoteDeviceImpl(device).removeAuthentication();
    }

    public static boolean authorize(RemoteDevice device, Connection conn) throws IOException {
        return RemoteDeviceHelper.remoteDeviceImpl(device).authorize(conn);
    }

    public static boolean encrypt(RemoteDevice device, Connection conn, boolean on) throws IOException {
        return RemoteDeviceHelper.remoteDeviceImpl(device).encrypt(conn, on);
    }

    public static boolean isAuthenticated(RemoteDevice device) {
        return RemoteDeviceHelper.remoteDeviceImpl(device).isAuthenticated();
    }

    public static boolean isAuthorized(RemoteDevice device, Connection conn) throws IOException {
        return RemoteDeviceHelper.remoteDeviceImpl(device).isAuthorized(conn);
    }

    public static boolean isEncrypted(RemoteDevice device) {
        return RemoteDeviceHelper.remoteDeviceImpl(device).isEncrypted();
    }

    public static boolean isTrustedDevice(RemoteDevice device) {
        return RemoteDeviceHelper.remoteDeviceImpl(device).isTrustedDevice();
    }

    private static class RemoteDeviceWithExtendedInfo
    extends RemoteDevice {
        String name;
        long addressLong;
        BluetoothStack bluetoothStack;
        private Hashtable stackAttributes;
        private boolean paired;
        private WeakVectorFactory.WeakVector connections;

        private RemoteDeviceWithExtendedInfo(BluetoothStack bluetoothStack, long address, String name) {
            super(RemoteDeviceHelper.getBluetoothAddress(address));
            this.bluetoothStack = bluetoothStack;
            this.name = name;
            this.addressLong = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addConnection(Object connection) {
            Object object = this;
            synchronized (object) {
                if (this.connections == null) {
                    this.connections = WeakVectorFactory.createWeakVector();
                }
            }
            object = this.connections;
            synchronized (object) {
                this.connections.addElement(connection);
                DebugLog.debug("connection open, open now", this.connections.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeConnection(Object connection) {
            if (this.connections == null) {
                return;
            }
            WeakVectorFactory.WeakVector weakVector = this.connections;
            synchronized (weakVector) {
                this.connections.removeElement(connection);
                DebugLog.debug("connection closed, open now", this.connections.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdownConnections() {
            if (!this.hasConnections()) {
                return;
            }
            Vector c2shutdown = new Vector();
            WeakVectorFactory.WeakVector weakVector = this.connections;
            synchronized (weakVector) {
                c2shutdown = Utils.clone(this.connections.elements());
            }
            Enumeration en = c2shutdown.elements();
            while (en.hasMoreElements()) {
                BluetoothConnectionAccess c = (BluetoothConnectionAccess)en.nextElement();
                try {
                    c.shutdown();
                }
                catch (IOException e) {
                    DebugLog.debug("connection shutdown", e);
                }
            }
            weakVector = this.connections;
            synchronized (weakVector) {
                this.connections.removeAllElements();
            }
        }

        private void setStackAttributes(Object key, Object value) {
            if (this.stackAttributes == null) {
                this.stackAttributes = new Hashtable();
            }
            if (value == null) {
                this.stackAttributes.remove(key);
            } else {
                this.stackAttributes.put(key, value);
            }
        }

        private Object getStackAttributes(Object key) {
            if (this.stackAttributes == null) {
                return null;
            }
            return this.stackAttributes.get(key);
        }

        public String toString() {
            return super.getBluetoothAddress();
        }

        int connectionsCount() {
            if (this.connections == null) {
                return 0;
            }
            return this.connections.size();
        }

        boolean hasConnections() {
            return this.connectionsCount() != 0;
        }

        public boolean authenticate() throws IOException {
            boolean authenticated;
            if (!this.hasConnections()) {
                throw new IOException("No open connections to this RemoteDevice");
            }
            if (this.isAuthenticated()) {
                return true;
            }
            this.paired = authenticated = this.bluetoothStack.authenticateRemoteDevice(this.addressLong);
            if (authenticated) {
                this.updateConnectionMarkAuthenticated();
            }
            return authenticated;
        }

        boolean authenticate(String passkey) throws IOException {
            boolean authenticated;
            this.paired = authenticated = this.bluetoothStack.authenticateRemoteDevice(this.addressLong, passkey);
            if (authenticated) {
                this.updateConnectionMarkAuthenticated();
            }
            return authenticated;
        }

        void removeAuthentication() throws IOException {
            this.bluetoothStack.removeAuthenticationWithRemoteDevice(this.addressLong);
            this.paired = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConnectionMarkAuthenticated() {
            if (this.connections == null) {
                return;
            }
            WeakVectorFactory.WeakVector weakVector = this.connections;
            synchronized (weakVector) {
                Enumeration en = this.connections.elements();
                while (en.hasMoreElements()) {
                    BluetoothConnectionAccess c = (BluetoothConnectionAccess)en.nextElement();
                    c.markAuthenticated();
                }
            }
        }

        public boolean authorize(Connection conn) throws IOException {
            if (!(conn instanceof BluetoothConnectionAccess)) {
                throw new IllegalArgumentException("Connection is not a Bluetooth connection");
            }
            if (((BluetoothConnectionAccess)((Object)conn)).isClosed()) {
                throw new IOException("Connection is already closed");
            }
            if (!(conn instanceof BluetoothServerConnection)) {
                throw new IllegalArgumentException("Connection is not an incomming Bluetooth connection");
            }
            return this.isTrustedDevice() || this.isAuthenticated();
        }

        public boolean isAuthorized(Connection conn) throws IOException {
            if (!(conn instanceof BluetoothConnectionAccess)) {
                throw new IllegalArgumentException("Connection is not a Bluetooth connection");
            }
            if (((BluetoothConnectionAccess)((Object)conn)).isClosed()) {
                throw new IOException("Connection is already closed");
            }
            if (!(conn instanceof BluetoothServerConnection)) {
                throw new IllegalArgumentException("Connection is not an incomming Bluetooth connection");
            }
            return this.isTrustedDevice();
        }

        public boolean encrypt(Connection conn, boolean on) throws IOException {
            if (!(conn instanceof BluetoothConnectionAccess)) {
                throw new IllegalArgumentException("Connection is not a Bluetooth connection");
            }
            if (((BluetoothConnectionAccess)((Object)conn)).getRemoteAddress() != this.addressLong) {
                throw new IllegalArgumentException("Connection is not to this device");
            }
            if (((BluetoothConnectionAccess)((Object)conn)).getSecurityOpt() == 2 == on) {
                return true;
            }
            return ((BluetoothConnectionAccess)((Object)conn)).encrypt(this.addressLong, on);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAuthenticated() {
            if (!this.hasConnections()) {
                DebugLog.debug("no connections, Authenticated = false");
                return false;
            }
            Boolean authenticated = this.bluetoothStack.isRemoteDeviceAuthenticated(this.addressLong);
            if (authenticated != null) {
                return authenticated;
            }
            WeakVectorFactory.WeakVector weakVector = this.connections;
            synchronized (weakVector) {
                Enumeration en = this.connections.elements();
                while (en.hasMoreElements()) {
                    BluetoothConnectionAccess c = (BluetoothConnectionAccess)en.nextElement();
                    if (c.getSecurityOpt() == 0) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEncrypted() {
            if (!this.hasConnections()) {
                return false;
            }
            WeakVectorFactory.WeakVector weakVector = this.connections;
            synchronized (weakVector) {
                Enumeration en = this.connections.elements();
                while (en.hasMoreElements()) {
                    BluetoothConnectionAccess c = (BluetoothConnectionAccess)en.nextElement();
                    if (c.getSecurityOpt() != 2) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isTrustedDevice() {
            Boolean trusted = this.bluetoothStack.isRemoteDeviceTrusted(this.addressLong);
            if (trusted == null) {
                return this.paired;
            }
            return trusted;
        }
    }
}

