package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions.AddSpeciesFrequencyLengthStepCaracteristicAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions.CancelEditSpeciesFrequencyAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions.GenerateSpeciesFrequencyLengthStepsAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions.ResetSpeciesFrequencyAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions.SaveAndCloseSpeciesFrequencyAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions.SaveAndContinueSpeciesFrequencyAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class SpeciesFrequencyUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SpeciesFrequencyUIModel, SpeciesFrequencyUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AUTO_GEN_MODE_BUTTON_SELECTED = "autoGenModeButton.selected";
    public static final String BINDING_DATA_FIELD_LAYOUT_SELECTED = "dataFieldLayout.selected";
    public static final String BINDING_DATA_IN_FREQUENCIES_WARNING_CONTAINER_VISIBLE = "dataInFrequenciesWarningContainer.visible";
    public static final String BINDING_GENERATE_LENGTH_STEPS_ACTION_ENABLED = "generateLengthStepsAction.enabled";
    public static final String BINDING_LENGTHSTEP_SETTINGS_BLOCK_VISIBLE = "lengthstepSettingsBlock.visible";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED = "lengthStepCaracteristicComboBox.enabled";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "lengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED = "lengthStepCaracteristicLabel.enabled";
    public static final String BINDING_MAX_STEP_FIELD_NUMBER_VALUE = "maxStepField.numberValue";
    public static final String BINDING_MIN_STEP_FIELD_NUMBER_VALUE = "minStepField.numberValue";
    public static final String BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED = "modeConfigurationLayout.selected";
    public static final String BINDING_RAFALE_MODE_BUTTON_SELECTED = "rafaleModeButton.selected";
    public static final String BINDING_RAFALE_STEP_FIELD_ENABLED = "rafaleStepField.enabled";
    public static final String BINDING_SAVE_AND_CLOSE_ACTION_ENABLED = "saveAndCloseAction.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_ACTION_ENABLED = "saveAndContinueAction.enabled";
    public static final String BINDING_SIMPLE_COUNTING_FIELD_NUMBER_VALUE = "simpleCountingField.numberValue";
    public static final String BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED = "simpleCountingModeButton.selected";
    public static final String BINDING_STEP_FIELD_ENABLED = "stepField.enabled";
    public static final String BINDING_STEP_FIELD_NUMBER_VALUE = "stepField.numberValue";
    public static final String BINDING_STEP_LABEL_ENABLED = "stepLabel.enabled";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";
    public static final String BINDING_TOTAL_NUMBER_FIELD_TEXT = "totalNumberField.text";
    public static final String BINDING_TOTAL_NUMBER_LABEL_ENABLED = "totalNumberLabel.enabled";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_BEAN = "totalWeightField.bean";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_NUMBER_VALUE = "totalWeightField.numberValue";
    public static final String BINDING_TOTAL_WEIGHT_LABEL_ENABLED = "totalWeightLabel.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected AddSpeciesFrequencyLengthStepCaracteristicAction addLengthStepCaracteristicAction;
    protected JButton addLengthStepCaracteristicButton;
    protected JRadioButton autoGenModeButton;
    protected JPanel autoGenModePanel;
    protected TuttiHelpBroker broker;
    protected CancelEditSpeciesFrequencyAction cancelAction;
    protected JButton cancelButton;
    protected JPanel configurationPanel;
    protected CardLayout2Ext dataFieldLayout;
    protected JPanel dataFieldPanel;
    protected JLabel dataInFrequenciesWarning;
    protected JPanel dataInFrequenciesWarningContainer;
    protected SpeciesFrequencyUI editSpeciesFrequenciesTopPanel = this;
    protected JSplitPane firstSplitPane;
    protected JButton generateButton;
    protected GenerateSpeciesFrequencyLengthStepsAction generateLengthStepsAction;
    protected final SpeciesFrequencyUIHandler handler = createHandler();
    protected JPanel histogramPanel;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "lengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> lengthStepCaracteristicComboBox;
    protected JLabel lengthStepCaracteristicLabel;
    protected Table lengthstepSettingsBlock;
    protected JScrollPane logsScrollPane;
    protected JXTable logsTable;
    protected NumberEditor maxStepField;
    protected JLabel maxStepLabel;
    protected NumberEditor minStepField;
    protected JLabel minStepLabel;
    protected JAXXButtonGroup mode;
    protected CardLayout2Ext modeConfigurationLayout;
    protected JPanel modeConfigurationPanel;
    protected VBox modePanel;
    protected SpeciesFrequencyUIModel model;
    protected JRadioButton rafaleModeButton;
    protected JPanel rafaleModePanel;
    protected NumberEditor rafaleStepField;
    protected JLabel rafaleStepLabel;
    protected ResetSpeciesFrequencyAction resetAction;
    protected JButton resetButton;
    protected SaveAndCloseSpeciesFrequencyAction saveAndCloseAction;
    protected JButton saveAndCloseButton;
    protected SaveAndContinueSpeciesFrequencyAction saveAndContinueAction;
    protected JButton saveAndContinueButton;
    protected JSplitPane secondSplitPane;
    protected NumberEditor simpleCountingField;
    protected JLabel simpleCountingLabel;
    protected JRadioButton simpleCountingModeButton;
    protected JLabel simpleCountingModeLabel;
    protected JPanel simpleCountingModePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "step",  editorName = "stepField")
    protected NumberEditor stepField;
    protected JLabel stepLabel;
    protected JXTable table;
    @ValidatorField( validatorId = "validator",  propertyName = "rows",  editorName = "tableScrollPane")
    protected JScrollPane tableScrollPane;
    protected JTextField totalNumberField;
    protected JLabel totalNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "totalWeight",  editorName = "totalWeightField")
    protected ComputableDataEditor<Float> totalWeightField;
    protected JLabel totalWeightLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesFrequencyUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JSeparator $JSeparator0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesFrequencyUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public SpeciesFrequencyUI() {
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__autoGenModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.AUTO_GEN);
    }

    public void doActionPerformed__on__rafaleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.RAFALE);
    }

    public void doActionPerformed__on__simpleCountingModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.SIMPLE_COUNTING);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public AddSpeciesFrequencyLengthStepCaracteristicAction getAddLengthStepCaracteristicAction() {
        return addLengthStepCaracteristicAction;
    }

    public JButton getAddLengthStepCaracteristicButton() {
        return addLengthStepCaracteristicButton;
    }

    public JRadioButton getAutoGenModeButton() {
        return autoGenModeButton;
    }

    public JPanel getAutoGenModePanel() {
        return autoGenModePanel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public CancelEditSpeciesFrequencyAction getCancelAction() {
        return cancelAction;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public CardLayout2Ext getDataFieldLayout() {
        return dataFieldLayout;
    }

    public JPanel getDataFieldPanel() {
        return dataFieldPanel;
    }

    public JLabel getDataInFrequenciesWarning() {
        return dataInFrequenciesWarning;
    }

    public JPanel getDataInFrequenciesWarningContainer() {
        return dataInFrequenciesWarningContainer;
    }

    public JSplitPane getFirstSplitPane() {
        return firstSplitPane;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public GenerateSpeciesFrequencyLengthStepsAction getGenerateLengthStepsAction() {
        return generateLengthStepsAction;
    }

    public SpeciesFrequencyUIHandler getHandler() {
        return handler;
    }

    public JPanel getHistogramPanel() {
        return histogramPanel;
    }

    public BeanFilterableComboBox<Caracteristic> getLengthStepCaracteristicComboBox() {
        return lengthStepCaracteristicComboBox;
    }

    public JLabel getLengthStepCaracteristicLabel() {
        return lengthStepCaracteristicLabel;
    }

    public Table getLengthstepSettingsBlock() {
        return lengthstepSettingsBlock;
    }

    public JScrollPane getLogsScrollPane() {
        return logsScrollPane;
    }

    public JXTable getLogsTable() {
        return logsTable;
    }

    public NumberEditor getMaxStepField() {
        return maxStepField;
    }

    public JLabel getMaxStepLabel() {
        return maxStepLabel;
    }

    public NumberEditor getMinStepField() {
        return minStepField;
    }

    public JLabel getMinStepLabel() {
        return minStepLabel;
    }

    public JAXXButtonGroup getMode() {
        return mode;
    }

    public CardLayout2Ext getModeConfigurationLayout() {
        return modeConfigurationLayout;
    }

    public JPanel getModeConfigurationPanel() {
        return modeConfigurationPanel;
    }

    public VBox getModePanel() {
        return modePanel;
    }

    public SpeciesFrequencyUIModel getModel() {
        return model;
    }

    public JRadioButton getRafaleModeButton() {
        return rafaleModeButton;
    }

    public JPanel getRafaleModePanel() {
        return rafaleModePanel;
    }

    public NumberEditor getRafaleStepField() {
        return rafaleStepField;
    }

    public JLabel getRafaleStepLabel() {
        return rafaleStepLabel;
    }

    public ResetSpeciesFrequencyAction getResetAction() {
        return resetAction;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public SaveAndCloseSpeciesFrequencyAction getSaveAndCloseAction() {
        return saveAndCloseAction;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public SaveAndContinueSpeciesFrequencyAction getSaveAndContinueAction() {
        return saveAndContinueAction;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public JSplitPane getSecondSplitPane() {
        return secondSplitPane;
    }

    public NumberEditor getSimpleCountingField() {
        return simpleCountingField;
    }

    public JLabel getSimpleCountingLabel() {
        return simpleCountingLabel;
    }

    public JRadioButton getSimpleCountingModeButton() {
        return simpleCountingModeButton;
    }

    public JLabel getSimpleCountingModeLabel() {
        return simpleCountingModeLabel;
    }

    public JPanel getSimpleCountingModePanel() {
        return simpleCountingModePanel;
    }

    public NumberEditor getStepField() {
        return stepField;
    }

    public JLabel getStepLabel() {
        return stepLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JTextField getTotalNumberField() {
        return totalNumberField;
    }

    public JLabel getTotalNumberLabel() {
        return totalNumberLabel;
    }

    public ComputableDataEditor<Float> getTotalWeightField() {
        return totalWeightField;
    }

    public JLabel getTotalWeightLabel() {
        return totalWeightLabel;
    }

    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(resetButton);
        actionPanel.add(saveAndContinueButton);
        actionPanel.add(saveAndCloseButton);
    }

    protected void addChildrenToAutoGenModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; autoGenModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(autoGenModeButton); }
    }

    protected void addChildrenToAutoGenModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        autoGenModePanel.add($Table0, BorderLayout.SOUTH);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(modePanel, BorderLayout.WEST);
        configurationPanel.add(modeConfigurationPanel, BorderLayout.CENTER);
        configurationPanel.add(lengthstepSettingsBlock, BorderLayout.SOUTH);
    }

    protected void addChildrenToDataFieldPanel() {
        if (!allComponentsCreated) {
            return;
        }
        dataFieldPanel.add(firstSplitPane, "lengthCaracteristicPmfm");
        dataFieldPanel.add($Table2, "noLengthCaracteristicPmfm");
    }

    protected void addChildrenToDataInFrequenciesWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        dataInFrequenciesWarningContainer.add(dataInFrequenciesWarning, BorderLayout.CENTER);
    }

    protected void addChildrenToEditSpeciesFrequenciesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(dataFieldPanel, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToFirstSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        firstSplitPane.add(secondSplitPane, JSplitPane.LEFT);
        firstSplitPane.add(histogramPanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToLengthstepSettingsBlock() {
        if (!allComponentsCreated) {
            return;
        }
        lengthstepSettingsBlock.add($JSeparator0, new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(lengthStepCaracteristicLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add($JPanel1, new GridBagConstraints(1, 1, 5, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(stepLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(SwingUtil.boxComponentWithJxLayer(stepField), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalNumberLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalNumberField, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalWeightLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(SwingUtil.boxComponentWithJxLayer(totalWeightField), new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToLogsScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        logsScrollPane.getViewport().add(logsTable);
    }

    protected void addChildrenToModeConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        modeConfigurationPanel.add(autoGenModePanel, "autoGenMode");
        modeConfigurationPanel.add(rafaleModePanel, "rafaleMode");
        modeConfigurationPanel.add(simpleCountingModePanel, "simpleCountingMode");
    }

    protected void addChildrenToModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        modePanel.add(autoGenModeButton);
        modePanel.add(rafaleModeButton);
        modePanel.add(simpleCountingModeButton);
    }

    protected void addChildrenToRafaleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; rafaleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(rafaleModeButton); }
    }

    protected void addChildrenToRafaleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        rafaleModePanel.add($Table1, BorderLayout.SOUTH);
    }

    protected void addChildrenToSecondSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        secondSplitPane.add(logsScrollPane, JSplitPane.LEFT);
        secondSplitPane.add(SwingUtil.boxComponentWithJxLayer(tableScrollPane), JSplitPane.RIGHT);
    }

    protected void addChildrenToSimpleCountingModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; simpleCountingModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(simpleCountingModeButton); }
    }

    protected void addChildrenToSimpleCountingModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        simpleCountingModePanel.add(simpleCountingModeLabel, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createAddLengthStepCaracteristicAction() {
        $objectMap.put("addLengthStepCaracteristicAction", addLengthStepCaracteristicAction = new AddSpeciesFrequencyLengthStepCaracteristicAction(this));
    }

    protected void createAddLengthStepCaracteristicButton() {
        $objectMap.put("addLengthStepCaracteristicButton", addLengthStepCaracteristicButton = new JButton());
        
        addLengthStepCaracteristicButton.setName("addLengthStepCaracteristicButton");
        addLengthStepCaracteristicButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.addLengthStepCaracteristic.help");
    }

    protected void createAutoGenModeButton() {
        $objectMap.put("autoGenModeButton", autoGenModeButton = new JRadioButton());
        
        autoGenModeButton.setName("autoGenModeButton");
        autoGenModeButton.setText(t("tutti.editSpeciesFrequencies.field.mode.autoGen"));
        { autoGenModeButton.putClientProperty("$value", "autoGenMode");  Object $buttonGroup = autoGenModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        autoGenModeButton.setToolTipText(t("tutti.editSpeciesFrequencies.field.mode.autoGen.tip"));
        autoGenModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__autoGenModeButton"));
        autoGenModeButton.putClientProperty("help", "tutti.editSpeciesFrequencies.field.mode.autoGen.help");
    }

    protected void createAutoGenModePanel() {
        $objectMap.put("autoGenModePanel", autoGenModePanel = new JPanel());
        
        autoGenModePanel.setName("autoGenModePanel");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editSpeciesFrequencies.help"));
    }

    protected void createCancelAction() {
        $objectMap.put("cancelAction", cancelAction = new CancelEditSpeciesFrequencyAction(this));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new BorderLayout());
    }

    protected void createDataFieldLayout() {
        $objectMap.put("dataFieldLayout", dataFieldLayout = new CardLayout2Ext(this, "dataFieldPanel"));
    }

    protected void createDataFieldPanel() {
        $objectMap.put("dataFieldPanel", dataFieldPanel = new JPanel());
        
        dataFieldPanel.setName("dataFieldPanel");
        dataFieldPanel.setLayout(dataFieldLayout);
    }

    protected void createDataInFrequenciesWarning() {
        $objectMap.put("dataInFrequenciesWarning", dataInFrequenciesWarning = new JLabel());
        
        dataInFrequenciesWarning.setName("dataInFrequenciesWarning");
        dataInFrequenciesWarning.setText(t("tutti.editSpeciesFrequencies.simpleCountingAndFrequencies"));
    }

    protected void createDataInFrequenciesWarningContainer() {
        $objectMap.put("dataInFrequenciesWarningContainer", dataInFrequenciesWarningContainer = new JPanel());
        
        dataInFrequenciesWarningContainer.setName("dataInFrequenciesWarningContainer");
        dataInFrequenciesWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createFirstSplitPane() {
        $objectMap.put("firstSplitPane", firstSplitPane = new JSplitPane());
        
        firstSplitPane.setName("firstSplitPane");
        firstSplitPane.setOneTouchExpandable(true);
        firstSplitPane.setResizeWeight(0.6);
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.generate.help");
    }

    protected void createGenerateLengthStepsAction() {
        $objectMap.put("generateLengthStepsAction", generateLengthStepsAction = new GenerateSpeciesFrequencyLengthStepsAction(this));
    }

    protected SpeciesFrequencyUIHandler createHandler() {
        return new SpeciesFrequencyUIHandler();
    }

    protected void createHistogramPanel() {
        $objectMap.put("histogramPanel", histogramPanel = new JPanel());
        
        histogramPanel.setName("histogramPanel");
        histogramPanel.setLayout(new BorderLayout());
    }

    protected void createLengthStepCaracteristicComboBox() {
        $objectMap.put("lengthStepCaracteristicComboBox", lengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        lengthStepCaracteristicComboBox.setName("lengthStepCaracteristicComboBox");
        lengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        lengthStepCaracteristicComboBox.setShowReset(true);
        lengthStepCaracteristicComboBox.putClientProperty("help", "tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.help");
        lengthStepCaracteristicComboBox.putClientProperty("validatorLabel", t("tutti.editSpeciesFrequencies.field.lengthStepCaracteristic"));
    }

    protected void createLengthStepCaracteristicLabel() {
        $objectMap.put("lengthStepCaracteristicLabel", lengthStepCaracteristicLabel = new JLabel());
        
        lengthStepCaracteristicLabel.setName("lengthStepCaracteristicLabel");
        lengthStepCaracteristicLabel.setText(t("tutti.editSpeciesFrequencies.field.lengthStepCaracteristic"));
        lengthStepCaracteristicLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.tip"));
        lengthStepCaracteristicLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.help");
    }

    protected void createLengthstepSettingsBlock() {
        $objectMap.put("lengthstepSettingsBlock", lengthstepSettingsBlock = new Table());
        
        lengthstepSettingsBlock.setName("lengthstepSettingsBlock");
    }

    protected void createLogsScrollPane() {
        $objectMap.put("logsScrollPane", logsScrollPane = new JScrollPane());
        
        logsScrollPane.setName("logsScrollPane");
    }

    protected void createLogsTable() {
        $objectMap.put("logsTable", logsTable = new JXTable());
        
        logsTable.setName("logsTable");
        logsTable.setSortable(false);
    }

    protected void createMaxStepField() {
        $objectMap.put("maxStepField", maxStepField = new NumberEditor(this));
        
        maxStepField.setName("maxStepField");
        maxStepField.setProperty("maxStep");
        maxStepField.setShowReset(true);
        maxStepField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.maxStep.help");
        maxStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createMaxStepLabel() {
        $objectMap.put("maxStepLabel", maxStepLabel = new JLabel());
        
        maxStepLabel.setName("maxStepLabel");
        maxStepLabel.setText(t("tutti.editSpeciesFrequencies.field.maxStep"));
        maxStepLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.maxStep.tip"));
        maxStepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.maxStep.help");
    }

    protected void createMinStepField() {
        $objectMap.put("minStepField", minStepField = new NumberEditor(this));
        
        minStepField.setName("minStepField");
        minStepField.setProperty("minStep");
        minStepField.setShowReset(true);
        minStepField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.minStep.help");
        minStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createMinStepLabel() {
        $objectMap.put("minStepLabel", minStepLabel = new JLabel());
        
        minStepLabel.setName("minStepLabel");
        minStepLabel.setText(t("tutti.editSpeciesFrequencies.field.minStep"));
        minStepLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.minStep.tip"));
        minStepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.minStep.help");
    }

    protected void createMode() {
        $objectMap.put("mode", mode = new JAXXButtonGroup());
    }

    protected void createModeConfigurationLayout() {
        $objectMap.put("modeConfigurationLayout", modeConfigurationLayout = new CardLayout2Ext(this, "modeConfigurationPanel"));
    }

    protected void createModeConfigurationPanel() {
        $objectMap.put("modeConfigurationPanel", modeConfigurationPanel = new JPanel());
        
        modeConfigurationPanel.setName("modeConfigurationPanel");
        modeConfigurationPanel.setLayout(modeConfigurationLayout);
    }

    protected void createModePanel() {
        $objectMap.put("modePanel", modePanel = new VBox());
        
        modePanel.setName("modePanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesFrequencyUIModel.class));
    }

    protected void createRafaleModeButton() {
        $objectMap.put("rafaleModeButton", rafaleModeButton = new JRadioButton());
        
        rafaleModeButton.setName("rafaleModeButton");
        rafaleModeButton.setText(t("tutti.editSpeciesFrequencies.field.mode.rafale"));
        { rafaleModeButton.putClientProperty("$value", "rafaleMode");  Object $buttonGroup = rafaleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        rafaleModeButton.setToolTipText(t("tutti.editSpeciesFrequencies.field.mode.rafale.tip"));
        rafaleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rafaleModeButton"));
        rafaleModeButton.putClientProperty("help", "tutti.editSpeciesFrequencies.field.mode.rafale.help");
    }

    protected void createRafaleModePanel() {
        $objectMap.put("rafaleModePanel", rafaleModePanel = new JPanel());
        
        rafaleModePanel.setName("rafaleModePanel");
    }

    protected void createRafaleStepField() {
        $objectMap.put("rafaleStepField", rafaleStepField = new NumberEditor(this));
        
        rafaleStepField.setName("rafaleStepField");
        rafaleStepField.setShowReset(true);
        rafaleStepField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.rafaleStep.help");
        rafaleStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createRafaleStepLabel() {
        $objectMap.put("rafaleStepLabel", rafaleStepLabel = new JLabel());
        
        rafaleStepLabel.setName("rafaleStepLabel");
        rafaleStepLabel.setText(t("tutti.editSpeciesFrequencies.field.rafaleStep"));
        rafaleStepLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.rafaleStep.tip"));
        rafaleStepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.rafaleStep.help");
    }

    protected void createResetAction() {
        $objectMap.put("resetAction", resetAction = new ResetSpeciesFrequencyAction(this));
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.reset.help");
    }

    protected void createSaveAndCloseAction() {
        $objectMap.put("saveAndCloseAction", saveAndCloseAction = new SaveAndCloseSpeciesFrequencyAction(this));
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.saveAndClose.help");
    }

    protected void createSaveAndContinueAction() {
        $objectMap.put("saveAndContinueAction", saveAndContinueAction = new SaveAndContinueSpeciesFrequencyAction(this));
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.saveAndContinue.help");
    }

    protected void createSecondSplitPane() {
        $objectMap.put("secondSplitPane", secondSplitPane = new JSplitPane());
        
        secondSplitPane.setName("secondSplitPane");
        secondSplitPane.setOneTouchExpandable(true);
        secondSplitPane.setResizeWeight(0.1);
    }

    protected void createSimpleCountingField() {
        $objectMap.put("simpleCountingField", simpleCountingField = new NumberEditor(this));
        
        simpleCountingField.setName("simpleCountingField");
        simpleCountingField.setProperty("simpleCount");
        simpleCountingField.setShowReset(true);
        simpleCountingField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.simpleCounting.help");
        simpleCountingField.putClientProperty("selectOnFocus", true);
    }

    protected void createSimpleCountingLabel() {
        $objectMap.put("simpleCountingLabel", simpleCountingLabel = new JLabel());
        
        simpleCountingLabel.setName("simpleCountingLabel");
        simpleCountingLabel.setText(t("tutti.editSpeciesFrequencies.field.simpleCounting"));
        simpleCountingLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.simpleCounting.tip"));
        simpleCountingLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.simpleCounting.help");
    }

    protected void createSimpleCountingModeButton() {
        $objectMap.put("simpleCountingModeButton", simpleCountingModeButton = new JRadioButton());
        
        simpleCountingModeButton.setName("simpleCountingModeButton");
        simpleCountingModeButton.setText(t("tutti.editSpeciesFrequencies.field.mode.simpleCounting"));
        { simpleCountingModeButton.putClientProperty("$value", "simpleCountingMode");  Object $buttonGroup = simpleCountingModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        simpleCountingModeButton.setToolTipText(t("tutti.editSpeciesFrequencies.field.mode.simpleCounting.tip"));
        simpleCountingModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleCountingModeButton"));
        simpleCountingModeButton.putClientProperty("help", "tutti.editSpeciesFrequencies.field.mode.simpleCounting.help");
    }

    protected void createSimpleCountingModeLabel() {
        $objectMap.put("simpleCountingModeLabel", simpleCountingModeLabel = new JLabel());
        
        simpleCountingModeLabel.setName("simpleCountingModeLabel");
        simpleCountingModeLabel.setEnabled(false);
        simpleCountingModeLabel.setText(t("tutti.editSpeciesFrequencies.label.no.configuration"));
    }

    protected void createSimpleCountingModePanel() {
        $objectMap.put("simpleCountingModePanel", simpleCountingModePanel = new JPanel());
        
        simpleCountingModePanel.setName("simpleCountingModePanel");
        simpleCountingModePanel.setLayout(new BorderLayout());
    }

    protected void createStepField() {
        $objectMap.put("stepField", stepField = new NumberEditor(this));
        
        stepField.setName("stepField");
        stepField.setProperty("step");
        stepField.setShowReset(true);
        stepField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.step.help");
        stepField.putClientProperty("validatorLabel", t("tutti.editSpeciesFrequencies.field.step"));
        stepField.putClientProperty("selectOnFocus", true);
    }

    protected void createStepLabel() {
        $objectMap.put("stepLabel", stepLabel = new JLabel());
        
        stepLabel.setName("stepLabel");
        stepLabel.setText(t("tutti.editSpeciesFrequencies.field.step"));
        stepLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.step.tip"));
        stepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.step.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
        tableScrollPane.putClientProperty("validatorLabel", t("tutti.editSpeciesFrequencies.field.rows"));
    }

    protected void createTotalNumberField() {
        $objectMap.put("totalNumberField", totalNumberField = new JTextField());
        
        totalNumberField.setName("totalNumberField");
        totalNumberField.setColumns(15);
        totalNumberField.setEnabled(false);
        totalNumberField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.totalNumber.help");
        totalNumberField.putClientProperty("computed", true);
    }

    protected void createTotalNumberLabel() {
        $objectMap.put("totalNumberLabel", totalNumberLabel = new JLabel());
        
        totalNumberLabel.setName("totalNumberLabel");
        totalNumberLabel.setText(t("tutti.editSpeciesFrequencies.field.totalNumber"));
        totalNumberLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.totalNumber.tip"));
        totalNumberLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.totalNumber.help");
    }

    protected void createTotalWeightField() {
        $objectMap.put("totalWeightField", totalWeightField = new ComputableDataEditor<Float>(this));
        
        totalWeightField.setName("totalWeightField");
        totalWeightField.setShowReset(true);
        totalWeightField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.totalWeight.help");
        totalWeightField.putClientProperty("validatorLabel", t("tutti.editSpeciesFrequencies.field.totalWeight"));
        totalWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createTotalWeightLabel() {
        $objectMap.put("totalWeightLabel", totalWeightLabel = new JLabel());
        
        totalWeightLabel.setName("totalWeightLabel");
        totalWeightLabel.setText(t("tutti.editSpeciesFrequencies.field.totalWeight"));
        totalWeightLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.totalWeight.tip"));
        totalWeightLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.totalWeight.help");
        totalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesFrequencyUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditSpeciesFrequenciesTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToModePanel();
        addChildrenToAutoGenModeButton();
        addChildrenToRafaleModeButton();
        addChildrenToSimpleCountingModeButton();
        addChildrenToModeConfigurationPanel();
        addChildrenToAutoGenModePanel();
        // inline complete setup of $Table0
        $Table0.add(minStepLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(minStepField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(generateButton);
        addChildrenToRafaleModePanel();
        // inline complete setup of $Table1
        $Table1.add(rafaleStepLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(rafaleStepField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSimpleCountingModePanel();
        addChildrenToLengthstepSettingsBlock();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(lengthStepCaracteristicComboBox), BorderLayout.CENTER);
        $JPanel1.add(addLengthStepCaracteristicButton, BorderLayout.EAST);
        addChildrenToDataFieldPanel();
        addChildrenToFirstSplitPane();
        addChildrenToSecondSplitPane();
        addChildrenToLogsScrollPane();
        addChildrenToTableScrollPane();
        // inline complete setup of $Table2
        $Table2.add(dataInFrequenciesWarningContainer, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(simpleCountingLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(simpleCountingField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToDataInFrequenciesWarningContainer();
        addChildrenToActionPanel();
        
        // apply 26 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 70 property setters
        modePanel.setVerticalAlignment(SwingConstants.CENTER);
        lengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        configurationPanel.setBorder(new TitledBorder(null, null));
        autoGenModeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesFrequencies.field.mode.autoGen.mnemonic"),'Z'));
        rafaleModeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesFrequencies.field.mode.rafale.mnemonic"),'Z'));
        simpleCountingModeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesFrequencies.field.mode.simpleCounting.mnemonic"),'Z'));
        minStepLabel.setLabelFor(minStepField);
        minStepField.setBean(model);
        minStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        minStepField.setNumberPattern(DECIMAL1_PATTERN);
        minStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        minStepField.setNumberType(Float.class);
        maxStepLabel.setLabelFor(maxStepField);
        maxStepField.setBean(model);
        maxStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        maxStepField.setNumberPattern(DECIMAL1_PATTERN);
        maxStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        maxStepField.setNumberType(Float.class);
        generateButton.setAction(generateLengthStepsAction);
        rafaleStepLabel.setLabelFor(rafaleStepField);
        rafaleStepField.setBean(model);
        rafaleStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rafaleStepField.setNumberPattern(DECIMAL1_PATTERN);
        rafaleStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        rafaleStepField.setNumberType(Float.class);
        simpleCountingModeLabel.setHorizontalAlignment(JLabel.CENTER);
        lengthStepCaracteristicLabel.setLabelFor(lengthStepCaracteristicComboBox);
        lengthStepCaracteristicComboBox.setBean(model);
        addLengthStepCaracteristicButton.setAction(addLengthStepCaracteristicAction);
        stepLabel.setLabelFor(stepField);
        stepField.setBean(model);
        stepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        stepField.setNumberPattern(DECIMAL1_PATTERN);
        stepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        stepField.setNumberType(Float.class);
        totalNumberLabel.setLabelFor(totalNumberField);
        totalWeightLabel.setLabelFor(totalWeightField);
        totalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        totalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        totalWeightField.setNumberType(Float.class);
        logsTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        logsTable.setSelectionForeground(Color.BLACK);
        logsTable.setSelectionBackground(null);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        dataInFrequenciesWarningContainer.setBackground(new java.awt.Color(245, 218, 88));
        dataInFrequenciesWarning.setIcon(SwingUtil.createActionIcon("warning"));
        dataInFrequenciesWarning.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        simpleCountingLabel.setLabelFor(simpleCountingField);
        simpleCountingField.setBean(model);
        simpleCountingField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        simpleCountingField.setNumberPattern(INT_6_DIGITS_PATTERN);
        simpleCountingField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        simpleCountingField.setNumberType(Integer.class);
        cancelButton.setAction(cancelAction);
        resetButton.setAction(resetAction);
        saveAndContinueButton.setAction(saveAndContinueAction);
        saveAndCloseButton.setAction(saveAndCloseAction);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editSpeciesFrequenciesTopPanel, "tutti.editSpeciesFrequencies.help");
        registerHelpId(_broker, autoGenModeButton, "tutti.editSpeciesFrequencies.field.mode.autoGen.help");
        registerHelpId(_broker, rafaleModeButton, "tutti.editSpeciesFrequencies.field.mode.rafale.help");
        registerHelpId(_broker, simpleCountingModeButton, "tutti.editSpeciesFrequencies.field.mode.simpleCounting.help");
        registerHelpId(_broker, minStepLabel, "tutti.editSpeciesFrequencies.field.minStep.help");
        registerHelpId(_broker, minStepField, "tutti.editSpeciesFrequencies.field.minStep.help");
        registerHelpId(_broker, maxStepLabel, "tutti.editSpeciesFrequencies.field.maxStep.help");
        registerHelpId(_broker, maxStepField, "tutti.editSpeciesFrequencies.field.maxStep.help");
        registerHelpId(_broker, generateButton, "tutti.editSpeciesFrequencies.action.generate.help");
        registerHelpId(_broker, rafaleStepLabel, "tutti.editSpeciesFrequencies.field.rafaleStep.help");
        registerHelpId(_broker, rafaleStepField, "tutti.editSpeciesFrequencies.field.rafaleStep.help");
        registerHelpId(_broker, lengthStepCaracteristicLabel, "tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.help");
        registerHelpId(_broker, lengthStepCaracteristicComboBox, "tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.help");
        registerHelpId(_broker, addLengthStepCaracteristicButton, "tutti.editSpeciesFrequencies.action.addLengthStepCaracteristic.help");
        registerHelpId(_broker, stepLabel, "tutti.editSpeciesFrequencies.field.step.help");
        registerHelpId(_broker, stepField, "tutti.editSpeciesFrequencies.field.step.help");
        registerHelpId(_broker, totalNumberLabel, "tutti.editSpeciesFrequencies.field.totalNumber.help");
        registerHelpId(_broker, totalNumberField, "tutti.editSpeciesFrequencies.field.totalNumber.help");
        registerHelpId(_broker, totalWeightLabel, "tutti.editSpeciesFrequencies.field.totalWeight.help");
        registerHelpId(_broker, totalWeightField, "tutti.editSpeciesFrequencies.field.totalWeight.help");
        registerHelpId(_broker, simpleCountingLabel, "tutti.editSpeciesFrequencies.field.simpleCounting.help");
        registerHelpId(_broker, simpleCountingField, "tutti.editSpeciesFrequencies.field.simpleCounting.help");
        registerHelpId(_broker, cancelButton, "tutti.editSpeciesFrequencies.action.cancel.help");
        registerHelpId(_broker, resetButton, "tutti.editSpeciesFrequencies.action.reset.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.editSpeciesFrequencies.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.editSpeciesFrequencies.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editSpeciesFrequenciesTopPanel", editSpeciesFrequenciesTopPanel);
        createModel();
        createValidator();
        createBroker();
        createModeConfigurationLayout();
        createDataFieldLayout();
        createAddLengthStepCaracteristicAction();
        createGenerateLengthStepsAction();
        createCancelAction();
        createResetAction();
        createSaveAndCloseAction();
        createSaveAndContinueAction();
        createConfigurationPanel();
        createModePanel();
        createAutoGenModeButton();
        createRafaleModeButton();
        createSimpleCountingModeButton();
        createModeConfigurationPanel();
        createAutoGenModePanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMinStepLabel();
        createMinStepField();
        createMaxStepLabel();
        createMaxStepField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createGenerateButton();
        createRafaleModePanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createRafaleStepLabel();
        createRafaleStepField();
        createSimpleCountingModePanel();
        createSimpleCountingModeLabel();
        createLengthstepSettingsBlock();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createLengthStepCaracteristicLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createLengthStepCaracteristicComboBox();
        createAddLengthStepCaracteristicButton();
        createStepLabel();
        createStepField();
        createTotalNumberLabel();
        createTotalNumberField();
        createTotalWeightLabel();
        createTotalWeightField();
        createDataFieldPanel();
        createFirstSplitPane();
        createSecondSplitPane();
        createLogsScrollPane();
        createLogsTable();
        createTableScrollPane();
        createTable();
        createHistogramPanel();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createDataInFrequenciesWarningContainer();
        createDataInFrequenciesWarning();
        createSimpleCountingLabel();
        createSimpleCountingField();
        createActionPanel();
        createCancelButton();
        createResetButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        createMode();
        // inline creation of editSpeciesFrequenciesTopPanel
        setName("editSpeciesFrequenciesTopPanel");
        setLayout(new BorderLayout());
        editSpeciesFrequenciesTopPanel.putClientProperty("help", "tutti.editSpeciesFrequencies.help");
        
        // registers 26 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 26 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (mode != null) {
                    mode.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (mode != null) {
                    modeConfigurationLayout.setSelected(String.valueOf(mode.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (mode != null) {
                    mode.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_FIELD_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dataFieldLayout.setSelected(model.isSimpleCountingMode() ? "noLengthCaracteristicPmfm" : "lengthCaracteristicPmfm");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_LENGTH_STEPS_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateLengthStepsAction.setEnabled(model.isCanGenerate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseAction.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_ACTION_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nextEditableRowIndex", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueAction.setEnabled(model.getNextEditableRowIndex() != null && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nextEditableRowIndex", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AUTO_GEN_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("autoGenMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    autoGenModeButton.setSelected(model.isAutoGenMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("autoGenMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rafaleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleModeButton.setSelected(model.isRafaleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rafaleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingModeButton.setSelected(model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MIN_STEP_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minStepField.setNumberValue(model.getMinStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAX_STEP_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    maxStepField.setNumberValue(model.getMaxStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_STEP_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleStepField.setEnabled(model.getLengthStepCaracteristic() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTHSTEP_SETTINGS_BLOCK_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthstepSettingsBlock.setVisible(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("canEditLengthStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setEnabled(!model.isSimpleCountingMode() && model.isCanEditLengthStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("canEditLengthStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("canEditLengthStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setEnabled(!model.isSimpleCountingMode() && model.isCanEditLengthStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("canEditLengthStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setNumberValue(model.getStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_NUMBER_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalNumberLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(totalNumberField, getStringValue(model.getTotalNumber()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightLabel.setEnabled(model.getTotalWeight() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setBean(model.getTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setNumberValue(model.getTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getLengthStepCaracteristic() != null && model.getStep() > 0f);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_IN_FREQUENCIES_WARNING_CONTAINER_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rowsInError", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("emptyRows", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("rows", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getRows() != null && model.getEmptyRows() != null && model.getRowsInError() != null) {
                    dataInFrequenciesWarningContainer.setVisible((model.getRowsInError().size() + model.getEmptyRows().size()) != model.getRows().size());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rowsInError", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("emptyRows", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("rows", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingField.setNumberValue(model.getSimpleCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCount", this);
                }
            }
        });
    }

}