/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.report.ReportModel;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.report.ReportUI;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIHandler;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIModel;
import org.nuiton.i18n.I18n;

public class GenerateReportAction
extends AbstractTuttiAction<ReportUIModel, ReportUI, ReportUIHandler> {
    public GenerateReportAction(ReportUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            doAction = this.askOverwriteFile(((ReportUIModel)this.getModel()).getOutputFile());
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkState((boolean)((ReportUIModel)this.getModel()).isValid());
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(4);
        ReportModel reportModel = (ReportModel)((ReportUIModel)this.getModel()).toBean();
        this.getContext().getReportService().generateReport(reportModel, progressionModel);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.report.generated", (Object[])new Object[]{((ReportUIModel)this.getModel()).getOutputFile()}));
        ((ReportUIModel)this.getModel()).reloadOuputFile();
    }
}

