/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.ArrayList;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.TableColumn;

public final class ColumnHelper {
    public static TableColumn findColumn(Module module, ContainerSlot columnSlot, int columnIndex) {
        assert (columnIndex > 0);
        int i = 0;
        int index = 0;
        while (i < columnSlot.getCount()) {
            TableColumn column = (TableColumn)columnSlot.getContent(i);
            if ((index += ColumnHelper.getColumnRepeat(module, column)) >= columnIndex) {
                return column;
            }
            ++i;
        }
        return null;
    }

    public static TableColumn[] getTableColumnArray(Module module, ContainerSlot columnSlot) {
        int colNum = columnSlot.getCount();
        ArrayList<TableColumn> tmpColumns = new ArrayList<TableColumn>();
        int i = 0;
        while (i < colNum) {
            TableColumn tmpColumn = (TableColumn)columnSlot.getContent(i);
            int repeat = ColumnHelper.getColumnRepeat(module, tmpColumn);
            int j = 0;
            while (j < repeat) {
                tmpColumns.add(tmpColumn);
                ++j;
            }
            ++i;
        }
        return tmpColumns.toArray(new TableColumn[0]);
    }

    public static TableColumn getColumnInArray(TableColumn[] columnArray, int columnNum) {
        if (columnArray == null) {
            return null;
        }
        int colIndex = columnNum - 1;
        if (colIndex < columnArray.length) {
            return columnArray[colIndex];
        }
        return null;
    }

    private static int getColumnRepeat(Module module, TableColumn column) {
        int repeat = column.getIntProperty(module, "repeat");
        repeat = repeat <= 0 ? 1 : repeat;
        return repeat;
    }
}

