package fr.ifremer.tutti.ui.swing.util.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.service.WeightUnit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class EnterMelagWeightDialog extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_WEIGHT_UNIT = "weightUnit";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1Vz28bRRSeuLETJ6WBRq1S0Uhu+kMJKuv2VikUGtJEEDmhilO1qg8w3n2xp5qdnc7MJluiIv4E/gS4c0Hixglx4MyBC+JfQIgDV8Sb2fVuHW9q+7Cy33vfm2++/d7z93+Rqlbk2nOaJJ6KhWEheDsbT59+1n0OvnkI2ldMmkiR9DNVIZUOmQ/yuDbkeqdl4c0M3tyMQhkJEK+h11tkTpuXHHQfwBiyPIzwtW628/R6ImM16JqTKuv67T9/V74Jvv6uQkgikd0sXqUxDlXcZLpFKiww5CKedESbnIoe0lBM9JDvWza2yanWezSEF+QrMtMiNUkVNjNkZfIrux4On0hDagGjPOoZcv9QeexQQQjKM7ExzIuZp4/xcC82jHtags9Ae1vCgNoFTntPgPX65qHDS+la1gyZO3bhx4IhresjTTWoI+aD9ySvKqBVQ7scDFkakizlcGBTtq6el8+EoDXtIeCi1SbJKndatAvc1izkpTUIGGpgyK2S1mnO24vDLqgt92MYPXtj5xEVwO+cPslFh0md96nwgX+Ml42EIYtD9WnUVi7lgAtHlLOAGiiSy1mFIu8O0UVbeoUtC99MdUhVxRhG6TqjTt7HVOrhpVMetg1d9r/Li7//9OeP2wPjzuDZl0pLX5s7NJRUkQRlmD16IXWtNUtzl8r1Dqlr4Di0biivlhBrZ2kkh+e9Y+Gp1z6huo8tqjN//PzL5S9+O0cq22SORzTYprb+U1I3fYUqRDxI5EcPHKPzx7P4fNtys05ixjpp4+Tz1ZXUeL4CFLmdutj513NFK7cbhWM9dFO7j0ZxHlpdW3uVoGxXS2TLuXfrv/672P7hwUC6KbzKlTPLC/mqz0iNCc4EuKnPBrp0yuelhjiIisEtG2WSz7LMJuqme66N6FNBW+Id2ZdoUMo3OOuJ0C2RhZN0drzNrb2Drf1XhkwbSDCx+UYZszEcK6Rl875TyH5rkmKCxzGuYmmsoY1M8d0eUq7x3dZpbKJHkYyl5aliDM1i0Tb6xOSROprkeB80FKEFG3K4wZC6RBm/bG2Mo3cuF+rWmSKhcVkkvHQ74Jpgd++JXQFhJJhvSHMynBfmiHkTRfyAyQN37nsT4g2TZfccWlrjbjuNLwOEXcf4V7V80sjWJ77w3Siw77px7X5DxJw3CgOtjuM3WIIjytydFHmmNrcn7nCGOqc29Dh9cP3UOH0ZYTG58AHiaKPLRIB/AB+OdJ+yz7mxHW3YbYhRl7rcFezwP8h/i/w6CQAA";
    private static final Log log = LogFactory.getLog(EnterMelagWeightDialog.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected EnterMelagWeightDialog dialog = this;
    protected NumberEditor editor;
    protected JLabel message;
    protected Table table;
    protected JButton validateButton;
    protected WeightUnit weightUnit;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EnterMelagWeightDialog(Frame frame, KeyStroke shortcutClosePopup) {
        super(frame, true);
        
            // add a auto-close action
            rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                    shortcutClosePopup, "close");
        
            addWindowListener(new WindowAdapter() {
        
                @Override
                public void windowClosed(WindowEvent e) {
                    Component ui = (Component) e.getSource();
                    JAXXUtil.destroy(ui);
                }
            });
            $initialize();
    }

    public EnterMelagWeightDialog(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Dialog param0) {
        super(param0);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Frame param0) {
        super(param0);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog() {
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Window param0) {
        super(param0);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        editor.setModel(null); dispose();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public NumberEditor getEditor() {
        return editor;
    }

    public JLabel getMessage() {
        return message;
    }

    public Table getTable() {
        return table;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public WeightUnit getWeightUnit() {
        return weightUnit;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setWeightUnit(WeightUnit weightUnit) {
        WeightUnit oldValue = this.weightUnit;
        this.weightUnit = weightUnit;
        firePropertyChange(PROPERTY_WEIGHT_UNIT, oldValue, weightUnit);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(table, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTable() {
        if (!allComponentsCreated) {
            return;
        }
        table.add(message, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        table.add(editor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createSpeciesMelag.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createSpeciesMelag.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new NumberEditor());
        
        editor.setName("editor");
        editor.setUseSign(false);
        editor.setAutoPopup(true);
        editor.setUseFloat(true);
        editor.setShowReset(true);
        editor.setShowPopupButton(true);
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JLabel());
        
        message.setName("message");
    }

    protected void createTable() {
        $objectMap.put("table", table = new Table());
        
        table.setName("table");
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(_("tutti.createSpeciesMelag.action.validate"));
        validateButton.setToolTipText(_("tutti.createSpeciesMelag.action.validate.tip"));
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    protected void createWeightUnit() {
        $objectMap.put("weightUnit", weightUnit = WeightUnit.KG);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDialog();
        addChildrenToTable();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        setTitle(_("tutti.createSpeciesMelag.title", weightUnit.getShortLabel()));
        message.setHorizontalAlignment(JLabel.CENTER);
        message.setText(_("tutti.createSpeciesMelag.message", weightUnit.getShortLabel()));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createSpeciesMelag.action.cancel.mnemonic"),'Z'));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createSpeciesMelag.action.validate.mnemonic"),'Z'));
        // late initializer
        dialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("dialog", dialog);
        createWeightUnit();
        createTable();
        createMessage();
        createEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createValidateButton();
        // inline creation of dialog
        setName("dialog");
        dialog.getContentPane().setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editor != null) {
                    editor.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editor != null) {
                    validateButton.setEnabled( editor.getModel() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editor != null) {
                    editor.removePropertyChangeListener("model", this);
                }
            }
        });
    }

}