package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProtocolUIModel.java 1274 2013-10-04 07:14:17Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/EditProtocolUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class EditProtocolUIModel extends AbstractTuttiBeanUIModel<TuttiProtocol, EditProtocolUIModel> implements TuttiProtocol {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SPECIES_ROW = "speciesRow";

    public static final String PROPERTY_BENTHOS_ROW = "benthosRow";

    public static final String PROPERTY_REMOVE_SPECIES_ENABLED = "removeSpeciesEnabled";

    public static final String PROPERTY_REMOVE_BENTHOS_ENABLED = "removeBenthosEnabled";

    public static final String PROPERTY_IMPORTED = "imported";

    public static final String PROPERTY_CLONED = "cloned";

    public static final String PROPERTY_CLEANED = "cleaned";

    /**
     * Delegate edit object.
     *
     * @since 1.3
     */
    protected final TuttiProtocol editObject = TuttiProtocols.newTuttiProtocol();

    /**
     * Flag when a incoming protocol is imported.
     *
     * @since 1.0
     */
    protected boolean imported;

    /**
     * Flag when a incoming protocol is cloned.
     *
     * @since 1.0
     */
    protected boolean cloned;

    /**
     * Flag when a incoming protocol is cleaned.
     *
     * @since 2.4
     */
    protected boolean cleaned;

    /**
     * Can user remove a selected species?
     *
     * @since 0.3
     */
    protected boolean removeSpeciesEnabled;

    /**
     * Can user remove a selected benthos?
     *
     * @since 0.3
     */
    protected boolean removeBenthosEnabled;

    protected List<Species> allSpecies;

    protected List<Species> allSynonyms;

    protected Multimap<String, Species> allSpeciesByTaxonId;

    protected Map<String, Species> allReferentSpeciesByTaxonId;

    protected List<Caracteristic> caracteristics;

    protected Map<String, Caracteristic> allCaracteristic;

    protected List<EditProtocolSpeciesRowModel> speciesRow;

    protected List<EditProtocolSpeciesRowModel> benthosRow;

    protected static Binder<EditProtocolUIModel, TuttiProtocol> toBeanBinder =
            BinderFactory.newBinder(EditProtocolUIModel.class,
                                    TuttiProtocol.class);

    protected static Binder<TuttiProtocol, EditProtocolUIModel> fromBeanBinder =
            BinderFactory.newBinder(TuttiProtocol.class, EditProtocolUIModel.class);

    public EditProtocolUIModel() {
        super(TuttiProtocol.class, fromBeanBinder, toBeanBinder);
    }

    @Override
    protected TuttiProtocol newEntity() {
        return TuttiProtocols.newTuttiProtocol();
    }

    public void setLengthClassesPmfm(List<Caracteristic> lengthClassesPmfm) {
        List<String> ids = Lists.newArrayList(TuttiEntities.collecIds(lengthClassesPmfm));
        setLengthClassesPmfmId(ids);
    }

    public void setGearUseFeaturePmfm(List<Caracteristic> gearUseFeaturePmfm) {
        List<String> ids = TuttiEntities.collecIds(gearUseFeaturePmfm);
        setGearUseFeaturePmfmId(ids);
    }

    public void setVesselUseFeaturePmfm(List<Caracteristic> vesselUseFeaturePmfm) {
        List<String> ids = TuttiEntities.collecIds(vesselUseFeaturePmfm);
        setVesselUseFeaturePmfmId(ids);
    }

    public void setIndividualObservationPmfm(List<Caracteristic> individualObservationPmfm) {
        List<String> ids = TuttiEntities.collecIds(individualObservationPmfm);
        setIndividualObservationPmfmId(ids);
    }

    public List<EditProtocolSpeciesRowModel> getSpeciesRow() {
        return speciesRow;
    }

    public void setSpeciesRow(List<EditProtocolSpeciesRowModel> speciesRow) {
        Object oldValue = getSpeciesRow();
        this.speciesRow = speciesRow;
        firePropertyChange(PROPERTY_SPECIES_ROW, oldValue, speciesRow);
    }

    public List<EditProtocolSpeciesRowModel> getBenthosRow() {
        return benthosRow;
    }

    public void setBenthosRow(List<EditProtocolSpeciesRowModel> benthosRow) {
        Object oldValue = getBenthosRow();
        this.benthosRow = benthosRow;
        firePropertyChange(PROPERTY_BENTHOS_ROW, oldValue, benthosRow);
    }

    public boolean isRemoveSpeciesEnabled() {
        return removeSpeciesEnabled;
    }

    public void setRemoveSpeciesEnabled(boolean removeSpeciesEnabled) {
        this.removeSpeciesEnabled = removeSpeciesEnabled;
        firePropertyChange(PROPERTY_REMOVE_SPECIES_ENABLED, null, removeSpeciesEnabled);
    }

    public boolean isRemoveBenthosEnabled() {
        return removeBenthosEnabled;
    }

    public void setRemoveBenthosEnabled(boolean removeBenthosEnabled) {
        this.removeBenthosEnabled = removeBenthosEnabled;
        firePropertyChange(PROPERTY_REMOVE_BENTHOS_ENABLED, null, removeBenthosEnabled);
    }

    public boolean isImported() {
        return imported;
    }

    public void setImported(boolean imported) {
        Object oldValue = isImported();
        this.imported = imported;
        firePropertyChange(PROPERTY_IMPORTED, oldValue, imported);
    }

    public boolean isCloned() {
        return cloned;
    }

    public void setCloned(boolean cloned) {
        Object oldValue = isCloned();
        this.cloned = cloned;
        firePropertyChange(PROPERTY_CLONED, oldValue, cloned);
    }

    public boolean isCleaned() {
        return cleaned;
    }

    public void setCleaned(boolean cleaned) {
        Object oldValue = isCleaned();
        this.cleaned = cleaned;
        firePropertyChange(PROPERTY_CLEANED, oldValue, cleaned);
    }

    public List<Species> getAllSpecies() {
        return allSpecies;
    }

    public void setAllSpecies(List<Species> allSpecies) {
        this.allSpecies = allSpecies;
        if (allReferentSpeciesByTaxonId != null && allSpecies != null) {
            allSynonyms = Lists.newArrayList(allSpecies);
            allSynonyms.removeAll(allReferentSpeciesByTaxonId.values());
        }
    }

    public Multimap<String, Species> getAllSpeciesByTaxonId() {
        return allSpeciesByTaxonId;
    }

    public Collection<Species> getAllSynonyms(String taxonId) {
        return allSpeciesByTaxonId.get(taxonId);
    }

    public void setAllSpeciesByTaxonId(Multimap<String, Species> allSpeciesByTaxonId) {
        this.allSpeciesByTaxonId = allSpeciesByTaxonId;
    }

    public List<Species> getAllSynonyms() {
        return allSynonyms;
    }

    public Map<String, Species> getAllReferentSpeciesByTaxonId() {
        return allReferentSpeciesByTaxonId;
    }

    public void setAllReferentSpeciesByTaxonId(Map<String, Species> allReferentSpeciesByTaxonId) {
        this.allReferentSpeciesByTaxonId = allReferentSpeciesByTaxonId;
        if (allReferentSpeciesByTaxonId != null && allSpecies != null) {
            allSynonyms = Lists.newArrayList(allSpecies);
            // tchemit-2013-10-04 Do not do a removeAll (bad performance)
            for (Species species : allReferentSpeciesByTaxonId.values()) {
                allSynonyms.remove(species);
            }
        }
    }

    public List<Caracteristic> getCaracteristics() {
        return caracteristics;
    }

    public void setCaracteristics(List<Caracteristic> caracteristics) {
        this.caracteristics = caracteristics;
    }

    public Map<String, Caracteristic> getAllCaracteristic() {
        return allCaracteristic;
    }

    public void setAllCaracteristic(Map<String, Caracteristic> allCaracteristic) {
        this.allCaracteristic = allCaracteristic;
    }

    //------------------------------------------------------------------------//
    //-- TuttiProtocol methods                                              --//
    //------------------------------------------------------------------------//

    @Override
    public String getName() {
        return editObject.getName();
    }

    @Override
    public void setName(String name) {
        Object oldValue = getName();
        editObject.setName(name);
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getComment() {
        return editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        Object oldValue = getComment();
        editObject.setComment(comment);
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public List<String> getLengthClassesPmfmId() {
        return editObject.getLengthClassesPmfmId();
    }

    @Override
    public void setLengthClassesPmfmId(List<String> lengthClassesPmfmId) {
        editObject.setLengthClassesPmfmId(lengthClassesPmfmId);
        // force to always propagates (need to recompte data of combobox in species table)
        firePropertyChange(PROPERTY_LENGTH_CLASSES_PMFM_ID, null, lengthClassesPmfmId);
    }

    @Override
    public List<String> getGearUseFeaturePmfmId() {
        return editObject.getGearUseFeaturePmfmId();
    }

    @Override
    public void setGearUseFeaturePmfmId(List<String> gearUseFeaturePmfmId) {
        editObject.setGearUseFeaturePmfmId(gearUseFeaturePmfmId);
        firePropertyChange(PROPERTY_GEAR_USE_FEATURE_PMFM_ID, null, gearUseFeaturePmfmId);
    }

    @Override
    public List<String> getVesselUseFeaturePmfmId() {
        return editObject.getVesselUseFeaturePmfmId();
    }

    @Override
    public void setVesselUseFeaturePmfmId(List<String> vesselUseFeaturePmfmId) {
        editObject.setVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
        firePropertyChange(PROPERTY_VESSEL_USE_FEATURE_PMFM_ID, null, vesselUseFeaturePmfmId);
    }

    @Override
    public List<String> getIndividualObservationPmfmId() {
        return editObject.getIndividualObservationPmfmId();
    }

    @Override
    public void setIndividualObservationPmfmId(List<String> individualObservationPmfmId) {
        editObject.setIndividualObservationPmfmId(individualObservationPmfmId);
        firePropertyChange(PROPERTY_INDIVIDUAL_OBSERVATION_PMFM_ID, null, individualObservationPmfmId);
    }

    @Override
    public String getGearUseFeaturePmfmId(int index) {
        return editObject.getGearUseFeaturePmfmId(index);
    }

    @Override
    public boolean isGearUseFeaturePmfmIdEmpty() {
        return editObject.isGearUseFeaturePmfmIdEmpty();
    }

    @Override
    public int sizeGearUseFeaturePmfmId() {
        return editObject.sizeGearUseFeaturePmfmId();
    }

    @Override
    public void addGearUseFeaturePmfmId(String gearUseFeaturePmfmId) {
        editObject.addGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public void addAllGearUseFeaturePmfmId(Collection<String> gearUseFeaturePmfmId) {
        editObject.addAllGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public boolean removeGearUseFeaturePmfmId(String gearUseFeaturePmfmId) {
        return editObject.removeGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public boolean removeAllGearUseFeaturePmfmId(Collection<String> gearUseFeaturePmfmId) {
        return editObject.removeAllGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public boolean containsGearUseFeaturePmfmId(String gearUseFeaturePmfmId) {
        return editObject.containsGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public boolean containsAllGearUseFeaturePmfmId(Collection<String> gearUseFeaturePmfmId) {
        return editObject.containsAllGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public String getVesselUseFeaturePmfmId(int index) {
        return editObject.getVesselUseFeaturePmfmId(index);
    }

    @Override
    public boolean isVesselUseFeaturePmfmIdEmpty() {
        return editObject.isVesselUseFeaturePmfmIdEmpty();
    }

    @Override
    public int sizeVesselUseFeaturePmfmId() {
        return editObject.sizeVesselUseFeaturePmfmId();
    }

    @Override
    public void addVesselUseFeaturePmfmId(String vesselUseFeaturePmfmId) {
        editObject.addVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public void addAllVesselUseFeaturePmfmId(Collection<String> vesselUseFeaturePmfmId) {
        editObject.addAllVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public boolean removeVesselUseFeaturePmfmId(String vesselUseFeaturePmfmId) {
        return editObject.removeVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public boolean removeAllVesselUseFeaturePmfmId(Collection<String> vesselUseFeaturePmfmId) {
        return editObject.removeAllVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public boolean containsVesselUseFeaturePmfmId(String vesselUseFeaturePmfmId) {
        return editObject.containsVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public boolean containsAllVesselUseFeaturePmfmId(Collection<String> vesselUseFeaturePmfmId) {
        return editObject.containsAllVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public String getIndividualObservationPmfmId(int index) {
        return editObject.getIndividualObservationPmfmId(index);
    }

    @Override
    public boolean isIndividualObservationPmfmIdEmpty() {
        return editObject.isIndividualObservationPmfmIdEmpty();
    }

    @Override
    public int sizeIndividualObservationPmfmId() {
        return editObject.sizeIndividualObservationPmfmId();
    }

    @Override
    public void addIndividualObservationPmfmId(String individualObservationPmfmId) {
        editObject.addIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public void addAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        editObject.addAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean removeIndividualObservationPmfmId(String individualObservationPmfmId) {
        return editObject.removeIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean removeAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        return editObject.removeAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean containsIndividualObservationPmfmId(String individualObservationPmfmId) {
        return editObject.containsIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean containsAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        return editObject.containsAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public String getLengthClassesPmfmId(int index) {
        return editObject.getLengthClassesPmfmId(index);
    }

    @Override
    public boolean isLengthClassesPmfmIdEmpty() {
        return editObject.isLengthClassesPmfmIdEmpty();
    }

    @Override
    public int sizeLengthClassesPmfmId() {
        return editObject.sizeLengthClassesPmfmId();
    }

    @Override
    public void addLengthClassesPmfmId(String lengthClassesPmfmId) {
        editObject.addLengthClassesPmfmId(lengthClassesPmfmId);
        // force to always propagates (need to recompte data of combobox in species table)
        firePropertyChange(PROPERTY_LENGTH_CLASSES_PMFM_ID, null, getLengthClassesPmfmId());
    }

    @Override
    public void addAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        editObject.addAllLengthClassesPmfmId(lengthClassesPmfmId);
        // force to always propagates (need to recompte data of combobox in species table)
        firePropertyChange(PROPERTY_LENGTH_CLASSES_PMFM_ID, null, getLengthClassesPmfmId());
    }

    @Override
    public boolean removeLengthClassesPmfmId(String lengthClassesPmfmId) {
        boolean result = editObject.removeLengthClassesPmfmId(lengthClassesPmfmId);
        // force to always propagates (need to recompte data of combobox in species table)
        firePropertyChange(PROPERTY_LENGTH_CLASSES_PMFM_ID, null, getLengthClassesPmfmId());
        return result;
    }

    @Override
    public boolean removeAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        boolean result = editObject.removeAllLengthClassesPmfmId(lengthClassesPmfmId);
        // force to always propagates (need to recompte data of combobox in species table)
        firePropertyChange(PROPERTY_LENGTH_CLASSES_PMFM_ID, null, getLengthClassesPmfmId());
        return result;
    }

    @Override
    public boolean containsLengthClassesPmfmId(String lengthClassesPmfmId) {
        return editObject.containsLengthClassesPmfmId(lengthClassesPmfmId);
    }

    @Override
    public boolean containsAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        return editObject.containsAllLengthClassesPmfmId(lengthClassesPmfmId);
    }

    @Override
    public SpeciesProtocol getSpecies(int index) {
        return editObject.getSpecies(index);
    }

    @Override
    public boolean isSpeciesEmpty() {
        return editObject.isSpeciesEmpty();
    }

    @Override
    public int sizeSpecies() {
        return editObject.sizeSpecies();
    }

    @Override
    public void addSpecies(SpeciesProtocol species) {
        editObject.addSpecies(species);
    }

    @Override
    public void addAllSpecies(Collection<SpeciesProtocol> species) {
        editObject.addAllSpecies(species);
    }

    @Override
    public boolean removeSpecies(SpeciesProtocol species) {
        return editObject.removeSpecies(species);
    }

    @Override
    public boolean removeAllSpecies(Collection<SpeciesProtocol> species) {
        return editObject.removeAllSpecies(species);
    }

    @Override
    public boolean containsSpecies(SpeciesProtocol species) {
        return editObject.containsSpecies(species);
    }

    @Override
    public boolean containsAllSpecies(Collection<SpeciesProtocol> species) {
        return editObject.containsAllSpecies(species);
    }

    @Override
    public List<SpeciesProtocol> getSpecies() {
        return editObject.getSpecies();
    }

    @Override
    public void setSpecies(List<SpeciesProtocol> species) {
        editObject.setSpecies(species);
    }

    @Override
    public SpeciesProtocol getBenthos(int index) {
        return editObject.getBenthos(index);
    }

    @Override
    public boolean isBenthosEmpty() {
        return editObject.isBenthosEmpty();
    }

    @Override
    public int sizeBenthos() {
        return editObject.sizeBenthos();
    }

    @Override
    public void addBenthos(SpeciesProtocol benthos) {
        editObject.addBenthos(benthos);
    }

    @Override
    public void addAllBenthos(Collection<SpeciesProtocol> benthos) {
        editObject.addAllBenthos(benthos);
    }

    @Override
    public boolean removeBenthos(SpeciesProtocol benthos) {
        return editObject.removeBenthos(benthos);
    }

    @Override
    public boolean removeAllBenthos(Collection<SpeciesProtocol> benthos) {
        return editObject.removeAllBenthos(benthos);
    }

    @Override
    public boolean containsBenthos(SpeciesProtocol benthos) {
        return editObject.containsBenthos(benthos);
    }

    @Override
    public boolean containsAllBenthos(Collection<SpeciesProtocol> benthos) {
        return editObject.containsAllBenthos(benthos);
    }

    @Override
    public List<SpeciesProtocol> getBenthos() {
        return editObject.getBenthos();
    }

    @Override
    public void setBenthos(List<SpeciesProtocol> benthos) {
        editObject.setBenthos(benthos);
    }

    @Override
    public Integer getVersion() {
        return editObject.getVersion();
    }

    @Override
    public void setVersion(Integer version) {
        editObject.setVersion(version);
    }
}