package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: SpeciesBatchDecorator.java 1301 2013-10-14 18:41:57Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/SpeciesBatchDecorator.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.DecoratorService;
import org.jdesktop.swingx.JXTable;

import static org.nuiton.i18n.I18n._;

/**
 * To decorate some {@link SpeciesAbleBatch} as a {@link Species}.
 * <p/>
 * Used to be able to keep the hole speciesBatch in the cell.
 *
 * @since 2.8
 */
public class SpeciesBatchDecorator<R extends SpeciesAbleBatch> extends DecoratorService.SpeciesFromProtocolDecorator {

    private static final long serialVersionUID = 1L;

    public static <R extends SpeciesAbleBatch> SpeciesBatchDecorator<R> newDecorator(JXTable table) {
        return new SpeciesBatchDecorator<R>(table);
    }

    public SpeciesBatchDecorator(JXTable table) throws IllegalArgumentException, NullPointerException {
        super();

        // use special comparator
        for (Context context : contexts) {
            TuttiDecoratorComparator comparator = (TuttiDecoratorComparator<?>) context.getComparator(0);
            context.setComparator(new SpeciesBatchDecoratorComparator<R>(comparator.getExpression(), table));
        }
    }

    @Override
    public String toString(Object bean) {
        if (bean instanceof SpeciesAbleBatch) {
            bean = ((SpeciesAbleBatch) bean).getSpecies();
        }
        return super.toString(bean);
    }

    @Override
    protected Object getValue(Species bean, String token) {
        Object result = super.getValue(bean, token);
        if (Species.PROPERTY_SURVEY_CODE.equals(token) && result == null) {
            result = bean.getRefTaxCode();
        }
        return result;
    }

    @Override
    protected Object onNullValue(Species bean, String token) {
        Object result;
        if (Species.PROPERTY_SURVEY_CODE.equals(token)) {
            result = _("tutti.propety.no.species.speciesCode");

        } else {
            result = super.onNullValue(bean, token);
        }
        return result;
    }
}
