package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: AbstractTuttiBatchUIModel.java 1160 2013-07-27 21:21:41Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.6/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/AbstractTuttiBatchUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;

/**
 * Abstract model for ui in batch tabs.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public abstract class AbstractTuttiBatchUIModel<R extends AbstractTuttiBeanUIModel, B extends AbstractTuttiBatchUIModel<R, B>> extends AbstractTuttiTableUIModel<FishingOperation, R, B> {

    private static final long serialVersionUID = 1L;

    /**
     * Fishing Operation to prapagate to operations model.
     *
     * @since 0.3
     */
    protected final Set<String> propagateProperties;

    /**
     * Editing fishing operations model.
     *
     * @since 0.3
     */
    protected final EditCatchesUIModel catchesUIModel;

    protected AbstractTuttiBatchUIModel(EditCatchesUIModel catchesUIModel,
                                        String... properties) {
        super(FishingOperation.class, null, null);
        this.catchesUIModel = catchesUIModel;
        propagateProperties = Sets.newHashSet(properties);
        catchesUIModel.addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (propagateProperties.contains(evt.getPropertyName())) {
                    firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            }
        });
    }

    public final FishingOperation getFishingOperation() {
        return catchesUIModel == null ? null : catchesUIModel.getFishingOperation();
    }

    @Override
    protected FishingOperation newEntity() {
        return null;
    }

    public void fireBatchUpdated(R row) {
        if (catchesUIModel != null) {
            catchesUIModel.firePropertyChanged(EditCatchesUIModel.PROPERTY_BATCH_UPDATED, null, row);
        }
    }
}
