package fr.ifremer.tutti.ui.swing.util.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.WeightUnit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class EnterMelagWeightDialog extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_WEIGHT_UNIT = "weightUnit";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1VQW8bRRR+cWMnTkoDjVqlopHcAFWC2nV7q5S2NKSJIHJCFadqhQ/t2Duxp5qdnc7MNttGRfwEfgLcuSBx44Q4cObABfEXEOLAFfFmdr1bx5uuc7Di99735ptvvvf8/V9Q1QquPCNx7KlIGBZQb2fj8eMvus9oz9ynuqeYNKGC5G+qApUOzPtZXBv4oNOy8GYKb26GgQwFFW+g11swp81LTvWAUmNgeRTR07rZztLrsYzUsGtGqqjrt//8XfnG//q7CkAskd0sXqVRhspvMt2CCvMNnMeTXpAmJ6KPNBQTfeT7jo1tcqL1Hgnoc/gKZlpQk0RhMwMrk1/Z9XD4WBqo+YzwsG/gzqHy2KGiAVWeiYxhXsQ8fYSHe5Fh3NOS9hjV3pYwVO1STvqPKOsPzH2Hl9K1rBmYO3Lhh4IhrbWSpo+y2rxB1ZAupwaWRoRLQAc2ZevqWflMQLUmfQSctwrFaeVOi3QptzULWWmN+gyVMHC1oHWS8/aioEvVlvsyip79cOcBEZTfOHmSi46SOtsjokf5p3jlUBhYHKlPorZyKQOce0E484mheXI5rVDw/ghdNKeXmzN3z1QHqirCMErXGffzPqYSJy+dcLJt6LL/XVz8/ac/f9we2ncGz75QWPrG9KGtpAolVYbZoxcS79rXbe4Sud6BuqYcR9eN5uUCYu00jeTwvPcsPDHHZ0QPsEV15o+ff7n49LczUNmGOR4Sf5vY+s+hbgYKVQi5H8tP7jlGZ49m8fNdy806iRnrpI3jJ6srif16iqLI7cTLzsWeK1q51sh966Gb2gM0ivPQ6tra6xhlu1wgW8a9W//138X2D/eG0k3hVS6dWp7LV/0SakxwJqib/XSsC2d9Xmoa+WE+vkUDDdlEy3SiPnKfa2P6VNCWeEf2Cg1K+AZnfRG4VbJwnMyOt7m1d7C1/9rAtKExJjbfKmM6hqVCWjbXnUL2vybkE1zGuIqlkaZtZIpve0i4xretk8iED0IZSctTRRiaxaJt9InJInU0ydE+1TQPLdiQww2H1CWK+KVro4zemUyoq6eKhMZlofCS7YBrgt28JXYFDULBegaak+G8IEPMmzDkB0weuHM/nhBvmCy658jSKrvtND4GFXYd4w/W8nEjXZ/44Luhb9+6ceVOQ0ScN3IDrZbxGy7BMWVuToo8VZtrE3c4RZ0TG7pMH1w/NU5ehlgM524jjjS6TPj4A3B3rPuU/Zwr7WjDbkOMu9TlLmGH/wEwCLQ4QAkAAA==";
    private static final Log log = LogFactory.getLog(EnterMelagWeightDialog.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected EnterMelagWeightDialog dialog = this;
    protected NumberEditor editor;
    protected JLabel message;
    protected Table table;
    protected JButton validateButton;
    protected WeightUnit weightUnit;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EnterMelagWeightDialog(Frame frame, KeyStroke shortcutClosePopup) {
        super(frame, true);
        
            // add a auto-close action
            rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                    shortcutClosePopup, "close");
        
            addWindowListener(new WindowAdapter() {
        
                @Override
                public void windowClosed(WindowEvent e) {
                    Component ui = (Component) e.getSource();
                    JAXXUtil.destroy(ui);
                }
            });
            $initialize();
    }

    public EnterMelagWeightDialog() {
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Frame param0) {
        super(param0);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Window param0) {
        super(param0);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Dialog param0) {
        super(param0);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightDialog(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterMelagWeightDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        editor.setModel(null); dispose();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public NumberEditor getEditor() {
        return editor;
    }

    public JLabel getMessage() {
        return message;
    }

    public Table getTable() {
        return table;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public WeightUnit getWeightUnit() {
        return weightUnit;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setWeightUnit(WeightUnit weightUnit) {
        WeightUnit oldValue = this.weightUnit;
        this.weightUnit = weightUnit;
        firePropertyChange(PROPERTY_WEIGHT_UNIT, oldValue, weightUnit);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(table, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTable() {
        if (!allComponentsCreated) {
            return;
        }
        table.add(message, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        table.add(editor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createSpeciesMelag.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createSpeciesMelag.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new NumberEditor());
        
        editor.setName("editor");
        editor.setUseSign(false);
        editor.setAutoPopup(true);
        editor.setUseFloat(true);
        editor.setShowReset(true);
        editor.setShowPopupButton(true);
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JLabel());
        
        message.setName("message");
    }

    protected void createTable() {
        $objectMap.put("table", table = new Table());
        
        table.setName("table");
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(_("tutti.createSpeciesMelag.action.validate"));
        validateButton.setToolTipText(_("tutti.createSpeciesMelag.action.validate.tip"));
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    protected void createWeightUnit() {
        $objectMap.put("weightUnit", weightUnit = WeightUnit.KG);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDialog();
        addChildrenToTable();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        setTitle(_("tutti.createSpeciesMelag.title", weightUnit.getShortLabel()));
        message.setHorizontalAlignment(JLabel.CENTER);
        message.setText(_("tutti.createSpeciesMelag.message", weightUnit.getShortLabel()));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createSpeciesMelag.action.cancel.mnemonic"),'Z'));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createSpeciesMelag.action.validate.mnemonic"),'Z'));
        // late initializer
        dialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("dialog", dialog);
        createWeightUnit();
        createTable();
        createMessage();
        createEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createValidateButton();
        // inline creation of dialog
        setName("dialog");
        dialog.getContentPane().setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editor != null) {
                    editor.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editor != null) {
                    validateButton.setEnabled( editor.getModel() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editor != null) {
                    editor.removePropertyChangeListener("model", this);
                }
            }
        });
    }

}