package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.WeightUnit;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnRowModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.4
 */
public class IndividualObservationBatchRowModel extends AbstractTuttiBeanUIModel<IndividualObservationBatch, IndividualObservationBatchRowModel>
        implements AttachmentModelAware, IndividualObservationBatch, CaracteristicMapColumnRowModel {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_DEFAULT_CARACTERISTICS = "defaultCaracteristics";

    /**
     * Delegate edit object.
     *
     * @since 1.3
     */
    protected final IndividualObservationBatch editObject =
            TuttiBeanFactory.newIndividualObservationBatch();

    /**
     * Attachments (should never be null).
     *
     * @since 0.2
     */
    protected final List<Attachment> attachment = Lists.newArrayList();

    /**
     * Map of default caracteristics (used if filled in the protocol.
     *
     * @since 2.5
     */
    protected CaracteristicMap defaultCaracteristics = new CaracteristicMap();

    /**
     * Weight unit.
     *
     * @since 2.5
     */
    protected final WeightUnit weightUnit;

    protected static final Binder<IndividualObservationBatch, IndividualObservationBatchRowModel> fromBeanBinder =
            BinderFactory.newBinder(IndividualObservationBatch.class,
                                    IndividualObservationBatchRowModel.class);

    protected static final Binder<IndividualObservationBatchRowModel, IndividualObservationBatch> toBeanBinder =
            BinderFactory.newBinder(IndividualObservationBatchRowModel.class,
                                    IndividualObservationBatch.class);

    public IndividualObservationBatchRowModel(WeightUnit weightUnit) {
        super(IndividualObservationBatch.class, fromBeanBinder, toBeanBinder);
        this.weightUnit = weightUnit;
        if (getCaracteristics() == null) {
            setCaracteristics(new CaracteristicMap());
        }
    }

    public IndividualObservationBatchRowModel(WeightUnit weightUnit,
                                              IndividualObservationBatch entity,
                                              Collection<Caracteristic> defaultCaracteristicsSet) {
        this(weightUnit);

        fromEntity(entity);

        // move default caracteristics from caracteristic map
        CaracteristicMap caracteristics = getCaracteristics();
        for (Caracteristic caracteristic : defaultCaracteristicsSet) {
            if (caracteristics.containsKey(caracteristic)) {
                Serializable value = caracteristics.remove(caracteristic);
                defaultCaracteristics.put(caracteristic, value);
            }
        }
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public CaracteristicMap getDefaultCaracteristics() {
        return defaultCaracteristics;
    }

    public void setDefaultCaracteristics(CaracteristicMap defaultCaracteristics) {
        this.defaultCaracteristics = defaultCaracteristics;
        firePropertyChange(PROPERTY_DEFAULT_CARACTERISTICS, null, defaultCaracteristics);
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiBeanUIModel                                           --//
    //------------------------------------------------------------------------//

    @Override
    public void fromEntity(IndividualObservationBatch entity) {
        super.fromEntity(entity);

        // convert weight
        setWeight(weightUnit.fromEntity(getWeight()));

        if (getCaracteristics() == null) {
            setCaracteristics(new CaracteristicMap());
        }
    }

    @Override
    public IndividualObservationBatch toEntity() {
        IndividualObservationBatch result = super.toEntity();

        // convert weight
        result.setWeight(weightUnit.toEntity(getWeight()));
        return result;
    }

    @Override
    protected IndividualObservationBatch newEntity() {
        return TuttiBeanFactory.newIndividualObservationBatch();
    }

    //------------------------------------------------------------------------//
    //-- IndividualObservationBatch                                         --//
    //------------------------------------------------------------------------//

    @Override
    public FishingOperation getFishingOperation() {
        return editObject.getFishingOperation();
    }

    @Override
    public void setFishingOperation(FishingOperation fishingOperation) {
        editObject.setFishingOperation(fishingOperation);
    }

    @Override
    public Float getWeight() {
        return editObject.getWeight();
    }

    @Override
    public void setWeight(Float weight) {
        Object oldValue = getWeight();
        editObject.setWeight(weight);
        firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    @Override
    public Species getSpecies() {
        return editObject.getSpecies();
    }

    @Override
    public void setSpecies(Species species) {
        Object oldValue = getSpecies();
        editObject.setSpecies(species);
        firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    @Override
    public Float getSize() {
        return editObject.getSize();
    }

    @Override
    public void setSize(Float size) {
        Object oldValue = getSize();
        editObject.setSize(size);
        firePropertyChange(PROPERTY_SIZE, oldValue, size);
    }

    @Override
    public Caracteristic getLengthStepCaracteristic() {
        return editObject.getLengthStepCaracteristic();
    }

    @Override
    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Object oldValue = getLengthStepCaracteristic();
        editObject.setLengthStepCaracteristic(lengthStepCaracteristic);
        firePropertyChange(PROPERTY_LENGTH_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
    }

    @Override
    public CaracteristicMap getCaracteristics() {
        return editObject.getCaracteristics();
    }

    @Override
    public void setCaracteristics(CaracteristicMap caracteristics) {
        Object oldValue = getCaracteristics();
        editObject.setCaracteristics(caracteristics);
        firePropertyChange(PROPERTY_CARACTERISTICS, oldValue, caracteristics);
    }

//    @Override
//    public String getSamplingCode() {
//        return editObject.getSamplingCode();
//    }
//
//    @Override
//    public void setSamplingCode(String samplingCode) {
//        Object oldValue = getSamplingCode();
//        editObject.setSamplingCode(samplingCode);
//        firePropertyChange(PROPERTY_SAMPLING_CODE, oldValue, samplingCode);
//    }
//
//    @Override
//    public String getCalcifiedPieceSamplingCode() {
//        return editObject.getCalcifiedPieceSamplingCode();
//    }
//
//    @Override
//    public void setCalcifiedPieceSamplingCode(String calcifiedPieceSamplingCode) {
//        Object oldValue = getCalcifiedPieceSamplingCode();
//        editObject.setCalcifiedPieceSamplingCode(calcifiedPieceSamplingCode);
//        firePropertyChange(PROPERTY_CALCIFIED_PIECE_SAMPLING_CODE, oldValue, calcifiedPieceSamplingCode);
//    }

    @Override
    public String getComment() {
        return editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        Object oldValue = getComment();
        editObject.setComment(comment);
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public Integer getRankOrder() {
        return editObject.getRankOrder();
    }

    @Override
    public void setRankOrder(Integer rankOrder) {
        editObject.setRankOrder(rankOrder);
    }

    //------------------------------------------------------------------------//
    //-- AttachmentModelAware                                               --//
    //------------------------------------------------------------------------//

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.SAMPLE;
    }

    @Override
    public Integer getObjectId() {
        return getIdAsInt();
    }

    @Override
    public List<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }
}
