/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.ArrayList;
import java.util.Collections;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveSpeciesProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    public RemoveSpeciesProtocolAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected void doAction() throws Exception {
        JXTable table = ((EditProtocolUIHandler)this.handler).getSpeciesTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove species if no species selected");
        EditProtocolSpeciesTableModel tableModel = ((EditProtocolUIHandler)this.handler).getSpeciesTableModel();
        EditProtocolSpeciesRowModel selectedRow = (EditProtocolSpeciesRowModel)tableModel.getEntry(rowIndex);
        Species species = selectedRow.getSpecies();
        ((EditProtocolUI)this.getUI()).getBenthosComboBox().addItem((Object)species);
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().addItem((Object)species);
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        Integer taxonId = species.getReferenceTaxonId();
        ArrayList allSynonyms = Lists.newArrayList(model.getAllSynonyms(String.valueOf(taxonId)));
        allSynonyms.remove(species);
        model.getAllSynonyms().addAll(allSynonyms);
        Collections.sort(model.getAllSynonyms(), TuttiEntities.SPECIES_BY_NAME_COMPARATOR);
        table.clearSelection();
        tableModel.removeRow(rowIndex);
        String speciesStr = this.decorate(selectedRow.getSpecies());
        this.sendMessage(I18n._((String)"tutti.flash.info.species.remove.from.protocol", (Object[])new Object[]{speciesStr}));
    }
}

