/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.db.DbManagerUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jaxx.runtime.validator.swing.SwingValidator;
import org.nuiton.i18n.I18n;

public class DbManagerUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, DbManagerUI> {
    public DbManagerUIHandler(TuttiUIContext context, DbManagerUI ui) {
        super(context, ui);
    }

    @Override
    public void beforeInitUI() {
    }

    public String updateMessage(boolean dbExist, boolean dbLoaded) {
        String message;
        if (dbExist) {
            String jdbcUrl = this.getConfig().getServiceConfig().getPersistenceConfig().getJdbcUrl();
            message = dbLoaded ? I18n._((String)"tutti.dbManager.info.db.loaded", (Object[])new Object[]{jdbcUrl}) : I18n._((String)"tutti.dbManager.info.no.db.loaded", (Object[])new Object[]{jdbcUrl});
        } else {
            message = I18n._((String)"tutti.dbManager.info.no.db.exist", (Object[])new Object[0]);
        }
        return "<html><body>" + message + "</body></html>";
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        ((DbManagerUI)this.ui).applyDataBinding("upgradeDbButton.enabled");
        ((DbManagerUI)this.ui).applyDataBinding("exportDbButton.enabled");
        ((DbManagerUI)this.ui).applyDataBinding("exportAndCleanDbButton.enabled");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DbManagerUIHandler.this.getContext().getMainUI().getBody().repaint();
            }
        });
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((DbManagerUI)this.getUI()).getUpgradeDbButton();
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }
}

