/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.batch.BatchPersistenceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service(value="speciesBatchPersistenceService")
public class SpeciesBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements SpeciesBatchPersistenceService {
    private static final Log log = LogFactory.getLog(SpeciesBatchPersistenceServiceImpl.class);
    @Autowired
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;

    @Override
    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(String fishingOperationId) {
        SpeciesBatch target;
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(Integer.valueOf(fishingOperationId));
        Preconditions.checkNotNull((Object)catchBatchId);
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        Preconditions.checkNotNull((Object)catchBatch);
        Collection catchBatchChilds = catchBatch.getChildBatchs();
        SortingBatch vracSpeciesBatch = this.catchBatchDao.getSortingBatch(catchBatchChilds, new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, "pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES, "pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED});
        BatchContainer<SpeciesBatch> result = new BatchContainer<SpeciesBatch>();
        result.setId(vracSpeciesBatch.getId());
        for (Batch batch1 : vracSpeciesBatch.getChildBatchs()) {
            SortingBatch source = (SortingBatch)batch1;
            target = TuttiBeanFactory.newSpeciesBatch();
            this.batchHelper.entityToSpeciesBatch(source, target);
            result.addChildren(target);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Loaded CatchBatch Vrac > Species > " + target.getSpecies().getReferenceTaxonId() + " : " + target.getId()));
        }
        SortingBatch horsVracSpeciesBatch = this.catchBatchDao.getSortingBatch(catchBatchChilds, new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, "pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
        if (horsVracSpeciesBatch != null) {
            for (Batch batch : horsVracSpeciesBatch.getChildBatchs()) {
                target = TuttiBeanFactory.newSpeciesBatch();
                this.batchHelper.entityToSpeciesBatch((SortingBatch)batch, target);
                result.addChildren(target);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Loaded CatchBatch Hors Vrac > Species > " + target.getSpecies().getReferenceTaxonId() + " : " + target.getId()));
            }
        }
        return result;
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSpecies().getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(bean.getFishingOperation().getIdAsInt());
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        SortingBatch batch = SortingBatch.Factory.newInstance();
        this.speciesBatchToEntity(bean, batch, parentBatchId, catchBatch);
        batch = this.catchBatchDao.createSortingBatch(batch, catchBatch);
        bean.setId(batch.getId());
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(bean.getIdAsInt());
        Preconditions.checkNotNull((Object)catchBatchId);
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        Preconditions.checkNotNull((Object)catchBatch);
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        SortingBatch batch = this.catchBatchDao.getSortingBatchById(catchBatch, bean.getIdAsInt());
        String parentBatchId = null;
        if (bean.getParentBatch() != null) {
            parentBatchId = bean.getParentBatch().getId();
        }
        this.speciesBatchToEntity(bean, batch, parentBatchId, catchBatch);
        this.catchBatchDao.updateSortingBatch(batch, catchBatch);
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public void deleteSpeciesBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        Integer batchId = Integer.valueOf(id);
        this.catchBatchDao.removeWithChildren(batchId);
        this.attachmentPersistenceService.deleteAllAttachment(batchId);
        this.getCurrentSession().flush();
    }

    @Override
    public void deleteSpeciesSubBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        Integer speciesBatchId = Integer.valueOf(id);
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(speciesBatchId);
        Preconditions.checkNotNull((Object)catchBatchId, (Object)("Could not find catchBatch for speciesBatch: " + speciesBatchId));
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        SortingBatch sortingBatch = this.catchBatchDao.getSortingBatchById(catchBatch, speciesBatchId);
        Collection childBatchs = sortingBatch.getChildBatchs();
        if (CollectionUtils.isNotEmpty((Collection)childBatchs)) {
            for (Batch childBatch : childBatchs) {
                Integer childBatchId = childBatch.getId();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Delete child [" + childBatchId + "] of species batch: " + id));
                }
                this.catchBatchDao.removeWithChildren(childBatchId);
                this.attachmentPersistenceService.deleteAllAttachment(childBatchId);
            }
        }
        this.getCurrentSession().flush();
    }

    @Override
    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        Preconditions.checkNotNull((Object)batchId);
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkNotNull((Object)species.getReferenceTaxonId());
        this.catchBatchDao.setSortingBatchReferenceTaxon(batchId, species.getReferenceTaxonId());
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        Preconditions.checkNotNull((Object)speciesBatchId);
        ArrayList results = Lists.newArrayList();
        Integer sortingBatchId = Integer.valueOf(speciesBatchId);
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(sortingBatchId);
        Preconditions.checkNotNull((Object)catchBatchId, (Object)("Could not find catchBatch for speciesBatch: " + speciesBatchId));
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        SortingBatch sortingBatch = this.catchBatchDao.getSortingBatchById(catchBatch, sortingBatchId);
        List<SortingBatch> frequencyChilds = this.batchHelper.getFrequencyChilds(sortingBatch);
        for (SortingBatch child : frequencyChilds) {
            SpeciesBatchFrequency target = TuttiBeanFactory.newSpeciesBatchFrequency();
            this.batchHelper.entityToSpeciesBatchFrequency(child, target);
            results.add(target);
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        Preconditions.checkNotNull((Object)speciesBatchId);
        Preconditions.checkNotNull(frequencies);
        ArrayList notNullFrequencies = Lists.newArrayList();
        String pmfmId = null;
        for (SpeciesBatchFrequency source : frequencies) {
            if (source.getLengthStepCaracteristic() == null) continue;
            if (pmfmId == null) {
                pmfmId = source.getLengthStepCaracteristic().getId();
            } else if (!pmfmId.equals(source.getLengthStepCaracteristic().getId())) {
                throw new DataIntegrityViolationException("Batch frequencies under one SpeciesBatch must have all the same lengthStepCaracteristic");
            }
            notNullFrequencies.add(source);
        }
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        Integer sortingBatchId = Integer.valueOf(speciesBatchId);
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(sortingBatchId);
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        if (catchBatch == null) {
            return notNullFrequencies;
        }
        SortingBatch parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, sortingBatchId);
        ArrayList notUpdatedChildIds = Lists.newArrayList();
        List<SortingBatch> frequencyChilds = this.batchHelper.getFrequencyChilds(parentBatch);
        for (SortingBatch child : frequencyChilds) {
            notUpdatedChildIds.add(child.getId());
        }
        short rankOrder = 0;
        ArrayList batchsToUpdate = Lists.newArrayList();
        for (SpeciesBatchFrequency source : notNullFrequencies) {
            SortingBatch target;
            rankOrder = (short)(rankOrder + 1);
            if (source.getId() == null) {
                target = SortingBatch.Factory.newInstance();
                this.batchHelper.speciesBatchFrequencyToEntity(source, target, parentBatch, rankOrder);
                this.catchBatchDao.createSortingBatch(target, catchBatch);
                source.setId(target.getId());
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Create frequency sortingBatch(" + rankOrder + "): " + target.getId()));
                continue;
            }
            target = this.catchBatchDao.loadSortingBatch(source.getIdAsInt(), catchBatch);
            this.batchHelper.speciesBatchFrequencyToEntity(source, target, parentBatch, rankOrder);
            batchsToUpdate.add(target);
            notUpdatedChildIds.remove(target.getId());
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Update frequency sortingBatch(" + rankOrder + "): " + target.getId()));
        }
        if (batchsToUpdate.size() > 0) {
            this.catchBatchDao.updateSortingBatch((List)batchsToUpdate, catchBatch);
        }
        if (notUpdatedChildIds.size() > 0) {
            for (Integer batchId : notUpdatedChildIds) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Remove obsolete frequency sortingBatch: " + batchId));
                }
                this.catchBatchDao.removeWithChildren(batchId, catchBatch);
            }
        }
        this.getCurrentSession().flush();
        return Collections.unmodifiableList(notNullFrequencies);
    }

    protected void speciesBatchToEntity(SpeciesBatch source, SortingBatch target, String parentBatchId, CatchBatch catchBatch) {
        this.batchHelper.speciesBatchToEntity(source, target, parentBatchId, catchBatch, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
    }
}

