/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.session;

import javax.swing.JTable;
import javax.swing.table.TableColumn;
import jaxx.runtime.swing.session.State;

public class JTableState
implements State {
    protected int[] columnWidths = new int[0];

    public JTableState() {
    }

    public JTableState(int[] columnWidths) {
        this.columnWidths = columnWidths;
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public void setColumnWidths(int[] columnWidths) {
        this.columnWidths = columnWidths;
    }

    protected JTable checkComponent(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(o instanceof JTable)) {
            throw new IllegalArgumentException("invalid component");
        }
        return (JTable)o;
    }

    @Override
    public State getState(Object o) {
        JTable table = this.checkComponent(o);
        int[] columnWidths = new int[table.getColumnCount()];
        boolean resizableColumnExists = false;
        for (int i = 0; i < columnWidths.length; ++i) {
            TableColumn tc = table.getColumnModel().getColumn(i);
            int n = columnWidths[i] = tc.getResizable() ? tc.getWidth() : -1;
            if (!tc.getResizable()) continue;
            resizableColumnExists = true;
        }
        JTableState result = null;
        if (resizableColumnExists) {
            result = new JTableState();
            result.setColumnWidths(columnWidths);
        }
        return result;
    }

    @Override
    public void setState(Object o, State state) {
        if (!(state instanceof JTableState)) {
            throw new IllegalArgumentException("invalid state");
        }
        JTable table = this.checkComponent(o);
        int[] columnWidths = ((JTableState)state).getColumnWidths();
        if (columnWidths != null && table.getColumnCount() == columnWidths.length) {
            for (int i = 0; i < columnWidths.length; ++i) {
                TableColumn tc;
                if (columnWidths[i] == -1 || !(tc = table.getColumnModel().getColumn(i)).getResizable()) continue;
                tc.setPreferredWidth(columnWidths[i]);
            }
        }
    }
}

