/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.ui.swing.util.RemoveablePropertyChangeListener;
import fr.ifremer.tutti.ui.swing.util.TuttiColorHighlighter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jaxx.runtime.FileChooserUtil;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.i18n.I18n;

public final class TuttiUIUtil {
    private static final Log log = LogFactory.getLog(TuttiUIUtil.class);
    private static DecimalFormatSymbols symbols;
    private static DecimalFormat decimalFormat;

    private TuttiUIUtil() {
    }

    public static File chooseFile(Component parent, String title, String buttonLabel, String ... filters) {
        File file = FileChooserUtil.getFile((String)title, (String)buttonLabel, (Component)parent, (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        if (file != null) {
            File newDir = file.isDirectory() ? file : file.getParentFile();
            FileChooserUtil.setCurrentDirectory((File)newDir);
        }
        return file;
    }

    public static File saveFile(String filename, Component parent, String title, String buttonLabel, String ... filters) {
        File file = FileChooserUtil.saveFile((String)filename, (String)title, (String)buttonLabel, (Component)parent, (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        if (file != null) {
            Preconditions.checkState((!file.isDirectory() ? 1 : 0) != 0);
            FileChooserUtil.setCurrentDirectory((File)file.getParentFile());
        }
        return file;
    }

    public static File chooseDirectory(Component parent, String title, String buttonLabel) {
        String file = FileChooserUtil.getDirectory((Component)parent, (String)title, (String)buttonLabel);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        if (file != null) {
            File newDir = new File(file);
            if (!newDir.isDirectory()) {
                newDir = newDir.getParentFile();
            }
            FileChooserUtil.setCurrentDirectory((File)newDir);
        }
        return file == null ? null : new File(file);
    }

    public static void showSuccessMessage(Component ui, String title, String message) {
        JOptionPane.showMessageDialog(ui, message, title, 1, UIManager.getIcon("info"));
    }

    public static void setProperty(Object bean, String property, Object value) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            PropertyUtils.setSimpleProperty((Object)bean, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not set property '" + property + "' on object of type '" + bean.getClass().getName() + "'", e);
        }
    }

    public static Object getProperty(Object bean, String property) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            return PropertyUtils.getSimpleProperty((Object)bean, (String)property);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not get property '" + property + "' on object of type '" + bean.getClass().getName() + "'", e);
        }
    }

    public static Highlighter newBackgroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new TuttiColorHighlighter(predicate, color, false);
    }

    public static Highlighter newForegroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new TuttiColorHighlighter(predicate, color, true);
    }

    public static int computeDistanceInMeters(Float startLatitude, Float startLongitude, Float endLatitude, Float endLongitude) {
        double sLat = (double)startLatitude.floatValue() * Math.PI / 180.0;
        double sLong = (double)startLongitude.floatValue() * Math.PI / 180.0;
        double eLat = (double)endLatitude.floatValue() * Math.PI / 180.0;
        double eLong = (double)endLongitude.floatValue() * Math.PI / 180.0;
        Double d = 6378288.0 * (1.5707963267948966 - Math.asin(Math.sin(eLat) * Math.sin(sLat) + Math.cos(eLong - sLong) * Math.cos(eLat) * Math.cos(sLat)));
        return d.intValue();
    }

    public static String getDistanceInMilles(Float distance) {
        String distanceText;
        if (distance != null) {
            Float distanceInMilles = Float.valueOf(distance.floatValue() / 1852.0f);
            distanceText = String.format("%.3f", distanceInMilles);
        } else {
            distanceText = "";
        }
        return distanceText;
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        if (symbols == null) {
            symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(' ');
        }
        return symbols;
    }

    public static DecimalFormat getDecimalFormat(int minDecimal, int maxDecimal) {
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(TuttiUIUtil.getDecimalFormatSymbols());
            decimalFormat.setGroupingUsed(false);
        }
        decimalFormat.setMinimumFractionDigits(minDecimal);
        decimalFormat.setMaximumFractionDigits(maxDecimal);
        return decimalFormat;
    }

    public static String getWeightStringValue(Float weight) {
        String textValue;
        if (weight != null) {
            DecimalFormat weightDecimalFormat = TuttiUIUtil.getDecimalFormat(1, 3);
            textValue = weightDecimalFormat.format(weight);
        } else {
            textValue = "";
        }
        return textValue;
    }

    public static void openLink(URL url) {
        try {
            TuttiUIUtil.openLink(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new TuttiTechnicalException("Could not open link: " + url, e);
        }
    }

    public static void openLink(URI uri) {
        try {
            if (!Desktop.isDesktopSupported()) {
                throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.not.supported", (Object[])new Object[0]));
            }
            Desktop desktop = Desktop.getDesktop();
            if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.browse.not.supported", (Object[])new Object[0]));
            }
            desktop.browse(uri);
            throw new RuntimeException(I18n._((String)"swing.error.cannot.open.link", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.cannot.open.link", (Object[])new Object[0]), e);
        }
    }

    public static void editLink(File uri) {
        try {
            if (!Desktop.isDesktopSupported()) {
                throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.not.supported", (Object[])new Object[0]));
            }
            Desktop desktop = Desktop.getDesktop();
            if (!desktop.isSupported(Desktop.Action.EDIT)) {
                throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.browse.not.supported", (Object[])new Object[0]));
            }
            desktop.edit(uri);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not open link: " + uri, e);
        }
    }

    public static void closeBean(AbstractBean bean) {
        PropertyChangeListener[] propertyChangeListeners;
        for (PropertyChangeListener listener : propertyChangeListeners = bean.getPropertyChangeListeners()) {
            if (listener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
                listener = (PropertyChangeListener)proxy.getListener();
            }
            if (!(listener instanceof RemoveablePropertyChangeListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            bean.removePropertyChangeListener(listener);
        }
    }

    public static void closeUI(JAXXObject ui) {
        JAXXBinding[] bindings;
        for (JAXXBinding binding : bindings = ui.getDataBindings()) {
            SwingUtil.removeDataBinding((JAXXObject)ui, (String[])new String[]{binding.getId()});
        }
    }
}

