package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create;

/*
 * #%L
 * Tutti :: UI
 * $Id: CreateBenthosBatchUIHandler.java 678 2013-03-25 17:44:48Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/create/CreateBenthosBatchUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.SortedUnsortedEnum;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

/**
 * Handler of {@link CreateBenthosBatchUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class CreateBenthosBatchUIHandler extends AbstractTuttiUIHandler<CreateBenthosBatchUIModel, CreateBenthosBatchUI> implements Cancelable {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(CreateBenthosBatchUIHandler.class);

    private final TuttiPersistence persistenceService;

    private final CaracteristicQualitativeValue sortedValue;

    public CreateBenthosBatchUIHandler(TuttiUI parentUi,
                                       CreateBenthosBatchUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        this.persistenceService = context.getPersistenceService();

        Caracteristic caracteristic =
                persistenceService.getSortedUnsortedCaracteristic();
        sortedValue = SortedUnsortedEnum.SORTED.getValue(caracteristic);
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInitUI() {
        CreateBenthosBatchUIModel model = new CreateBenthosBatchUIModel();
        ui.setContextValue(model);
        listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        initBeanFilterableComboBox(ui.getSpeciesComboBox(),
                                   Lists.<Species>newArrayList(),
                                   null,
                                   DecoratorService.FROM_PROTOCOL);

        Caracteristic caracteristic =
                persistenceService.getSortedUnsortedCaracteristic();

        initBeanFilterableComboBox(ui.getSortedUnsortedCategoryComboBox(),
                                   caracteristic.getQualitativeValue(),
                                   null);

        getModel().addPropertyChangeListener(CreateBenthosBatchUIModel.PROPERTY_SPECIES, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {

                CreateBenthosBatchUIModel source =
                        (CreateBenthosBatchUIModel) evt.getSource();
                Species newValue = (Species) evt.getNewValue();

                if (log.isInfoEnabled()) {
                    log.info("New Selected species " + (newValue == null ? null : newValue.getRefTaxCode()));
                }

                if (newValue == null || source.getSpeciesUsed() == null) {

                    source.setSortedUnsortedCategory(null);

                } else {

                    // look for best value : if sorted is available then use it

                    List<CaracteristicQualitativeValue> qualitativeValues =
                            ui.getSortedUnsortedCategoryComboBox().getData();

                    CaracteristicQualitativeValue newCategory = null;

                    for (CaracteristicQualitativeValue qualitativeValue : qualitativeValues) {
                        if (source.isSpeciesAndCategoryAvailable(newValue, qualitativeValue)) {
                            newCategory = qualitativeValue;

                            if (newCategory.equals(sortedValue)) {
                                break;
                            }
                        }
                    }
                    source.setSortedUnsortedCategory(newCategory);
                }
            }
        });

        listenValidatorValid(ui.getValidator(), getModel());
    }

    @Override
    public void onCloseUI() {

        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }

        // evict model from validator
        ui.getValidator().setBean(null);

        // when canceling always invalid model
        getModel().setValid(false);

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        parent.getHandler().setBenthosSelectedCard(EditCatchesUIHandler.MAIN_CARD);

    }

    @Override
    public SwingValidator<CreateBenthosBatchUIModel> getValidator() {
        return ui.getValidator();
    }

    //------------------------------------------------------------------------//
    //-- Cancelable methods                                                 --//
    //------------------------------------------------------------------------//

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info("Cancel UI " + ui);
        }
        closeUI(ui);
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public void openUI(BenthosBatchUIModel batchModel) {

        CreateBenthosBatchUIModel model = getModel();

        // connect model to validator
        ui.getValidator().setBean(model);

        model.setSpecies(null);
        model.setSortedUnsortedCategory(null);
        model.setBatchWeight(null);

        List<Species> speciesToUse = Lists.newArrayList();

        Multimap<CaracteristicQualitativeValue, Species> speciesUsed =
                model.getSpeciesUsed();
        speciesUsed.clear();

        if (batchModel != null) {

            speciesUsed.putAll(batchModel.getSpeciesUsed());

            // compute which species can still be used

            List<Species> allSpecies =
                    getDataContext().getReferentBenthosWithSurveyCode();

            speciesToUse.addAll(allSpecies);
        }

        model.setAvailableSpecies(speciesToUse);
        ui.getSpeciesComboBox().requestFocus();
    }

    public void save() {

        if (log.isInfoEnabled()) {
            log.info("Save UI " + ui);
        }

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        parent.getBenthosTabContent().getHandler().addBatch(getModel());

        // close dialog
        closeUI(ui);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);

        openDialog(dialogContent, title, new Dimension(400, 130));

        Species result = model.getSelectedSpecies();
        return result;
    }

}
