/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.CloseDbAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportAndCleanDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ExportAndCleanDbAction.class);
    protected File file;

    public ExportAndCleanDbAction(MainUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        this.file = null;
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.dbManager.title.choose.dbExportFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.chooseDbExportFile", (Object[])new Object[0]), "^.*\\.zip", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
            if (this.file == null) {
                doAction = false;
            } else {
                this.file = TuttiIOUtil.addExtensionIfMissing((File)this.file, (String)".zip");
                doAction = ((MainUIHandler)this.getHandler()).askOverwriteFile(this.file);
            }
        }
        return doAction;
    }

    @Override
    protected void doAction() {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export db to " + this.file));
        }
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(3);
        progressionModel.setMessage("Fermeture de la base courante");
        ExportAndCleanDbAction.runAction(((MainUIHandler)this.getHandler()).createLogicAction(CloseDbAction.class));
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        progressionModel.increments(1);
        progressionModel.setMessage("Cr\u00e9ation de l'archive " + this.file);
        persistenceService.exportDb(this.file);
        progressionModel.increments(1);
        progressionModel.setMessage("Suppression des fichiers dans Tutti");
        TuttiPersistenceConfig persistenceConfig = this.getConfig().getServiceConfig().getPersistenceConfig();
        File dbDirectory = persistenceConfig.getDbDirectory();
        TuttiIOUtil.cleanDirectory((File)dbDirectory, (String)("Could not delete directory " + dbDirectory));
        File attachmentDirectory = persistenceConfig.getDbAttachmentDirectory();
        TuttiIOUtil.cleanDirectory((File)attachmentDirectory, (String)("Could not delete directory " + attachmentDirectory));
        File protocolDirectory = persistenceConfig.getProtocolDirectory();
        TuttiIOUtil.cleanDirectory((File)protocolDirectory, (String)("Could not delete directory " + protocolDirectory));
        ((TuttiUIContext)this.getModel()).setDbExist(false);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.flash.info.db.exported.and.clean", (Object[])new Object[]{this.file}));
        ((MainUI)this.getUI()).getHandler().changeTitle();
    }
}

