/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiDataContext
implements Closeable {
    private static final Log log = LogFactory.getLog(TuttiDataContext.class);
    protected Program program;
    protected Cruise cruise;
    protected TuttiProtocol protocol;
    protected List<Caracteristic> caracteristics;
    protected List<Person> persons;
    protected List<Species> species;
    protected List<Species> referentSpecies;
    protected List<Vessel> fishingVessels;
    protected List<Vessel> scientificVessels;
    protected List<Gear> fishingGears;
    protected List<Gear> scientificGears;
    protected PersistenceService service;
    protected final TuttiUIContext uiContext;

    public TuttiDataContext(TuttiUIContext uiContext) {
        this.uiContext = uiContext;
        this.uiContext.addPropertyChangeListener("programId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiDataContext.this.program = null;
            }
        });
        this.uiContext.addPropertyChangeListener("cruiseId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiDataContext.this.cruise = null;
            }
        });
        this.uiContext.addPropertyChangeListener("protocolId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiDataContext.this.protocol = null;
                TuttiDataContext.this.resetSpecies();
            }
        });
    }

    public Program getProgram() {
        this.checkOpened();
        if (this.program == null && this.uiContext.isProgramFilled()) {
            String id = this.uiContext.getProgramId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading program: " + id));
            }
            this.program = this.service.getProgram(id);
        }
        return this.program;
    }

    public Cruise getCruise() {
        this.checkOpened();
        if (this.cruise == null && this.uiContext.isCruiseFilled()) {
            String id = this.uiContext.getCruiseId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading cruise: " + id));
            }
            this.cruise = this.service.getCruise(id);
        }
        return this.cruise;
    }

    public TuttiProtocol getProtocol() {
        this.checkOpened();
        if (this.protocol == null && this.uiContext.isProtocolFilled()) {
            String id = this.uiContext.getProtocolId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading cruise: " + id));
            }
            this.protocol = this.service.getProtocol(id);
        }
        return this.protocol;
    }

    public List<Caracteristic> getCaracteristics() {
        if (this.caracteristics == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allCaracteristic");
            }
            this.caracteristics = this.service.getAllCaracteristic();
        }
        return this.caracteristics;
    }

    public List<Species> getSpecies() {
        if (this.species == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allSpecies");
            }
            this.species = this.service.getAllSpecies(this.protocol);
        }
        return this.species;
    }

    public List<Species> getReferentSpecies() {
        if (this.referentSpecies == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allReferentSpecies");
            }
            this.referentSpecies = this.service.getAllReferentSpecies(this.protocol);
        }
        return this.referentSpecies;
    }

    public List<Person> getPersons() {
        this.checkOpened();
        if (this.persons == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allPerson");
            }
            this.persons = this.service.getAllPerson();
        }
        return this.persons;
    }

    public List<Vessel> getFishingVessels() {
        this.checkOpened();
        if (this.fishingVessels == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allfishingVessel");
            }
            this.fishingVessels = this.service.getAllFishingVessel();
        }
        return this.fishingVessels;
    }

    public List<Vessel> getScientificVessels() {
        this.checkOpened();
        if (this.scientificVessels == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allScientificVessel");
            }
            this.scientificVessels = this.service.getAllScientificVessel();
        }
        return this.scientificVessels;
    }

    public List<Gear> getFishingGears() {
        this.checkOpened();
        if (this.fishingGears == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allFishingGear");
            }
            this.fishingGears = this.service.getAllFishingGear();
        }
        return this.fishingGears;
    }

    public List<Gear> getScientificGears() {
        this.checkOpened();
        if (this.scientificGears == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allScientificGear");
            }
            this.scientificGears = this.service.getAllScientificGear();
        }
        return this.scientificGears;
    }

    public void open(PersistenceService persistenceService) {
        this.close();
        this.service = persistenceService;
    }

    @Override
    public void close() {
        this.service = null;
        this.program = null;
        this.cruise = null;
        this.program = null;
        this.resetVessels();
        this.resetGears();
        this.resetPersons();
        this.resetSpecies();
    }

    public void resetGears() {
        this.fishingGears = null;
        this.scientificGears = null;
    }

    public void resetVessels() {
        this.fishingVessels = null;
        this.scientificVessels = null;
    }

    public void resetPersons() {
        this.persons = null;
    }

    public void resetSpecies() {
        this.species = null;
        this.referentSpecies = null;
    }

    public void resetCaracteristics() {
        this.caracteristics = null;
    }

    protected void checkOpened() {
        Preconditions.checkState((this.service != null ? 1 : 0) != 0, (Object)"No persistence service assigned!");
    }
}

