/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import fr.ifremer.tutti.ui.swing.util.table.MoveToNextEditableCellAction;
import fr.ifremer.tutti.ui.swing.util.table.MoveToNextEditableRowAction;
import fr.ifremer.tutti.ui.swing.util.table.MoveToPreviousEditableCellAction;
import fr.ifremer.tutti.ui.swing.util.table.MoveToPreviousEditableRowAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import jaxx.runtime.swing.renderer.DecoratorTableCellRenderer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public abstract class AbstractTuttiTableUIHandler<R extends AbstractTuttiBeanUIModel, M extends AbstractTuttiTableUIModel<?, R, M>, UI extends TuttiUI<M, ?>>
extends AbstractTuttiUIHandler<M, UI> {
    private static final Log log = LogFactory.getLog(AbstractTuttiTableUIHandler.class);
    private final TuttiBeanMonitor<R> rowMonitor;
    protected final PersistenceService persistenceService;
    private ListSelectionListener tableSelectionListener;
    private KeyAdapter keyAdapter;

    public abstract AbstractTuttiTableModel<R> getTableModel();

    public abstract JXTable getTable();

    protected abstract boolean isRowValid(R var1);

    protected void onRowModified(int rowIndex, R row, String propertyName, Object oldValue, Object newValue) {
        ((AbstractTuttiTableUIModel)this.getModel()).setModify(true);
    }

    protected abstract void saveSelectedRowIfRequired(TuttiBeanMonitor<R> var1, R var2);

    protected AbstractTuttiTableUIHandler(TuttiUIContext context, UI ui, String ... properties) {
        super(context, ui);
        this.persistenceService = context.getPersistenceService();
        this.rowMonitor = new TuttiBeanMonitor(properties);
        this.rowMonitor.addPropertyChangeListener("bean", new PropertyChangeListener(){
            final Set<String> propertiesToSkip;
            final PropertyChangeListener l;
            {
                this.propertiesToSkip = Sets.newHashSet((Object[])AbstractTuttiTableUIHandler.this.getRowPropertiesToIgnore());
                this.l = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        String propertyName = evt.getPropertyName();
                        AbstractTuttiBeanUIModel row = (AbstractTuttiBeanUIModel)evt.getSource();
                        Object oldValue = evt.getOldValue();
                        Object newValue = evt.getNewValue();
                        int rowIndex = AbstractTuttiTableUIHandler.this.getTableModel().getRowIndex(row);
                        if ("valid".equals(propertyName)) {
                            AbstractTuttiTableUIHandler.this.onRowValidStateChanged(rowIndex, row, (Boolean)oldValue, (Boolean)newValue);
                        } else if ("modify".equals(propertyName)) {
                            AbstractTuttiTableUIHandler.this.onRowModifyStateChanged(rowIndex, row, (Boolean)oldValue, (Boolean)newValue);
                        } else if (!propertiesToSkip.contains(propertyName)) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)("row [" + rowIndex + "] property " + propertyName + " changed from " + oldValue + " to " + newValue));
                            }
                            AbstractTuttiTableUIHandler.this.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
                        }
                    }
                };
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTuttiBeanUIModel oldValue = (AbstractTuttiBeanUIModel)evt.getOldValue();
                AbstractTuttiBeanUIModel newValue = (AbstractTuttiBeanUIModel)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Monitor row changed from " + oldValue + " to " + newValue));
                }
                if (oldValue != null) {
                    oldValue.removePropertyChangeListener(this.l);
                }
                if (newValue != null) {
                    newValue.addPropertyChangeListener(this.l);
                }
            }
        });
    }

    protected String[] getRowPropertiesToIgnore() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    protected void onModelRowsChanged(List<R> rows) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will set " + (rows == null ? 0 : rows.size()) + " rows on model."));
        }
        if (CollectionUtils.isNotEmpty(rows)) {
            for (AbstractTuttiBeanUIModel row : rows) {
                this.recomputeRowValidState(row);
            }
        }
        this.getTableModel().setRows(rows);
    }

    protected void onRowModifyStateChanged(int rowIndex, R row, Boolean oldValue, Boolean newValue) {
        if (log.isInfoEnabled()) {
            log.info((Object)("row [" + rowIndex + "] modify state changed from " + oldValue + " to " + newValue));
        }
    }

    protected void onRowValidStateChanged(int rowIndex, R row, Boolean oldValue, Boolean newValue) {
        if (log.isInfoEnabled()) {
            log.info((Object)("row [" + rowIndex + "] valid state changed from " + oldValue + " to " + newValue));
        }
        if (rowIndex > -1) {
            this.getTableModel().fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    protected void onAfterSelectedRowChanged(int oldRowIndex, R oldRow, int newRowIndex, R newRow) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected row changed from [" + oldRowIndex + "] to [" + newRowIndex + "]"));
        }
    }

    protected void initTable(JXTable table) {
        table.getTableHeader().setReorderingAllowed(false);
        this.addHighlighters(table);
        ((AbstractTuttiTableUIModel)this.getModel()).addPropertyChangeListener("rows", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTuttiTableUIHandler.this.onModelRowsChanged((List)evt.getNewValue());
            }
        });
        SwingUtil.scrollToTableSelection((JTable)this.getTable());
        this.uninstallTableSaveOnRowChangedSelectionListener();
        this.installTableSaveOnRowChangedSelectionListener();
    }

    protected void addHighlighters(JXTable table) {
        Highlighter readOnlyHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(HighlightPredicate.READ_ONLY, this.getConfig().getColorRowReadOnly());
        table.addHighlighter(readOnlyHighlighter);
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{SpeciesBatchTableModel.COMMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String value = (String)adapter.getValue();
                return StringUtils.isNotBlank((CharSequence)value);
            }
        }}), cellWithValueColor);
        table.addHighlighter(commentHighlighter);
        Highlighter attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{SpeciesBatchTableModel.ATTACHMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Collection attachments = (Collection)adapter.getValue();
                return CollectionUtils.isNotEmpty((Collection)attachments);
            }
        }}), cellWithValueColor);
        table.addHighlighter(attachmentHighlighter);
        Highlighter validHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.EDITABLE, new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                boolean result = false;
                if (adapter.isEditable()) {
                    AbstractTuttiBeanUIModel row = (AbstractTuttiBeanUIModel)AbstractTuttiTableUIHandler.this.getTableModel().getEntry(adapter.row);
                    result = !row.isValid();
                }
                return result;
            }
        }}), this.getConfig().getColorRowInvalid());
        table.addHighlighter(validHighlighter);
    }

    protected void addColumnToModel(TableColumnModel model, TableCellEditor editor, TableCellRenderer renderer, ColumnIdentifier<R> identifier) {
        TableColumnExt col = new TableColumnExt(model.getColumnCount());
        col.setCellEditor(editor);
        col.setCellRenderer(renderer);
        col.setHeaderValue((Object)I18n._((String)identifier.getHeaderI18nKey(), (Object[])new Object[0]));
        col.setToolTipText(I18n._((String)identifier.getHeaderTipI18nKey(), (Object[])new Object[0]));
        col.setIdentifier(identifier);
        model.addColumn((TableColumn)col);
    }

    protected void addColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier) {
        this.addColumnToModel(model, null, null, identifier);
    }

    protected void addFloatColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern) {
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Float.class, (boolean)false);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern(numberPattern);
        this.addColumnToModel(model, (TableCellEditor)editor, null, identifier);
    }

    protected void addIntegerColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern) {
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Integer.class, (boolean)false);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern(numberPattern);
        this.addColumnToModel(model, (TableCellEditor)editor, null, identifier);
    }

    protected void addBooleanColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, JTable table) {
        this.addColumnToModel(model, table.getDefaultEditor(Boolean.class), table.getDefaultRenderer(Boolean.class), identifier);
    }

    protected <B> void addComboDataColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, Decorator<B> decorator, List<B> data) {
        JComboBox comboBox = new JComboBox();
        comboBox.setRenderer(this.newListCellRender(decorator));
        ArrayList dataToList = Lists.newArrayList(data);
        if (!dataToList.isEmpty() && dataToList.get(0) != null) {
            dataToList.add(0, null);
        }
        SwingUtil.fillComboBox(comboBox, (Collection)dataToList, null);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), identifier);
    }

    protected <O> TableCellRenderer newTableCellRender(Class<O> type) {
        return this.newTableCellRender(type, null);
    }

    protected <O> TableCellRenderer newTableCellRender(Class<O> type, String name) {
        Decorator<O> decorator = this.getDecorator(type, name);
        TableCellRenderer result = this.newTableCellRender(decorator);
        return result;
    }

    protected <O> TableCellRenderer newTableCellRender(Decorator<O> decorator) {
        Preconditions.checkNotNull(decorator);
        DecoratorTableCellRenderer result = new DecoratorTableCellRenderer(decorator, true);
        return result;
    }

    protected void installTableSaveOnRowChangedSelectionListener() {
        Preconditions.checkState((this.tableSelectionListener == null ? 1 : 0) != 0, (Object)"There is already a tableSelectionListener registred, remove it before invoking this method.");
        this.tableSelectionListener = new ListSelectionListener(){
            protected int selectedRowIndex;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel source = (ListSelectionModel)e.getSource();
                    int oldRowIndex = this.selectedRowIndex;
                    AbstractTuttiBeanUIModel oldRow = (AbstractTuttiBeanUIModel)AbstractTuttiTableUIHandler.this.rowMonitor.getBean();
                    int newRowIndex = source.getLeadSelectionIndex();
                    AbstractTuttiBeanUIModel newRow = source.isSelectionEmpty() ? null : (AbstractTuttiBeanUIModel)AbstractTuttiTableUIHandler.this.getTableModel().getEntry(newRowIndex);
                    AbstractTuttiTableUIHandler.this.saveSelectedRowIfNeeded();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Will monitor entry: " + newRow));
                    }
                    AbstractTuttiTableUIHandler.this.rowMonitor.setBean(newRow);
                    this.selectedRowIndex = newRowIndex;
                    AbstractTuttiTableUIHandler.this.onAfterSelectedRowChanged(oldRowIndex, oldRow, this.selectedRowIndex, (AbstractTuttiBeanUIModel)AbstractTuttiTableUIHandler.this.rowMonitor.getBean());
                }
            }
        };
        if (log.isInfoEnabled()) {
            log.info((Object)("Intall " + this.tableSelectionListener + " on tableModel " + this.getTableModel()));
        }
        this.getTable().getSelectionModel().addListSelectionListener(this.tableSelectionListener);
    }

    protected void uninstallTableSaveOnRowChangedSelectionListener() {
        if (this.tableSelectionListener != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Desintall " + this.tableSelectionListener));
            }
            this.getTable().getSelectionModel().removeListSelectionListener(this.tableSelectionListener);
            this.tableSelectionListener = null;
        }
    }

    protected void installTableKeyListener(TableColumnModel columnModel, final JTable table) {
        Preconditions.checkState((this.keyAdapter == null ? 1 : 0) != 0, (Object)"There is already a tableSelectionListener registred, remove it before invoking this method.");
        AbstractTuttiTableModel<R> model = this.getTableModel();
        final MoveToNextEditableCellAction<AbstractTuttiTableModel<R>> nextCellAction = MoveToNextEditableCellAction.newAction(model, table);
        final MoveToPreviousEditableCellAction<AbstractTuttiTableModel<R>> previousCellAction = MoveToPreviousEditableCellAction.newAction(model, table);
        final MoveToNextEditableRowAction<AbstractTuttiTableModel<R>> nextRowAction = MoveToNextEditableRowAction.newAction(model, table);
        final MoveToPreviousEditableRowAction<AbstractTuttiTableModel<R>> previousRowAction = MoveToPreviousEditableRowAction.newAction(model, table);
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TableCellEditor editor = table.getCellEditor();
                int keyCode = e.getKeyCode();
                if (keyCode == 37 || keyCode == 9 && e.isShiftDown()) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    previousCellAction.actionPerformed(null);
                } else if (keyCode == 39 || keyCode == 9) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    nextCellAction.actionPerformed(null);
                } else if (keyCode == 38) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    previousRowAction.actionPerformed(null);
                } else if (keyCode == 40) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    nextRowAction.actionPerformed(null);
                }
            }
        };
        if (log.isInfoEnabled()) {
            log.info((Object)("Intall " + this.keyAdapter));
        }
        table.addKeyListener(this.keyAdapter);
        Enumeration<TableColumn> columns = columnModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tableColumn = columns.nextElement();
            TableCellEditor cellEditor = tableColumn.getCellEditor();
            if (!(cellEditor instanceof NumberCellEditor)) continue;
            NumberCellEditor editor = (NumberCellEditor)cellEditor;
            editor.getNumberEditor().getTextField().addKeyListener(this.keyAdapter);
        }
    }

    protected void uninstallTableKeyListener() {
        if (this.keyAdapter != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Desintall " + this.keyAdapter));
            }
            this.getTable().removeKeyListener((KeyListener)this.keyAdapter);
            TableColumnModel columnModel = this.getTable().getColumnModel();
            Enumeration<TableColumn> columns = columnModel.getColumns();
            while (columns.hasMoreElements()) {
                TableColumn tableColumn = columns.nextElement();
                TableCellEditor cellEditor = tableColumn.getCellEditor();
                if (!(cellEditor instanceof NumberCellEditor)) continue;
                NumberCellEditor editor = (NumberCellEditor)cellEditor;
                editor.getNumberEditor().getTextField().removeKeyListener(this.keyAdapter);
            }
            this.keyAdapter = null;
        }
    }

    protected final void saveSelectedRowIfNeeded() {
        AbstractTuttiBeanUIModel row = (AbstractTuttiBeanUIModel)this.rowMonitor.getBean();
        if (row != null) {
            this.saveSelectedRowIfRequired(this.rowMonitor, row);
        }
    }

    protected final void recomputeRowValidState(R row) {
        boolean valid = this.isRowValid(row);
        ((AbstractTuttiBeanUIModel)row).setValid(valid);
        if (valid) {
            ((AbstractTuttiTableUIModel)this.getModel()).removeRowInError(row);
        } else {
            ((AbstractTuttiTableUIModel)this.getModel()).addRowInError(row);
        }
    }

    public void autoSelectRowInTable(MouseEvent e, JPopupMenu popup) {
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick || SwingUtilities.isLeftMouseButton(e)) {
            boolean stopEdit;
            Point p = e.getPoint();
            JXTable source = (JXTable)e.getSource();
            int[] selectedRows = source.getSelectedRows();
            int rowIndex = source.rowAtPoint(p);
            if (log.isDebugEnabled()) {
                log.debug((Object)("At point [" + p + "] found Row " + rowIndex));
            }
            boolean canContinue = true;
            if (source.isEditing() && !(stopEdit = source.getCellEditor().stopCellEditing())) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not stop edit cell...");
                }
                canContinue = false;
            }
            if (canContinue) {
                if (rowIndex == -1) {
                    source.clearSelection();
                } else if (!ArrayUtils.contains((int[])selectedRows, (int)rowIndex)) {
                    source.setRowSelectionInterval(rowIndex, rowIndex);
                }
                if (rightClick) {
                    popup.show((Component)source, e.getX(), e.getY());
                }
            }
        }
    }
}

