/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.ArrayList;
import java.util.Collections;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.nuiton.i18n.I18n;

public class RemoveSpeciesProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    public RemoveSpeciesProtocolAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected void doAction() throws Exception {
        int rowIndex = ((EditProtocolUIHandler)this.handler).getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove species if no species selected");
        EditProtocolSpeciesTableModel tableModel = ((EditProtocolUIHandler)this.handler).getTableModel();
        EditProtocolSpeciesRowModel selectedRow = (EditProtocolSpeciesRowModel)((Object)tableModel.getEntry(rowIndex));
        Species species = selectedRow.getSpecies();
        BeanFilterableComboBox<Species> combo = ((EditProtocolUI)this.getUI()).getSpeciesComboBox();
        combo.getData().add(species);
        combo.getHandler().sortData();
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        Integer taxonId = species.getReferenceTaxonId();
        ArrayList allSynonyms = Lists.newArrayList(model.getAllSynonyms(String.valueOf(taxonId)));
        allSynonyms.remove(species);
        model.getAllSynonyms().addAll(allSynonyms);
        Collections.sort(model.getAllSynonyms(), TuttiEntities.SPECIES_BY_NAME_COMPARATOR);
        tableModel.removeRow(rowIndex);
        String speciesStr = this.decorate(selectedRow.getSpecies());
        this.sendMessage(I18n._((String)"tutti.flash.information.species.remove.from.protocol", (Object[])new Object[]{speciesStr}));
    }
}

