/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.config.model.ConfigTableModel;
import jaxx.runtime.swing.config.model.OptionModel;
import org.nuiton.i18n.I18n;

public class ConfigTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected static Color col;
    protected static Font font;
    protected static Font font2;

    public ConfigTableRenderer() {
        col = this.getForeground();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cellRenderer;
        int modelRow = table.convertRowIndexToModel(row);
        int modelColumn = table.convertColumnIndexToModel(column);
        ConfigTableModel model = (ConfigTableModel)table.getModel();
        OptionModel key = model.getEntry(modelRow);
        boolean isModified = key.isModified();
        boolean isValid = key.isValid();
        if (font == null) {
            font = this.getFont();
            font2 = font.deriveFont(3);
        }
        switch (modelColumn) {
            case 0: {
                cellRenderer = this.getKeyCellRenderer(table, value, isSelected, hasFocus, modelRow, modelColumn, key, isValid, isModified);
                break;
            }
            case 1: {
                cellRenderer = this.getValueCellRenderer(table, value, isSelected, hasFocus, modelRow, modelColumn, key, isValid, isModified);
                break;
            }
            case 2: {
                cellRenderer = this.getValueCellRenderer(table, value, isSelected, hasFocus, modelRow, modelColumn, key, isValid, isModified);
                break;
            }
            default: {
                throw new IllegalStateException("no renderer find for column " + modelColumn);
            }
        }
        return cellRenderer;
    }

    protected Component getKeyCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column, OptionModel key, boolean isValid, boolean isModified) {
        String tooltip = I18n._((String)key.getDescription(), (Object[])new Object[0]);
        Object originalValue = key.getOriginalValue();
        boolean isFinal = key.isFinal();
        if (isFinal) {
            tooltip = tooltip + " [" + I18n._((String)"config.unmodifiable", (Object[])new Object[0]) + ']';
        }
        if (isModified) {
            String s = I18n._((String)"config.modified", (Object[])new Object[]{originalValue});
            value = value + " *";
            tooltip = tooltip + " [" + s + ']';
        }
        if (!isValid) {
            String s2 = I18n._((String)"config.unvalid", (Object[])new Object[]{originalValue, key.getType()});
            tooltip = tooltip + " (" + s2 + ")";
            value = value + " !";
        }
        JComponent result = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        result.setToolTipText(tooltip);
        result.setForeground(isValid ? col : Color.RED);
        result.setFont(isModified || !isValid ? font2 : font);
        result.setEnabled(!isFinal);
        return result;
    }

    protected Component getValueCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column, OptionModel key, boolean isValid, boolean isModified) {
        Component result;
        if (key.getRenderer() != null) {
            result = key.getRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        } else {
            TableCellRenderer defaultRenderer = table.getDefaultRenderer(key.getType());
            result = defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        return result;
    }
}

