/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RenameSpeciesBatchAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected Species selectedSpecies;

    public RenameSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(table.getSelectedRow());
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)((SpeciesBatchUIHandler)this.handler).getModel();
        ArrayList speciesList = Lists.newArrayList(model.getAllSpecies());
        speciesList.removeAll(model.getSpeciesUsed().get((Object)row.getSortedUnsortedCategoryValue()));
        this.selectedSpecies = ((SpeciesBatchUIHandler)this.getHandler()).openAddSpeciesDialog(I18n._((String)"tutti.title.selectSpecies", (Object[])new Object[0]), speciesList);
        return result &= this.selectedSpecies != null;
    }

    @Override
    protected void releaseAction() {
        this.selectedSpecies = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(table.getSelectedRow());
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        persistenceService.changeSpeciesBatchSpecies(row.getId(), this.selectedSpecies);
        Collection speciesUsed = ((SpeciesBatchUIModel)this.getModel()).getSpeciesUsed().get((Object)row.getSortedUnsortedCategoryValue());
        speciesUsed.remove(row.getSpecies());
        this.changeChildrenSpecies(row, this.selectedSpecies);
        speciesUsed.add(this.selectedSpecies);
    }

    protected void changeChildrenSpecies(SpeciesBatchRowModel row, Species species) {
        row.setSpecies(species);
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (children != null) {
            for (SpeciesBatchRowModel child : children) {
                this.changeChildrenSpecies(child, species);
            }
        }
    }
}

