/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.ehcache;

import java.io.IOException;
import java.io.InputStream;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class EhCacheManagerFactoryBean
implements FactoryBean<CacheManager>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String diskStorePath = null;
    private Resource configLocation;
    private boolean shared = false;
    private String cacheManagerName;
    private CacheManager cacheManager;

    public String getDiskStorePath() {
        return this.diskStorePath;
    }

    public void setDiskStorePath(String diskStorePath) {
        this.diskStorePath = diskStorePath;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public void afterPropertiesSet() throws IOException, CacheException {
        if (this.shared) {
            if (this.configLocation != null) {
                Configuration config = ConfigurationFactory.parseConfiguration((InputStream)this.configLocation.getInputStream());
                this.logger.info((Object)("Using EHCache disk store at " + this.getDiskStorePath()));
                config.getDiskStoreConfiguration().setPath(this.getDiskStorePath());
                if (this.cacheManagerName != null) {
                    config.setName(this.cacheManagerName);
                }
                this.cacheManager = CacheManager.create((Configuration)config);
            } else {
                this.cacheManager = CacheManager.create();
                if (this.cacheManagerName != null) {
                    this.cacheManager.setName(this.cacheManagerName);
                }
            }
        } else if (this.configLocation != null) {
            Configuration config = ConfigurationFactory.parseConfiguration((InputStream)this.configLocation.getInputStream());
            this.logger.info((Object)("Using EHCache disk store at " + this.getDiskStorePath()));
            config.getDiskStoreConfiguration().setPath(this.getDiskStorePath());
            if (this.cacheManagerName != null) {
                config.setName(this.cacheManagerName);
            }
            this.cacheManager = new CacheManager(config);
        } else {
            this.cacheManager = new CacheManager();
            if (this.cacheManagerName != null) {
                this.cacheManager.setName(this.cacheManagerName);
            }
        }
    }

    public CacheManager getObject() {
        return this.cacheManager;
    }

    public Class<? extends CacheManager> getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Shutting down EHCache CacheManager");
        this.cacheManager.shutdown();
    }
}

