/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.AnalysisInstrument;
import fr.ifremer.adagio.core.dao.referential.AnalysisInstrumentDao;
import fr.ifremer.adagio.core.dao.referential.AnalysisInstrumentImpl;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class AnalysisInstrumentDaoBase
extends HibernateDaoSupport
implements AnalysisInstrumentDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("AnalysisInstrument.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(AnalysisInstrumentImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (AnalysisInstrument)entity);
    }

    @Override
    public AnalysisInstrument load(Integer id) {
        return (AnalysisInstrument)this.load(0, id);
    }

    @Override
    public Collection<AnalysisInstrument> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(AnalysisInstrumentImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public AnalysisInstrument create(AnalysisInstrument analysisInstrument) {
        return (AnalysisInstrument)this.create(0, analysisInstrument);
    }

    @Override
    public Object create(int transform, AnalysisInstrument analysisInstrument) {
        if (analysisInstrument == null) {
            throw new IllegalArgumentException("AnalysisInstrument.create - 'analysisInstrument' can not be null");
        }
        this.getHibernateTemplate().save((Object)analysisInstrument);
        return this.transformEntity(transform, analysisInstrument);
    }

    @Override
    public Collection<AnalysisInstrument> create(Collection<AnalysisInstrument> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<AnalysisInstrument> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("AnalysisInstrument.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    AnalysisInstrumentDaoBase.this.create(transform, (AnalysisInstrument)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public AnalysisInstrument create(String name, String description, Timestamp updateDate, Status status) {
        return (AnalysisInstrument)this.create(0, name, description, updateDate, status);
    }

    @Override
    public Object create(int transform, String name, String description, Timestamp updateDate, Status status) {
        AnalysisInstrumentImpl entity = new AnalysisInstrumentImpl();
        entity.setName(name);
        entity.setDescription(description);
        entity.setUpdateDate(updateDate);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public AnalysisInstrument create(String name, Status status) {
        return (AnalysisInstrument)this.create(0, name, status);
    }

    @Override
    public Object create(int transform, String name, Status status) {
        AnalysisInstrumentImpl entity = new AnalysisInstrumentImpl();
        entity.setName(name);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(AnalysisInstrument analysisInstrument) {
        if (analysisInstrument == null) {
            throw new IllegalArgumentException("AnalysisInstrument.update - 'analysisInstrument' can not be null");
        }
        this.getHibernateTemplate().update((Object)analysisInstrument);
    }

    @Override
    public void update(final Collection<AnalysisInstrument> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("AnalysisInstrument.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    AnalysisInstrumentDaoBase.this.update((AnalysisInstrument)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(AnalysisInstrument analysisInstrument) {
        if (analysisInstrument == null) {
            throw new IllegalArgumentException("AnalysisInstrument.remove - 'analysisInstrument' can not be null");
        }
        this.getHibernateTemplate().delete((Object)analysisInstrument);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("AnalysisInstrument.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        AnalysisInstrument entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<AnalysisInstrument> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("AnalysisInstrument.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, AnalysisInstrument entity) {
        AnalysisInstrument target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected AnalysisInstrument toEntity(Object[] row) {
        AnalysisInstrument target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof AnalysisInstrument)) continue;
                target = (AnalysisInstrument)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), AnalysisInstrumentImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), AnalysisInstrumentImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<AnalysisInstrument> search(Search search) {
        return this.search(0, search);
    }
}

