/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.container;

import java.util.Locale;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class ContainerPointer
extends NodePointer {
    private Container container;
    private NodePointer valuePointer;
    private static final long serialVersionUID = 6140752946621686118L;

    public ContainerPointer(Container container, Locale locale) {
        super(null, locale);
        this.container = container;
    }

    public ContainerPointer(NodePointer parent, Container container) {
        super(parent);
        this.container = container;
    }

    public boolean isContainer() {
        return true;
    }

    public QName getName() {
        return null;
    }

    public Object getBaseValue() {
        return this.container;
    }

    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    public int getLength() {
        Object value = this.getBaseValue();
        return value == null ? 1 : ValueUtils.getLength(value);
    }

    public boolean isLeaf() {
        return this.getValuePointer().isLeaf();
    }

    public Object getImmediateNode() {
        Object value = this.getBaseValue();
        if (this.index != Integer.MIN_VALUE) {
            return this.index >= 0 && this.index < this.getLength() ? ValueUtils.getValue(value, this.index) : null;
        }
        return ValueUtils.getValue(value);
    }

    public void setValue(Object value) {
        this.container.setValue(value);
    }

    public NodePointer getImmediateValuePointer() {
        if (this.valuePointer == null) {
            Object value = this.getImmediateNode();
            this.valuePointer = NodePointer.newChildNodePointer(this, this.getName(), value);
        }
        return this.valuePointer;
    }

    public int hashCode() {
        return System.identityHashCode(this.container) + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ContainerPointer)) {
            return false;
        }
        ContainerPointer other = (ContainerPointer)object;
        return this.container == other.container && this.index == other.index;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        return this.getValuePointer().childIterator(test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName name) {
        return this.getValuePointer().attributeIterator(name);
    }

    public NodeIterator namespaceIterator() {
        return this.getValuePointer().namespaceIterator();
    }

    public NodePointer namespacePointer(String namespace) {
        return this.getValuePointer().namespacePointer(namespace);
    }

    public boolean testNode(NodeTest nodeTest) {
        return this.getValuePointer().testNode(nodeTest);
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return pointer1.getIndex() - pointer2.getIndex();
    }

    public String getNamespaceURI(String prefix) {
        return this.getValuePointer().getNamespaceURI(prefix);
    }

    public String asPath() {
        return this.parent == null ? "/" : this.parent.asPath();
    }
}

