/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.OpenDbAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.updater.ApplicationUpdater;
import org.nuiton.util.updater.ApplicationUpdaterCallback;

public class InstallDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(InstallDbAction.class);

    public InstallDbAction(MainUIHandler handler) {
        super(handler, "install-db", I18n._((String)"tutti.action.installDb", (Object[])new Object[0]), I18n._((String)"tutti.action.installDb.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected void doAction() {
        TuttiApplicationConfig config = this.getContext().getConfig();
        File current = config.getDataDirectory();
        String url = config.getUpdateUrl();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Try to install db (current data location: %s), using update url: %s", current, url));
        }
        ApplicationUpdater up = new ApplicationUpdater();
        File dest = new File(config.getTuttiBasedir(), "NEW");
        ProgressionModel progressionModel = new ProgressionModel();
        this.getContext().getActionUI().getModel().setProgressionModel(progressionModel);
        progressionModel.setMessage("Recherche de mises \u00e0 jour de base");
        TuttiApplicationUpdaterCallBack callback = new TuttiApplicationUpdaterCallBack(this.getContext(), progressionModel);
        callback.setTypes(TuttiApplicationUpdaterCallBack.UpdateType.DB);
        up.update(url, current, dest, false, (ApplicationUpdaterCallback)callback);
        this.sendMessage("Nouvelle base de donn\u00e9es install\u00e9e.");
        String jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();
        progressionModel.setMessage(String.format("Ouverture de la base de donn\u00e9es *%s*.", jdbcUrl));
        this.getContext().setDbExist(true);
        new OpenDbAction((MainUIHandler)this.getHandler()).performAndReleaseAction();
    }
}

