/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.TuttiPersistenceNoDbImpl;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MacroWasteBatch;
import fr.ifremer.tutti.persistence.entities.data.PlanktonBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.config.TuttiServiceConfig;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistenceService
extends AbstractTuttiService
implements TuttiPersistence {
    private static final Log log = LogFactory.getLog(PersistenceService.class);
    protected TuttiPersistence driver;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.init();
    }

    public String getImplementationName() {
        return "Tutti Persistence Service";
    }

    public void clearAllCaches() {
        this.driver.clearAllCaches();
    }

    public boolean isDbLoaded() {
        return !(this.driver instanceof TuttiPersistenceNoDbImpl);
    }

    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Open persistence driver " + this.getImplementationName()));
        }
        TuttiServiceConfig serviceConfig = this.context.getConfig();
        TuttiPersistenceConfig config = serviceConfig.getPersistenceConfig();
        TuttiPersistenceConfig.setInstance((TuttiPersistenceConfig)config);
        if (config.isDbExists()) {
            String jdbcUrl = config.getJdbcUrl();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using database at " + jdbcUrl));
            }
            this.driver = TuttiPersistenceServiceLocator.getPersistenceService();
            if (log.isInfoEnabled()) {
                log.info((Object)("Will open persistence driver " + this.driver.getImplementationName()));
            }
        } else {
            this.driver = new TuttiPersistenceNoDbImpl();
            if (log.isInfoEnabled()) {
                log.info((Object)("Will open persistence driver " + this.driver.getImplementationName()));
            }
            this.driver.init();
        }
    }

    @Override
    public void close() throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will close persistence Service " + this.getImplementationName()));
        }
        IOUtils.closeQuietly((Closeable)this.driver);
    }

    public List<Vessel> getAllScientificVessel() {
        return this.driver.getAllScientificVessel();
    }

    public List<Vessel> getAllFishingVessel() {
        return this.driver.getAllFishingVessel();
    }

    public List<Species> getAllSpecies() {
        return this.driver.getAllSpecies();
    }

    public List<Species> getAllReferentSpecies() {
        return this.driver.getAllReferentSpecies();
    }

    public List<Species> getAllSpecies(TuttiProtocol protocol) {
        return this.driver.getAllSpecies(protocol);
    }

    public List<Caracteristic> getAllCaracteristic() {
        return this.driver.getAllCaracteristic();
    }

    public List<Zone> getAllProgramZone() {
        return this.driver.getAllProgramZone();
    }

    public List<Country> getAllCountry() {
        return this.driver.getAllCountry();
    }

    public List<Gear> getAllScientificGear() {
        return this.driver.getAllScientificGear();
    }

    public List<Gear> getAllFishingGear() {
        return this.driver.getAllFishingGear();
    }

    public List<Person> getAllPerson() {
        return this.driver.getAllPerson();
    }

    public List<FishingOperationLocation> getAllFishingOperationStrata(String zoneId) {
        return this.driver.getAllFishingOperationStrata(zoneId);
    }

    public List<FishingOperationLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        return this.driver.getAllFishingOperationSubStrata(zoneId, strataId);
    }

    public List<FishingOperationLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        return this.driver.getAllFishingOperationLocation(zoneId, strataId, subStrataId);
    }

    public Caracteristic getSizeCategoryCaracteristic() {
        return this.driver.getSizeCategoryCaracteristic();
    }

    public Caracteristic getSexCaracteristic() {
        return this.driver.getSexCaracteristic();
    }

    public Caracteristic getSortedUnsortedCaracteristic() {
        return this.driver.getSortedUnsortedCaracteristic();
    }

    public Caracteristic getMaturityCaracteristic() {
        return this.driver.getMaturityCaracteristic();
    }

    public Caracteristic getMacroWasteCategoryCaracteristic() {
        return this.driver.getMacroWasteCategoryCaracteristic();
    }

    public Caracteristic getMacroWasteSizeCategoryCaracteristic() {
        return this.driver.getMacroWasteSizeCategoryCaracteristic();
    }

    public Vessel getVessel(String vesselCode) {
        return this.driver.getVessel(vesselCode);
    }

    public boolean isSortedQualitativeValue(CaracteristicQualitativeValue value) {
        return this.driver.isSortedQualitativeValue(value);
    }

    public Person getPerson(Integer personId) {
        return this.driver.getPerson(personId);
    }

    public Gear getGear(Integer gearCode) {
        return this.driver.getGear(gearCode);
    }

    public List<Species> importTemporarySpecies(List<Species> species) {
        return this.driver.importTemporarySpecies(species);
    }

    public List<Vessel> importTemporaryVessel(List<Vessel> vessels) {
        return this.driver.importTemporaryVessel(vessels);
    }

    public List<Person> importTemporaryPerson(List<Person> persons) {
        return this.driver.importTemporaryPerson(persons);
    }

    public List<Gear> importTemporaryGear(List<Gear> gears) {
        return this.driver.importTemporaryGear(gears);
    }

    public List<Program> getAllProgram() {
        return this.driver.getAllProgram();
    }

    public Program getProgram(String id) {
        return this.driver.getProgram(id);
    }

    public Program createProgram(Program bean) {
        return this.driver.createProgram(bean);
    }

    public Program saveProgram(Program bean) {
        return this.driver.saveProgram(bean);
    }

    public List<Cruise> getAllCruise(String programId) {
        return this.driver.getAllCruise(programId);
    }

    public Cruise getCruise(String id) {
        return this.driver.getCruise(id);
    }

    public Cruise createCruise(Cruise bean) {
        return this.driver.createCruise(bean);
    }

    public Cruise saveCruise(Cruise bean) {
        return this.driver.saveCruise(bean);
    }

    public boolean isProtocolExist(String id) {
        return this.driver.isProtocolExist(id);
    }

    public List<String> getAllProtocolNames() {
        return this.driver.getAllProtocolNames();
    }

    public List<TuttiProtocol> getAllProtocol() {
        return this.driver.getAllProtocol();
    }

    public TuttiProtocol getProtocol(String id) {
        return this.driver.getProtocol(id);
    }

    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        return this.driver.createProtocol(bean);
    }

    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        return this.driver.saveProtocol(bean);
    }

    public void deleteProtocol(String id) {
        this.driver.deleteProtocol(id);
    }

    public List<FishingOperation> getAllFishingOperation(String cruiseId) {
        return this.driver.getAllFishingOperation(cruiseId);
    }

    public FishingOperation getFishingOperation(String id) {
        return this.driver.getFishingOperation(id);
    }

    public FishingOperation createFishingOperation(FishingOperation bean) {
        return this.driver.createFishingOperation(bean);
    }

    public FishingOperation saveFishingOperation(FishingOperation bean) {
        return this.driver.saveFishingOperation(bean);
    }

    public CatchBatch getCatchBatchFromFishingOperation(String id) {
        return this.driver.getCatchBatchFromFishingOperation(id);
    }

    public CatchBatch createCatchBatch(CatchBatch bean) {
        return this.driver.createCatchBatch(bean);
    }

    public CatchBatch saveCatchBatch(CatchBatch bean) {
        return this.driver.saveCatchBatch(bean);
    }

    public List<SpeciesBatch> getAllRootSpeciesBatch(String fishingOperationId) {
        return this.driver.getAllRootSpeciesBatch(fishingOperationId);
    }

    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        return this.driver.createSpeciesBatch(bean, parentBatchId);
    }

    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        return this.driver.saveSpeciesBatch(bean);
    }

    public void deleteSpeciesBatch(String id) {
        this.driver.deleteSpeciesBatch(id);
    }

    public void deleteSpeciesSubBatch(String id) {
        this.driver.deleteSpeciesSubBatch(id);
    }

    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        this.driver.changeSpeciesBatchSpecies(batchId, species);
    }

    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        return this.driver.getAllSpeciesBatchFrequency(speciesBatchId);
    }

    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.driver.saveSpeciesBatchFrequency(speciesBatchId, frequencies);
    }

    public List<BenthosBatch> getAllBenthosBatch(String fishingOperationId) {
        return this.driver.getAllBenthosBatch(fishingOperationId);
    }

    public BenthosBatch getBenthosBatch(String id) {
        return this.driver.getBenthosBatch(id);
    }

    public BenthosBatch createBenthosBatch(BenthosBatch bean) {
        return this.driver.createBenthosBatch(bean);
    }

    public BenthosBatch saveBenthosBatch(BenthosBatch bean) {
        return this.driver.saveBenthosBatch(bean);
    }

    public void deleteBenthosBatch(String id) {
        this.driver.deleteBenthosBatch(id);
    }

    public List<PlanktonBatch> getAllPlanktonBatch(String fishingOperationId) {
        return this.driver.getAllPlanktonBatch(fishingOperationId);
    }

    public PlanktonBatch getPlanktonBatch(String id) {
        return this.driver.getPlanktonBatch(id);
    }

    public PlanktonBatch createPlanktonBatch(PlanktonBatch bean) {
        return this.driver.createPlanktonBatch(bean);
    }

    public PlanktonBatch savePlanktonBatch(PlanktonBatch bean) {
        return this.driver.savePlanktonBatch(bean);
    }

    public void deletePlanktonBatch(String id) {
        this.driver.deletePlanktonBatch(id);
    }

    public List<MacroWasteBatch> getAllMacroWasteBatch(String fishingOperationId) {
        return this.driver.getAllMacroWasteBatch(fishingOperationId);
    }

    public MacroWasteBatch getMacroWasteBatch(String id) {
        return this.driver.getMacroWasteBatch(id);
    }

    public MacroWasteBatch createMacroWasteBatch(MacroWasteBatch bean) {
        return this.driver.createMacroWasteBatch(bean);
    }

    public MacroWasteBatch saveMacroWasteBatch(MacroWasteBatch bean) {
        return this.driver.saveMacroWasteBatch(bean);
    }

    public void deleteMacroWasteBatch(String id) {
        this.driver.deleteMacroWasteBatch(id);
    }

    public List<AccidentalBatch> getAllAccidentalBatch(String fishingOperationId) {
        return this.driver.getAllAccidentalBatch(fishingOperationId);
    }

    public AccidentalBatch getAccidentalBatch(String id) {
        return this.driver.getAccidentalBatch(id);
    }

    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        return this.driver.createAccidentalBatch(bean);
    }

    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        return this.driver.saveAccidentalBatch(bean);
    }

    public void deleteAccidentalBatch(String id) {
        this.driver.deleteAccidentalBatch(id);
    }
}

