/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.auth;

import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticUserAuthenticator
implements UserAuthenticator,
Comparable<StaticUserAuthenticator> {
    private final String username;
    private final String password;
    private final String domain;

    public StaticUserAuthenticator(String domain, String username, String password) {
        this.username = username;
        this.password = password;
        this.domain = domain;
    }

    @Override
    public UserAuthenticationData requestAuthentication(UserAuthenticationData.Type[] types) {
        UserAuthenticationData data = new UserAuthenticationData();
        data.setData(UserAuthenticationData.DOMAIN, UserAuthenticatorUtils.toChar(this.domain));
        data.setData(UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(this.username));
        data.setData(UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(this.password));
        return data;
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 37 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 37 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StaticUserAuthenticator other = (StaticUserAuthenticator)obj;
        return this.equalsNullsafe(this.domain, other.domain) && this.equalsNullsafe(this.username, other.username) && this.equalsNullsafe(this.password, other.password);
    }

    private boolean equalsNullsafe(String thisString, String otherString) {
        return !(thisString == null ? otherString != null : !thisString.equals(otherString));
    }

    @Override
    public int compareTo(StaticUserAuthenticator other) {
        int result = this.compareStringOrNull(this.domain, other.domain);
        result = result == 0 ? this.compareStringOrNull(this.username, other.username) : result;
        result = result == 0 ? this.compareStringOrNull(this.password, other.password) : result;
        return result;
    }

    private int compareStringOrNull(String thisString, String otherString) {
        if (thisString == null) {
            if (otherString != null) {
                return -1;
            }
        } else {
            if (otherString == null) {
                return 1;
            }
            int result = thisString.compareTo(otherString);
            if (result != 0) {
                return result;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.domain != null) {
            buffer.append(this.domain).append('\\');
        }
        if (this.username != null) {
            buffer.append(this.username);
        } else {
            buffer.append("(null)");
        }
        if (this.password != null) {
            buffer.append(":***");
        }
        return buffer.toString();
    }
}

