
package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: SwingValidatorMessageWidget.java 201 2013-01-15 11:07:25Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/SwingValidatorMessageWidget.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Button which opens a popup containing a table with the errors found 
 * by registered validators.
 * 
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.5.10
 */
public class SwingValidatorMessageWidget extends JToggleButton {

    private static final Log log = LogFactory.getLog(SwingValidatorMessageWidget.class);
    
    protected SwingValidatorMessageTableModel errorTableModel = new SwingValidatorMessageTableModel();
    
    protected JDialog popup = new JDialog();
    
    protected JTable errorTable = new JTable();
    
    public SwingValidatorMessageWidget() {
        super(SwingUtil.createActionIcon("table-error"));
        
        errorTable.setModel(errorTableModel);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setAutoCreateRowSorter(true);
        errorTable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        errorTable.setCellSelectionEnabled(false);
        errorTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        errorTable.setFillsViewportHeight(true);
        
        SwingValidatorUtil.installUI(errorTable,
                                     new SwingValidatorMessageTableRenderer());
  
        JScrollPane scrollPanel = new JScrollPane(errorTable);
        scrollPanel.setColumnHeaderView(errorTable.getTableHeader());
        popup.add(scrollPanel);
        popup.setSize(800, 300);
        
        addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                if(isSelected()) {
                    popup.setVisible(true);
                } else {
                    popup.dispose();
                }
            }
        });
        popup.addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosing(WindowEvent e) {
                setSelected(false);
            }
            
        });
        
        // add a auto-close action
        JRootPane rootPane = popup.getRootPane();

        KeyStroke shortcutClosePopup = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);

        rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                shortcutClosePopup, "close");
        rootPane.getActionMap().put("close", new AbstractAction() {
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.dispose();
                setSelected(false);
            }
        });
    }
    
    /**
     * Registers a validator.
     * 
     * @param validator 
     */
    public void registerValidator(SwingValidator validator) {
        errorTableModel.registerValidator(validator);
        validator.reloadBean();
    }
    
    /** Clears all the validators. */
    public void clearValidators() {
        errorTableModel.clearValidators();
        errorTableModel.clear();
    }
    
}
