package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditProtocolUI extends JPanel implements TuttiUI<EditProtocolUIModel, EditProtocolUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ROW_ENABLED = "addRow.enabled";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_SPECIES_MENU_ENABLED = "removeSpeciesMenu.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SPECIES_COMBO_BOX_ENABLED = "speciesComboBox.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XS1MbRxAeMMiIRwBTEMd2UgITImJ7AT9Sdpk4PAy2sLAphF2ucHBG2pE09u7OZncWJKtI5SfkJyT3XFKVW06pHHLOIZdU/kIqlUOuqfTMrvYhVtLawGELTXd//Zzunu//Qv22haZf4lpNsRyDU50oW6vPnz8pviQlfp/YJYuanFnI/evpRb37aEj1z22OLu/nhfiCJ76wznSTGcQISd/No0Gb1zViVwnhHL0flSjZ9kLBJ9+tmY7VRPWNikP99p+/e79Rv/6uF6GaCdbNgCuZblKBJ3151EtVjs6BpgO8oGGjAmZY1KiAvSPibF3Dtv0Y6+RL9BU6m0cpE1sAxtFMcpclhpSvmRylq0wnO9ggGkd3ypZCyxbRiaVwh3OqOFSxD0G/UmIGBzjFtBhnJaYpGyrlO96PpznTlIgpjs5WsaFqxOJo5a3RHroQAWi/zlRh4L23htwWAAHgKLEsZu3hoka2XejlSJoOsEZVDFHz0Avi+6x5uE1sG1dIIB4Ap31Jjq68AWSAMMgF7A4zHcjOlEh6zZPYkofbxHAC7nEIBjsgBZOUKLEFjaPJiJA4y3GiC4HzvtzI7BaYXySqSP0iR+9GZAKSYE/7UmPN6OaMMttkls7R+YiTrrwMjBD5IIiLAUWbx0UR6nMRXfJQcE1HmTcp0dTWCOyRGpeEqMBQiek6ZF9Y3OpLoWQxTWv6EsgMezKensljelYtggXvx0Ftz0rPFsXPy1H/BioEW3lqw1W8FhMRAsUImS8SbChr8LnPHAAS/EJ+MVSXxgG1mCEMa1JvRllGqnUVPGKVehsGz8qlGCtHbbdOoD0U2RqrtdZovLFNbgFyx8dKYVXdZYccTUQitwbXkhlRVii2IAsyelejDMOeXdJwji4yq6K8hJ7+ijPTBa4pW8/9sloNwj7r1o8EnWtJiUdb6kC7Hk+T/XCxtVLlafRCDJewUSJa4PSK+OSDy2zjA9KWmhaZElcJVF2Iv0eCah4XkD49jSFcb0e40Y5wsx3hVpNgoYsR42A6KsF0DMZXzz7qtxw4hq6wf3yg7gLJHaXnW0apAJTU/6Ymfv/pzx83m/MzA7onY1lD4x/mGrQlE0YOFapH3eHpcKotbGPz7j5K20SD3UHuBpdiDCt4ZDAO9I0LcUWIKw+xXQWI/rN//PzL1Be/nUG9m2hQY1jdxII/h9K8akEUmKbWzM9WpEXDhwPwHRO2Qfrp0m1jxyJlCldt1J1Ynq11pQaRuBQTCd+cYvrXfycKP6w0o9ED1r3Xlj2ISP/nKEUNjRpE7hPeqhC7PwyZNnFUFqwEcUsCgkE0HG4EXrEQ+aVxjveJ5gGtqCEH91HNEZy69EH8xwTkO9FG2B00VWSWKjaLxcaa/M9NQ10pQafmZI9yjaguJZt196Z5w9G0+Rj9YGIZ5pfZRWsvtANNNIpNMdCHGv5gOgIADkMCSt1Nq+QSya1YWFcEX5zSYAx209zjKxh3g6hUCBeZy8a7E8zMBD6NwQh3dOMhwRCrZ5RAF59rGOQw43bF7IvsTNgrb1LOzM+D20M6Naju6AX6Gi7/lBS7D8Vo2JQZ2aXFq7cW4y0MD+nk3s82wG83mbAsOSTrB2PdhcvOx6uLzPdu+s5ArRJDzBdYBT70Ak5tWO5ouZ6dz8zNZZpncmXLzgcFMO6GCmoRAqCIhg8X3/2VE1sp6hNncSaGpkOCpHnqJiLq3PnTojDlnsZHJTSwEigNonKpMd2yPUAwNnST12Uw0tAGD3eJLV5T/WWs2bEety4gb2TBlUarAaI0ZPsjqlhxIVHTn2bElT9qicgZWFbi7PGWmATl2K+5y6t33bloNkoR81J1VeqxYxMc7PLdVPSFPc34FbgbXu83XHq4+C5EqiHyGIDWpRtwYNASRz27LREZlrZfAy2Ex6bq+MsigQsj7qgFLeJdJK6SaO2F8KGmFHKPH+Q3XhQ28hvre7knj8GbARv6q7v8ucUDde5DQe8lFYs5BkRmpLEOu6+lrOVX1x8dhbnWcOlVkyvVkEUQewHCq2aCtjAgJtle3QSLJhvr2IIYEgt8oiWlJGakML450r1nwI5e1kPT6ln3adXSbyESSpnaVeh5TwAYy9wK5EKVMQ6nM216nv8KOXXHwg+TFv+eno5/IQXt3Gt9HZ26l8HbqsXHwun46MO38zD6uEvQllIarjNQi95ZVjHHmSI1VFB57xh4j/gOJkD0IwYcPUPxODe64gjhsQ4In5wY4faJEZYTRCPoyeeW3Z06gzlsI0WHkzZBfpAAdqLKLPoa+jDWVjVakRXdwdIkkHIgCIyZt8UQwtMdEHKJED7q4EcyhKsntqGTF49O7EUyhE5eJEMY7GDDNiD8D+8MwEksFwAA";
    private static final Log log = LogFactory.getLog(EditProtocolUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addRow;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentField")
    protected JTextArea commentField;
    protected JScrollPane commentPane;
    protected BeanDoubleList<Caracteristic> environmentList;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected BeanDoubleList<Caracteristic> gearList;
    protected EditProtocolUIHandler handler;
    protected EditProtocolUI homePanel = this;
    protected BeanDoubleList<Caracteristic> hydrologyList;
    protected EditProtocolUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected Table protocolInfoForm;
    protected JMenuItem removeSpeciesMenu;
    protected JButton saveButton;
    protected BeanComboBox<Species> speciesComboBox;
    protected JXTable speciesTable;
    protected JPopupMenu tablePopup;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditProtocolUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JTabbedPane $JTabbedPane0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditProtocolUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  EditProtocolUIHandler handler = new EditProtocolUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditProtocolUI() {
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addRow(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addRow();
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__removeSpeciesMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeSpecies();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doMouseClicked__on__speciesTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddRow() {
        return addRow;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public BeanDoubleList<Caracteristic> getEnvironmentList() {
        return environmentList;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public BeanDoubleList<Caracteristic> getGearList() {
        return gearList;
    }

    public EditProtocolUIHandler getHandler() {
        return handler;
    }

    public BeanDoubleList<Caracteristic> getHydrologyList() {
        return hydrologyList;
    }

    public EditProtocolUIModel getModel() {
        return model;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public Table getProtocolInfoForm() {
        return protocolInfoForm;
    }

    public JMenuItem getRemoveSpeciesMenu() {
        return removeSpeciesMenu;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public BeanComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JXTable getSpeciesTable() {
        return speciesTable;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(commentField));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($JTabbedPane0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToProtocolInfoForm() {
        if (!allComponentsCreated) {
            return;
        }
        protocolInfoForm.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(commentPane, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeSpeciesMenu);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddRow() {
        $objectMap.put("addRow", addRow = new JButton());
        
        addRow.setName("addRow");
        addRow.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addRow"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
    }

    protected void createEnvironmentList() {
        $objectMap.put("environmentList", environmentList = new BeanDoubleList<Caracteristic>());
        
        environmentList.setName("environmentList");
        environmentList.setProperty("environmentPmfm");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createGearList() {
        $objectMap.put("gearList", gearList = new BeanDoubleList<Caracteristic>());
        
        gearList.setName("gearList");
        gearList.setProperty("gearPmfm");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditProtocolUIHandler.class));
    }

    protected void createHydrologyList() {
        $objectMap.put("hydrologyList", hydrologyList = new BeanDoubleList<Caracteristic>());
        
        hydrologyList.setName("hydrologyList");
        hydrologyList.setProperty("hydrologyPmfm");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditProtocolUIModel.class));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.label.program.name"));
    }

    protected void createProtocolInfoForm() {
        $objectMap.put("protocolInfoForm", protocolInfoForm = new Table());
        
        protocolInfoForm.setName("protocolInfoForm");
    }

    protected void createRemoveSpeciesMenu() {
        $objectMap.put("removeSpeciesMenu", removeSpeciesMenu = new JMenuItem());
        
        removeSpeciesMenu.setName("removeSpeciesMenu");
        removeSpeciesMenu.setText(_("tutti.action.removeSpecies"));
        removeSpeciesMenu.setMnemonic(82);
        removeSpeciesMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeSpeciesMenu"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setI18nPrefix("tutti.property.");
        speciesComboBox.setShowReset(false);
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new JXTable());
        
        speciesTable.setName("speciesTable");
        speciesTable.setSortable(false);
        speciesTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__speciesTable"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.title.batchActions");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditProtocolUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToTablePopup();
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add(protocolInfoForm);
        $JTabbedPane0.add($Table0);
        $JTabbedPane0.add($Table1);
        $JTabbedPane0.add($JLabel0);
        $JTabbedPane0.add($JLabel1);
        $JTabbedPane0.add($JLabel2);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, _("tutti.label.tab.protocol.info"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, _("tutti.label.tab.protocol.fishingOperation"));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 2));
        $JTabbedPane0.setTitleAt(2, _("tutti.label.tab.protocol.species"));
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 3));
        $JTabbedPane0.setTitleAt(3, _("tutti.label.tab.protocol.benthos"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 4));
        $JTabbedPane0.setTitleAt(4, _("tutti.label.tab.protocol.plankton"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 5));
        $JTabbedPane0.setTitleAt(5, _("tutti.label.tab.protocol.accidental"));
        addChildrenToProtocolInfoForm();
        addChildrenToCommentPane();
        // inline complete setup of $Table0
        $Table0.add(gearList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(environmentList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(hydrologyList, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(speciesComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(addRow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(speciesTable);
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 25 property setters
        gearList.setBeanType(Caracteristic.class);
        environmentList.setBeanType(Caracteristic.class);
        hydrologyList.setBeanType(Caracteristic.class);
        speciesComboBox.setBeanType(Species.class);
        $JLabel0.setHorizontalAlignment(JLabel.CENTER);
        $JLabel1.setHorizontalAlignment(JLabel.CENTER);
        $JLabel2.setHorizontalAlignment(JLabel.CENTER);
        removeSpeciesMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        nameLabel.setLabelFor(nameField);
        commentPane.setColumnHeaderView(new JLabel(_("tutti.label.comment")));
        commentPane.setMinimumSize(new Dimension(10,50));
        gearList.setBean(model);
        gearList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.tab.fishingOperation.gearShooting")));
        environmentList.setBean(model);
        environmentList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.tab.fishingOperation.environment")));
        hydrologyList.setBean(model);
        hydrologyList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.tab.fishingOperation.hydrology")));
        addRow.setIcon(SwingUtil.createActionIcon("add"));
        speciesTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        speciesTable.setSelectionForeground(Color.BLACK);
        speciesTable.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createTablePopup();
        createRemoveSpeciesMenu();
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        createProtocolInfoForm();
        createNameLabel();
        createNameField();
        createCommentPane();
        createCommentField();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createGearList();
        createEnvironmentList();
        createHydrologyList();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createSpeciesComboBox();
        createAddRow();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSpeciesTable();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setEnabled(false);
        $JLabel0.setText(_("tutti.to.be.done"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setEnabled(false);
        $JLabel1.setText(_("tutti.to.be.done"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setEnabled(false);
        $JLabel2.setText(_("tutti.to.be.done"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("tutti.label.tab.protocol.info"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("tutti.label.tab.protocol.fishingOperation"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(_("tutti.label.tab.protocol.species"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(_("tutti.label.tab.protocol.benthos"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(_("tutti.label.tab.protocol.plankton"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(_("tutti.label.tab.protocol.accidental"));
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesMenu.setEnabled(model.isRemoveSpeciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, getStringValue(model.getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.setEnabled(!speciesComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ROW_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    addRow.setEnabled(speciesComboBox.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}