package fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting;

/*
 * #%L
 * Tutti :: UI
 * $Id: GearShootingTabUIModel.java 164 2013-01-10 13:15:31Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/gearshooting/GearShootingTabUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * @author kmorin
 * @since 0.3
 */
public class GearShootingTabUIModel extends AbstractTuttiTableUIModel<FishingOperation, GearShootingRowModel, GearShootingTabUIModel> {

    private static final long serialVersionUID = 1L;
    
    private static final Log log = LogFactory.getLog(GearShootingTabUIModel.class);
    
    public static final String TITLE = "tutti.label.tab.fishingOperation.gearShooting";
    
    public static final String PROPERTY_REMOVE_CARACTERISTIC_ENABLED = "removeCaracteristicEnabled";
    
    protected List<Caracteristic> availableCaracteristics;
    
    /**
     * Fishing operation associated with the caracteristics
     * 
     * @since 0.3
     */
    protected FishingOperation fishingOperation;
    
    /**
     * Can user remove a selected caracteristic?
     *
     * @since 0.3
     */
    protected boolean removeCaracteristicEnabled;

    protected static final Binder<FishingOperation, GearShootingTabUIModel> fromBeanBinder = BinderModelBuilder.newEmptyBuilder(FishingOperation.class, GearShootingTabUIModel.class)
            .toBinder();

    protected static final Binder<GearShootingTabUIModel, FishingOperation> toBeanBinder = BinderModelBuilder.newEmptyBuilder(GearShootingTabUIModel.class, FishingOperation.class)
            .toBinder();

    public GearShootingTabUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    public List<Caracteristic> getAvailableCaracteristics() {
        return availableCaracteristics;
    }

    public void setAvailableCaracteristics(List<Caracteristic> availableCaracteristics) {
        this.availableCaracteristics = availableCaracteristics;
    }
    
    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }
    
    public boolean isRemoveCaracteristicEnabled() {
        return removeCaracteristicEnabled;
    }

    public void setRemoveCaracteristicEnabled(boolean removeCaracteristicEnabled) {
        Object oldValue = isRemoveCaracteristicEnabled();
        this.removeCaracteristicEnabled = removeCaracteristicEnabled;
        firePropertyChange(PROPERTY_REMOVE_CARACTERISTIC_ENABLED, oldValue, removeCaracteristicEnabled);
    }
    
}
