package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste.MacroWasteBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.plankton.PlanktonBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditCatchesUI extends JPanel implements TuttiUI<EditCatchesUIModel, EditCatchesUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_MODEL = "benthosTotalSampleSortedWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "benthosTotalSampleSortedWeightField.numberPattern";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "benthosTotalSortedWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "benthosTotalSortedWeightField.numberPattern";
    public static final String BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "benthosTotalUnsortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_MODEL = "benthosTotalWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "benthosTotalWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL = "catchTotalRejectedWeightField.model";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalRejectedWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_MODEL = "catchTotalSortedCarousselWeightField.model";
    public static final String BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalSortedCarousselWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_MODEL = "catchTotalSortedTremisWeightField.model";
    public static final String BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalSortedTremisWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "catchTotalUnsortedWeightField.text";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL = "catchTotalWeightField.model";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalWeightField.numberPattern";
    public static final String BINDING_MACRO_WASTE_TOTAL_WEIGHT_FIELD_MODEL = "macroWasteTotalWeightField.model";
    public static final String BINDING_MACRO_WASTE_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "macroWasteTotalWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSampleSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalSampleSortedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalSortedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_MODEL = "speciesTotalWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalWeightField.numberPattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCatchesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo accidentalTab;
    protected AccidentalBatchUI accidentalTabContent;
    protected JXTitledPanel accidentalTabFishingOperationReminderLabel;
    protected TabInfo benthosTab;
    protected BenthosBatchUI benthosTabContent;
    protected JXTitledPanel benthosTabFishingOperationReminderLabel;
    protected Table benthosTable;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSampleSortedWeight",  editorName = "benthosTotalSampleSortedWeightField")
    protected NumberEditor benthosTotalSampleSortedWeightField;
    protected JLabel benthosTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSortedWeight",  editorName = "benthosTotalSortedWeightField")
    protected NumberEditor benthosTotalSortedWeightField;
    protected JLabel benthosTotalSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalUnsortedWeight",  editorName = "benthosTotalUnsortedWeightField")
    protected JTextField benthosTotalUnsortedWeightField;
    protected JLabel benthosTotalUnsortedWeightLabel;
    protected NumberEditor benthosTotalWeightField;
    protected JLabel benthosTotalWeightLabel;
    protected Table catchTable;
    protected JLabel catchThalassaLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalRejectedWeight",  editorName = "catchTotalRejectedWeightField")
    protected NumberEditor catchTotalRejectedWeightField;
    protected JLabel catchTotalRejectedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalSortedCarousselWeight",  editorName = "catchTotalSortedCarousselWeightField")
    protected NumberEditor catchTotalSortedCarousselWeightField;
    protected JLabel catchTotalSortedCarousselWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalSortedTremisWeight",  editorName = "catchTotalSortedTremisWeightField")
    protected NumberEditor catchTotalSortedTremisWeightField;
    protected JLabel catchTotalSortedTremisWeightLabel;
    protected JLabel catchTotalSortedWeightLabel;
    protected JTextField catchTotalUnsortedWeightField;
    protected JLabel catchTotalUnsortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalWeight",  editorName = "catchTotalWeightField")
    protected NumberEditor catchTotalWeightField;
    protected JLabel catchTotalWeightLabel;
    protected TabInfo catchesCaracteristicsTab;
    protected JXTitledPanel catchesCaracteristicsTabPane;
    protected JScrollPane catchesCaracteristicsTabScrollPane;
    protected Table catchesForm;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected EditCatchesUIHandler handler;
    protected EditCatchesUI homePanel = this;
    protected JButton importPupitriButton;
    protected TabInfo macroWasteTab;
    protected MacroWasteBatchUI macroWasteTabContent;
    protected JXTitledPanel macroWasteTabFishingOperationReminderLabel;
    protected Table macroWasteTable;
    @ValidatorField( validatorId = "validator",  propertyName = "macroWasteTotalWeight",  editorName = "macroWasteTotalWeightField")
    protected NumberEditor macroWasteTotalWeightField;
    protected JLabel macroWasteTotalWeightLabel;
    protected EditCatchesUIModel model;
    protected TabInfo observationIndividuelTab;
    protected JXTitledPanel observationTabFishingOperationReminderLabel;
    protected TabInfo planktonTab;
    protected PlanktonBatchUI planktonTabContent;
    protected JXTitledPanel planktonTabFishingOperationReminderLabel;
    protected TabInfo speciesTab;
    protected SpeciesBatchUI speciesTabContent;
    protected JXTitledPanel speciesTabFishingOperationReminderLabel;
    protected Table speciesTable;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSampleSortedWeight",  editorName = "speciesTotalSampleSortedWeightField")
    protected NumberEditor speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected NumberEditor speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalUnsortedWeight",  editorName = "speciesTotalUnsortedWeightField")
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected NumberEditor speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JTabbedPane tabPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCatchesUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCatchesUI(FishingOperationsUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            EditCatchesUIHandler handler = new EditCatchesUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EditCatchesUI() {
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__importPupitriButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importPupitri();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TabInfo getAccidentalTab() {
        return accidentalTab;
    }

    public AccidentalBatchUI getAccidentalTabContent() {
        return accidentalTabContent;
    }

    public JXTitledPanel getAccidentalTabFishingOperationReminderLabel() {
        return accidentalTabFishingOperationReminderLabel;
    }

    public TabInfo getBenthosTab() {
        return benthosTab;
    }

    public BenthosBatchUI getBenthosTabContent() {
        return benthosTabContent;
    }

    public JXTitledPanel getBenthosTabFishingOperationReminderLabel() {
        return benthosTabFishingOperationReminderLabel;
    }

    public Table getBenthosTable() {
        return benthosTable;
    }

    public NumberEditor getBenthosTotalSampleSortedWeightField() {
        return benthosTotalSampleSortedWeightField;
    }

    public JLabel getBenthosTotalSampleSortedWeightLabel() {
        return benthosTotalSampleSortedWeightLabel;
    }

    public NumberEditor getBenthosTotalSortedWeightField() {
        return benthosTotalSortedWeightField;
    }

    public JLabel getBenthosTotalSortedWeightLabel() {
        return benthosTotalSortedWeightLabel;
    }

    public JTextField getBenthosTotalUnsortedWeightField() {
        return benthosTotalUnsortedWeightField;
    }

    public JLabel getBenthosTotalUnsortedWeightLabel() {
        return benthosTotalUnsortedWeightLabel;
    }

    public NumberEditor getBenthosTotalWeightField() {
        return benthosTotalWeightField;
    }

    public JLabel getBenthosTotalWeightLabel() {
        return benthosTotalWeightLabel;
    }

    public Table getCatchTable() {
        return catchTable;
    }

    public JLabel getCatchThalassaLabel() {
        return catchThalassaLabel;
    }

    public NumberEditor getCatchTotalRejectedWeightField() {
        return catchTotalRejectedWeightField;
    }

    public JLabel getCatchTotalRejectedWeightLabel() {
        return catchTotalRejectedWeightLabel;
    }

    public NumberEditor getCatchTotalSortedCarousselWeightField() {
        return catchTotalSortedCarousselWeightField;
    }

    public JLabel getCatchTotalSortedCarousselWeightLabel() {
        return catchTotalSortedCarousselWeightLabel;
    }

    public NumberEditor getCatchTotalSortedTremisWeightField() {
        return catchTotalSortedTremisWeightField;
    }

    public JLabel getCatchTotalSortedTremisWeightLabel() {
        return catchTotalSortedTremisWeightLabel;
    }

    public JLabel getCatchTotalSortedWeightLabel() {
        return catchTotalSortedWeightLabel;
    }

    public JTextField getCatchTotalUnsortedWeightField() {
        return catchTotalUnsortedWeightField;
    }

    public JLabel getCatchTotalUnsortedWeightLabel() {
        return catchTotalUnsortedWeightLabel;
    }

    public NumberEditor getCatchTotalWeightField() {
        return catchTotalWeightField;
    }

    public JLabel getCatchTotalWeightLabel() {
        return catchTotalWeightLabel;
    }

    public TabInfo getCatchesCaracteristicsTab() {
        return catchesCaracteristicsTab;
    }

    public JXTitledPanel getCatchesCaracteristicsTabPane() {
        return catchesCaracteristicsTabPane;
    }

    public JScrollPane getCatchesCaracteristicsTabScrollPane() {
        return catchesCaracteristicsTabScrollPane;
    }

    public Table getCatchesForm() {
        return catchesForm;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public EditCatchesUIHandler getHandler() {
        return handler;
    }

    public JButton getImportPupitriButton() {
        return importPupitriButton;
    }

    public TabInfo getMacroWasteTab() {
        return macroWasteTab;
    }

    public MacroWasteBatchUI getMacroWasteTabContent() {
        return macroWasteTabContent;
    }

    public JXTitledPanel getMacroWasteTabFishingOperationReminderLabel() {
        return macroWasteTabFishingOperationReminderLabel;
    }

    public Table getMacroWasteTable() {
        return macroWasteTable;
    }

    public NumberEditor getMacroWasteTotalWeightField() {
        return macroWasteTotalWeightField;
    }

    public JLabel getMacroWasteTotalWeightLabel() {
        return macroWasteTotalWeightLabel;
    }

    public EditCatchesUIModel getModel() {
        return model;
    }

    public TabInfo getObservationIndividuelTab() {
        return observationIndividuelTab;
    }

    public JXTitledPanel getObservationTabFishingOperationReminderLabel() {
        return observationTabFishingOperationReminderLabel;
    }

    public TabInfo getPlanktonTab() {
        return planktonTab;
    }

    public PlanktonBatchUI getPlanktonTabContent() {
        return planktonTabContent;
    }

    public JXTitledPanel getPlanktonTabFishingOperationReminderLabel() {
        return planktonTabFishingOperationReminderLabel;
    }

    public TabInfo getSpeciesTab() {
        return speciesTab;
    }

    public SpeciesBatchUI getSpeciesTabContent() {
        return speciesTabContent;
    }

    public JXTitledPanel getSpeciesTabFishingOperationReminderLabel() {
        return speciesTabFishingOperationReminderLabel;
    }

    public Table getSpeciesTable() {
        return speciesTable;
    }

    public NumberEditor getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public NumberEditor getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public NumberEditor getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccidentalTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabFishingOperationReminderLabel.add(accidentalTabContent);
    }

    protected void addChildrenToBenthosTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabFishingOperationReminderLabel.add(benthosTabContent);
    }

    protected void addChildrenToBenthosTable() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTable.add(benthosTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSampleSortedWeightField), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalUnsortedWeightField), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchTable() {
        if (!allComponentsCreated) {
            return;
        }
        catchTable.add(catchTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalWeightField), new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedCarousselWeightLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalSortedCarousselWeightField), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedTremisWeightLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalSortedTremisWeightField), new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightField, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalRejectedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalRejectedWeightField), new GridBagConstraints(1, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchThalassaLabel, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchesCaracteristicsTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabPane.add(catchesCaracteristicsTabScrollPane);
    }

    protected void addChildrenToCatchesCaracteristicsTabScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabScrollPane.getViewport().add($JPanel0);
    }

    protected void addChildrenToCatchesForm() {
        if (!allComponentsCreated) {
            return;
        }
        catchesForm.add(catchTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(speciesTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(benthosTable, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(macroWasteTable, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add($JPanel1, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(tabPane, BorderLayout.CENTER);
    }

    protected void addChildrenToMacroWasteTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        macroWasteTabFishingOperationReminderLabel.add(macroWasteTabContent);
    }

    protected void addChildrenToMacroWasteTable() {
        if (!allComponentsCreated) {
            return;
        }
        macroWasteTable.add(macroWasteTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        macroWasteTable.add(SwingUtil.boxComponentWithJxLayer(macroWasteTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToObservationTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        observationTabFishingOperationReminderLabel.add($JLabel0);
    }

    protected void addChildrenToPlanktonTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        planktonTabFishingOperationReminderLabel.add(planktonTabContent);
    }

    protected void addChildrenToSpeciesTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFishingOperationReminderLabel.add(speciesTabContent);
    }

    protected void addChildrenToSpeciesTable() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTable.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSampleSortedWeightField), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(SwingUtil.boxComponentWithJxLayer(speciesTotalUnsortedWeightField), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(catchesCaracteristicsTabPane);
        tabPane.add(speciesTabFishingOperationReminderLabel);
        tabPane.add(benthosTabFishingOperationReminderLabel);
        tabPane.add(planktonTabFishingOperationReminderLabel);
        tabPane.add(macroWasteTabFishingOperationReminderLabel);
        tabPane.add(accidentalTabFishingOperationReminderLabel);
        tabPane.add(observationTabFishingOperationReminderLabel);
        catchesCaracteristicsTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        speciesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, _("tutti.label.tab.species"));
        benthosTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 2));
        tabPane.setTitleAt(2, _("tutti.label.tab.benthos"));
        planktonTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 3));
        tabPane.setTitleAt(3, _("tutti.label.tab.plancton"));
        macroWasteTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 4));
        tabPane.setTitleAt(4, _("tutti.label.tab.macroDechet"));
        accidentalTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 5));
        tabPane.setTitleAt(5, _("tutti.label.tab.accidentel"));
        observationIndividuelTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 6));
        tabPane.setTitleAt(6, _("tutti.label.tab.observationIndividuel"));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalTab() {
        $objectMap.put("accidentalTab", accidentalTab = new TabInfo());
        
        accidentalTab.setTitle(_("tutti.label.tab.accidentel"));
    }

    protected void createAccidentalTabContent() {
        $objectMap.put("accidentalTabContent", accidentalTabContent = new AccidentalBatchUI(this));
        
        accidentalTabContent.setName("accidentalTabContent");
    }

    protected void createAccidentalTabFishingOperationReminderLabel() {
        $objectMap.put("accidentalTabFishingOperationReminderLabel", accidentalTabFishingOperationReminderLabel = new JXTitledPanel());
        
        accidentalTabFishingOperationReminderLabel.setName("accidentalTabFishingOperationReminderLabel");
    }

    protected void createBenthosTab() {
        $objectMap.put("benthosTab", benthosTab = new TabInfo());
        
        benthosTab.setTitle(_("tutti.label.tab.benthos"));
    }

    protected void createBenthosTabContent() {
        $objectMap.put("benthosTabContent", benthosTabContent = new BenthosBatchUI(this));
        
        benthosTabContent.setName("benthosTabContent");
    }

    protected void createBenthosTabFishingOperationReminderLabel() {
        $objectMap.put("benthosTabFishingOperationReminderLabel", benthosTabFishingOperationReminderLabel = new JXTitledPanel());
        
        benthosTabFishingOperationReminderLabel.setName("benthosTabFishingOperationReminderLabel");
    }

    protected void createBenthosTable() {
        $objectMap.put("benthosTable", benthosTable = new Table());
        
        benthosTable.setName("benthosTable");
    }

    protected void createBenthosTotalSampleSortedWeightField() {
        $objectMap.put("benthosTotalSampleSortedWeightField", benthosTotalSampleSortedWeightField = new NumberEditor(this));
        
        benthosTotalSampleSortedWeightField.setName("benthosTotalSampleSortedWeightField");
        benthosTotalSampleSortedWeightField.setProperty("benthosTotalSampleSortedWeight");
        benthosTotalSampleSortedWeightField.setUseFloat(false);
        benthosTotalSampleSortedWeightField.setShowReset(true);
    }

    protected void createBenthosTotalSampleSortedWeightLabel() {
        $objectMap.put("benthosTotalSampleSortedWeightLabel", benthosTotalSampleSortedWeightLabel = new JLabel());
        
        benthosTotalSampleSortedWeightLabel.setName("benthosTotalSampleSortedWeightLabel");
        benthosTotalSampleSortedWeightLabel.setText(_("tutti.label.catches.benthosTotalSampleSortedWeight"));
        benthosTotalSampleSortedWeightLabel.putClientProperty("italicStyle", true);
    }

    protected void createBenthosTotalSortedWeightField() {
        $objectMap.put("benthosTotalSortedWeightField", benthosTotalSortedWeightField = new NumberEditor(this));
        
        benthosTotalSortedWeightField.setName("benthosTotalSortedWeightField");
        benthosTotalSortedWeightField.setProperty("benthosTotalSortedWeight");
        benthosTotalSortedWeightField.setUseFloat(false);
        benthosTotalSortedWeightField.setShowReset(true);
    }

    protected void createBenthosTotalSortedWeightLabel() {
        $objectMap.put("benthosTotalSortedWeightLabel", benthosTotalSortedWeightLabel = new JLabel());
        
        benthosTotalSortedWeightLabel.setName("benthosTotalSortedWeightLabel");
        benthosTotalSortedWeightLabel.setText(_("tutti.label.catches.benthosTotalSortedWeight"));
    }

    protected void createBenthosTotalUnsortedWeightField() {
        $objectMap.put("benthosTotalUnsortedWeightField", benthosTotalUnsortedWeightField = new JTextField());
        
        benthosTotalUnsortedWeightField.setName("benthosTotalUnsortedWeightField");
        benthosTotalUnsortedWeightField.setColumns(15);
        benthosTotalUnsortedWeightField.setEnabled(false);
        benthosTotalUnsortedWeightField.setEditable(false);
    }

    protected void createBenthosTotalUnsortedWeightLabel() {
        $objectMap.put("benthosTotalUnsortedWeightLabel", benthosTotalUnsortedWeightLabel = new JLabel());
        
        benthosTotalUnsortedWeightLabel.setName("benthosTotalUnsortedWeightLabel");
        benthosTotalUnsortedWeightLabel.setText(_("tutti.label.catches.benthosTotalUnsortedWeight"));
    }

    protected void createBenthosTotalWeightField() {
        $objectMap.put("benthosTotalWeightField", benthosTotalWeightField = new NumberEditor(this));
        
        benthosTotalWeightField.setName("benthosTotalWeightField");
        benthosTotalWeightField.setProperty("benthosTotalWeight");
        benthosTotalWeightField.setUseFloat(false);
        benthosTotalWeightField.setShowReset(true);
    }

    protected void createBenthosTotalWeightLabel() {
        $objectMap.put("benthosTotalWeightLabel", benthosTotalWeightLabel = new JLabel());
        
        benthosTotalWeightLabel.setName("benthosTotalWeightLabel");
        benthosTotalWeightLabel.setText(_("tutti.label.catches.benthosTotalWeight"));
        benthosTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createCatchTable() {
        $objectMap.put("catchTable", catchTable = new Table());
        
        catchTable.setName("catchTable");
    }

    protected void createCatchThalassaLabel() {
        $objectMap.put("catchThalassaLabel", catchThalassaLabel = new JLabel());
        
        catchThalassaLabel.setName("catchThalassaLabel");
        catchThalassaLabel.setText(_("tutti.label.catches.catchThalassa"));
    }

    protected void createCatchTotalRejectedWeightField() {
        $objectMap.put("catchTotalRejectedWeightField", catchTotalRejectedWeightField = new NumberEditor(this));
        
        catchTotalRejectedWeightField.setName("catchTotalRejectedWeightField");
        catchTotalRejectedWeightField.setProperty("catchTotalRejectedWeight");
        catchTotalRejectedWeightField.setUseFloat(false);
        catchTotalRejectedWeightField.setShowReset(true);
    }

    protected void createCatchTotalRejectedWeightLabel() {
        $objectMap.put("catchTotalRejectedWeightLabel", catchTotalRejectedWeightLabel = new JLabel());
        
        catchTotalRejectedWeightLabel.setName("catchTotalRejectedWeightLabel");
        catchTotalRejectedWeightLabel.setText(_("tutti.label.catches.catchTotalRejectedWeight"));
    }

    protected void createCatchTotalSortedCarousselWeightField() {
        $objectMap.put("catchTotalSortedCarousselWeightField", catchTotalSortedCarousselWeightField = new NumberEditor(this));
        
        catchTotalSortedCarousselWeightField.setName("catchTotalSortedCarousselWeightField");
        catchTotalSortedCarousselWeightField.setProperty("catchTotalSortedCarousselWeight");
        catchTotalSortedCarousselWeightField.setUseFloat(false);
        catchTotalSortedCarousselWeightField.setShowReset(true);
    }

    protected void createCatchTotalSortedCarousselWeightLabel() {
        $objectMap.put("catchTotalSortedCarousselWeightLabel", catchTotalSortedCarousselWeightLabel = new JLabel());
        
        catchTotalSortedCarousselWeightLabel.setName("catchTotalSortedCarousselWeightLabel");
        catchTotalSortedCarousselWeightLabel.setText(_("tutti.label.catches.catchTotalSortedCarousselWeight"));
    }

    protected void createCatchTotalSortedTremisWeightField() {
        $objectMap.put("catchTotalSortedTremisWeightField", catchTotalSortedTremisWeightField = new NumberEditor(this));
        
        catchTotalSortedTremisWeightField.setName("catchTotalSortedTremisWeightField");
        catchTotalSortedTremisWeightField.setProperty("catchTotalSortedTremisWeight");
        catchTotalSortedTremisWeightField.setUseFloat(false);
        catchTotalSortedTremisWeightField.setShowReset(true);
    }

    protected void createCatchTotalSortedTremisWeightLabel() {
        $objectMap.put("catchTotalSortedTremisWeightLabel", catchTotalSortedTremisWeightLabel = new JLabel());
        
        catchTotalSortedTremisWeightLabel.setName("catchTotalSortedTremisWeightLabel");
        catchTotalSortedTremisWeightLabel.setText(_("tutti.label.catches.catchTotalSortedTremisWeight"));
    }

    protected void createCatchTotalSortedWeightLabel() {
        $objectMap.put("catchTotalSortedWeightLabel", catchTotalSortedWeightLabel = new JLabel());
        
        catchTotalSortedWeightLabel.setName("catchTotalSortedWeightLabel");
        catchTotalSortedWeightLabel.setText(_("tutti.label.catches.catchTotalSortedWeight"));
    }

    protected void createCatchTotalUnsortedWeightField() {
        $objectMap.put("catchTotalUnsortedWeightField", catchTotalUnsortedWeightField = new JTextField());
        
        catchTotalUnsortedWeightField.setName("catchTotalUnsortedWeightField");
        catchTotalUnsortedWeightField.setColumns(15);
        catchTotalUnsortedWeightField.setEnabled(false);
        catchTotalUnsortedWeightField.setEditable(false);
    }

    protected void createCatchTotalUnsortedWeightLabel() {
        $objectMap.put("catchTotalUnsortedWeightLabel", catchTotalUnsortedWeightLabel = new JLabel());
        
        catchTotalUnsortedWeightLabel.setName("catchTotalUnsortedWeightLabel");
        catchTotalUnsortedWeightLabel.setText(_("tutti.label.catches.catchTotalUnsortedWeight"));
    }

    protected void createCatchTotalWeightField() {
        $objectMap.put("catchTotalWeightField", catchTotalWeightField = new NumberEditor(this));
        
        catchTotalWeightField.setName("catchTotalWeightField");
        catchTotalWeightField.setProperty("catchTotalWeight");
        catchTotalWeightField.setUseFloat(false);
        catchTotalWeightField.setShowReset(true);
    }

    protected void createCatchTotalWeightLabel() {
        $objectMap.put("catchTotalWeightLabel", catchTotalWeightLabel = new JLabel());
        
        catchTotalWeightLabel.setName("catchTotalWeightLabel");
        catchTotalWeightLabel.setText(_("tutti.label.catches.catchTotalWeight"));
        catchTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createCatchesCaracteristicsTab() {
        $objectMap.put("catchesCaracteristicsTab", catchesCaracteristicsTab = new TabInfo());
    }

    protected void createCatchesCaracteristicsTabPane() {
        $objectMap.put("catchesCaracteristicsTabPane", catchesCaracteristicsTabPane = new JXTitledPanel());
        
        catchesCaracteristicsTabPane.setName("catchesCaracteristicsTabPane");
    }

    protected void createCatchesCaracteristicsTabScrollPane() {
        $objectMap.put("catchesCaracteristicsTabScrollPane", catchesCaracteristicsTabScrollPane = new JScrollPane());
        
        catchesCaracteristicsTabScrollPane.setName("catchesCaracteristicsTabScrollPane");
    }

    protected void createCatchesForm() {
        $objectMap.put("catchesForm", catchesForm = new Table());
        
        catchesForm.setName("catchesForm");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCatchesUIHandler.class));
    }

    protected void createImportPupitriButton() {
        $objectMap.put("importPupitriButton", importPupitriButton = new JButton());
        
        importPupitriButton.setName("importPupitriButton");
        importPupitriButton.setText(_("tutti.action.pupitri-import"));
        importPupitriButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importPupitriButton"));
    }

    protected void createMacroWasteTab() {
        $objectMap.put("macroWasteTab", macroWasteTab = new TabInfo());
        
        macroWasteTab.setTitle(_("tutti.label.tab.macroDechet"));
    }

    protected void createMacroWasteTabContent() {
        $objectMap.put("macroWasteTabContent", macroWasteTabContent = new MacroWasteBatchUI(this));
        
        macroWasteTabContent.setName("macroWasteTabContent");
    }

    protected void createMacroWasteTabFishingOperationReminderLabel() {
        $objectMap.put("macroWasteTabFishingOperationReminderLabel", macroWasteTabFishingOperationReminderLabel = new JXTitledPanel());
        
        macroWasteTabFishingOperationReminderLabel.setName("macroWasteTabFishingOperationReminderLabel");
    }

    protected void createMacroWasteTable() {
        $objectMap.put("macroWasteTable", macroWasteTable = new Table());
        
        macroWasteTable.setName("macroWasteTable");
    }

    protected void createMacroWasteTotalWeightField() {
        $objectMap.put("macroWasteTotalWeightField", macroWasteTotalWeightField = new NumberEditor(this));
        
        macroWasteTotalWeightField.setName("macroWasteTotalWeightField");
        macroWasteTotalWeightField.setProperty("macroWasteTotalWeight");
        macroWasteTotalWeightField.setUseFloat(false);
        macroWasteTotalWeightField.setShowReset(true);
    }

    protected void createMacroWasteTotalWeightLabel() {
        $objectMap.put("macroWasteTotalWeightLabel", macroWasteTotalWeightLabel = new JLabel());
        
        macroWasteTotalWeightLabel.setName("macroWasteTotalWeightLabel");
        macroWasteTotalWeightLabel.setText(_("tutti.label.catches.macroWasteTotalWeight"));
        macroWasteTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCatchesUIModel.class));
    }

    protected void createObservationIndividuelTab() {
        $objectMap.put("observationIndividuelTab", observationIndividuelTab = new TabInfo());
        
        observationIndividuelTab.setTitle(_("tutti.label.tab.observationIndividuel"));
    }

    protected void createObservationTabFishingOperationReminderLabel() {
        $objectMap.put("observationTabFishingOperationReminderLabel", observationTabFishingOperationReminderLabel = new JXTitledPanel());
        
        observationTabFishingOperationReminderLabel.setName("observationTabFishingOperationReminderLabel");
    }

    protected void createPlanktonTab() {
        $objectMap.put("planktonTab", planktonTab = new TabInfo());
        
        planktonTab.setTitle(_("tutti.label.tab.plancton"));
    }

    protected void createPlanktonTabContent() {
        $objectMap.put("planktonTabContent", planktonTabContent = new PlanktonBatchUI(this));
        
        planktonTabContent.setName("planktonTabContent");
    }

    protected void createPlanktonTabFishingOperationReminderLabel() {
        $objectMap.put("planktonTabFishingOperationReminderLabel", planktonTabFishingOperationReminderLabel = new JXTitledPanel());
        
        planktonTabFishingOperationReminderLabel.setName("planktonTabFishingOperationReminderLabel");
    }

    protected void createSpeciesTab() {
        $objectMap.put("speciesTab", speciesTab = new TabInfo());
        
        speciesTab.setTitle(_("tutti.label.tab.species"));
    }

    protected void createSpeciesTabContent() {
        $objectMap.put("speciesTabContent", speciesTabContent = new SpeciesBatchUI(this));
        
        speciesTabContent.setName("speciesTabContent");
    }

    protected void createSpeciesTabFishingOperationReminderLabel() {
        $objectMap.put("speciesTabFishingOperationReminderLabel", speciesTabFishingOperationReminderLabel = new JXTitledPanel());
        
        speciesTabFishingOperationReminderLabel.setName("speciesTabFishingOperationReminderLabel");
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new Table());
        
        speciesTable.setName("speciesTable");
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new NumberEditor(this));
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setProperty("speciesTotalSampleSortedWeight");
        speciesTotalSampleSortedWeightField.setUseFloat(false);
        speciesTotalSampleSortedWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSampleSortedWeight"));
        speciesTotalSampleSortedWeightLabel.putClientProperty("italicStyle", true);
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new NumberEditor(this));
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setProperty("speciesTotalSortedWeight");
        speciesTotalSortedWeightField.setUseFloat(false);
        speciesTotalSortedWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSortedWeight"));
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.setEnabled(false);
        speciesTotalUnsortedWeightField.setEditable(false);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(_("tutti.label.catches.speciesTotalUnsortedWeight"));
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new NumberEditor(this));
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setProperty("speciesTotalWeight");
        speciesTotalWeightField.setUseFloat(false);
        speciesTotalWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(_("tutti.label.catches.speciesTotalWeight"));
        speciesTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCatchesUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToTabPane();
        addChildrenToCatchesCaracteristicsTabPane();
        addChildrenToCatchesCaracteristicsTabScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(catchesForm, BorderLayout.NORTH);
        addChildrenToCatchesForm();
        addChildrenToCatchTable();
        addChildrenToSpeciesTable();
        addChildrenToBenthosTable();
        addChildrenToMacroWasteTable();
        // inline complete setup of $JPanel1
        $JPanel1.add(importPupitriButton);
        addChildrenToSpeciesTabFishingOperationReminderLabel();
        addChildrenToBenthosTabFishingOperationReminderLabel();
        addChildrenToPlanktonTabFishingOperationReminderLabel();
        addChildrenToMacroWasteTabFishingOperationReminderLabel();
        addChildrenToAccidentalTabFishingOperationReminderLabel();
        addChildrenToObservationTabFishingOperationReminderLabel();
        
        // apply 25 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 58 property setters
        $JLabel0.setHorizontalAlignment(JLabel.CENTER);
        catchTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.total")));
        catchTotalWeightLabel.setLabelFor(catchTotalWeightField);
        catchTotalWeightField.setBean(model);
        catchTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalSortedCarousselWeightLabel.setLabelFor(catchTotalSortedCarousselWeightField);
        catchTotalSortedCarousselWeightField.setBean(model);
        catchTotalSortedCarousselWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalSortedCarousselWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalSortedTremisWeightLabel.setLabelFor(catchTotalSortedTremisWeightField);
        catchTotalSortedTremisWeightField.setBean(model);
        catchTotalSortedTremisWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalSortedTremisWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalUnsortedWeightLabel.setLabelFor(catchTotalUnsortedWeightField);
        catchTotalRejectedWeightLabel.setLabelFor(catchTotalRejectedWeightField);
        catchTotalRejectedWeightField.setBean(model);
        catchTotalRejectedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalRejectedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchThalassaLabel.setIcon(SwingUtil.createActionIcon("information"));
        speciesTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.species")));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalWeightField.setBean(model);
        speciesTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightField.setBean(model);
        speciesTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalSampleSortedWeightField.setBean(model);
        speciesTotalSampleSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSampleSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        benthosTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.benthos")));
        benthosTotalWeightLabel.setLabelFor(benthosTotalWeightField);
        benthosTotalWeightField.setBean(model);
        benthosTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalSortedWeightLabel.setLabelFor(benthosTotalSortedWeightField);
        benthosTotalSortedWeightField.setBean(model);
        benthosTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalSampleSortedWeightLabel.setLabelFor(benthosTotalSampleSortedWeightField);
        benthosTotalSampleSortedWeightField.setBean(model);
        benthosTotalSampleSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalSampleSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalUnsortedWeightLabel.setLabelFor(benthosTotalUnsortedWeightField);
        macroWasteTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.macroWaste")));
        macroWasteTotalWeightLabel.setLabelFor(macroWasteTotalWeightField);
        macroWasteTotalWeightField.setBean(model);
        macroWasteTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        macroWasteTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        importPupitriButton.setIcon(SwingUtil.createActionIcon("pupitri-import"));
        observationIndividuelTab.setEnabled(false);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createTabPane();
        createCatchesCaracteristicsTabPane();
        createCatchesCaracteristicsTabScrollPane();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createCatchesForm();
        createCatchTable();
        createCatchTotalWeightLabel();
        createCatchTotalWeightField();
        createCatchTotalSortedWeightLabel();
        createCatchTotalSortedCarousselWeightLabel();
        createCatchTotalSortedCarousselWeightField();
        createCatchTotalSortedTremisWeightLabel();
        createCatchTotalSortedTremisWeightField();
        createCatchTotalUnsortedWeightLabel();
        createCatchTotalUnsortedWeightField();
        createCatchTotalRejectedWeightLabel();
        createCatchTotalRejectedWeightField();
        createCatchThalassaLabel();
        createSpeciesTable();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createBenthosTable();
        createBenthosTotalWeightLabel();
        createBenthosTotalWeightField();
        createBenthosTotalSortedWeightLabel();
        createBenthosTotalSortedWeightField();
        createBenthosTotalSampleSortedWeightLabel();
        createBenthosTotalSampleSortedWeightField();
        createBenthosTotalUnsortedWeightLabel();
        createBenthosTotalUnsortedWeightField();
        createMacroWasteTable();
        createMacroWasteTotalWeightLabel();
        createMacroWasteTotalWeightField();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createImportPupitriButton();
        createSpeciesTabFishingOperationReminderLabel();
        createSpeciesTabContent();
        createBenthosTabFishingOperationReminderLabel();
        createBenthosTabContent();
        createPlanktonTabFishingOperationReminderLabel();
        createPlanktonTabContent();
        createMacroWasteTabFishingOperationReminderLabel();
        createMacroWasteTabContent();
        createAccidentalTabFishingOperationReminderLabel();
        createAccidentalTabContent();
        createObservationTabFishingOperationReminderLabel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("tutti.to.be.done"));
        createCatchesCaracteristicsTab();
        createSpeciesTab();
        createBenthosTab();
        createPlanktonTab();
        createMacroWasteTab();
        createAccidentalTab();
        createObservationIndividuelTab();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 25 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 25 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalWeightField.setModel(model.getCatchTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedCarousselWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalSortedCarousselWeightField.setModel(model.getCatchTotalSortedCarousselWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedCarousselWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalSortedCarousselWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedTremisWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalSortedTremisWeightField.setModel(model.getCatchTotalSortedTremisWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedTremisWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalSortedTremisWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalUnsortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalUnsortedWeightField, getStringValue(model.getCatchTotalUnsortedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalUnsortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalRejectedWeightField.setModel(model.getCatchTotalRejectedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalRejectedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalWeightField.setModel(model.getSpeciesTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setModel(model.getSpeciesTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalSortedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSampleSortedWeightField.setModel(model.getSpeciesTotalSampleSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalSampleSortedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, getStringValue(model.getSpeciesTotalUnsortedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalWeightField.setModel(model.getBenthosTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                benthosTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setModel(model.getBenthosTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                benthosTotalSortedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSampleSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSampleSortedWeightField.setModel(model.getBenthosTotalSampleSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSampleSortedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                benthosTotalSampleSortedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalUnsortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalUnsortedWeightField, getStringValue(model.getBenthosTotalUnsortedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalUnsortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MACRO_WASTE_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("macroWasteTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    macroWasteTotalWeightField.setModel(model.getMacroWasteTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("macroWasteTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MACRO_WASTE_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                macroWasteTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
    }

}