package fr.ifremer.tutti.ui.swing.config;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiConfigUI.java 138 2013-01-02 10:07:34Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/config/TuttiConfigUI.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import fr.ifremer.tutti.ui.swing.MainUI;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import jaxx.runtime.swing.editor.config.model.MainCallBackFinalizer;

import static org.nuiton.i18n.I18n.n_;

/**
 * To launch the config UI.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class TuttiConfigUI {

    public static final String CALLBACK_APPLICATION = "application";

    public static final String CALLBACK_UI = "ui";

    public static final String CALLBACK_SHORTCUT = "shortcut";

    protected final MainUI mainUI;

    public TuttiConfigUI(MainUI mainUI) {
        this.mainUI = mainUI;
    }

    public void createUI() {

        TuttiConfig config = mainUI.getHandler().getContext().getConfig();

        ConfigUIHelper helper = new ConfigUIHelper(config.getApplicationConfig());

        helper.registerCallBack(
                CALLBACK_UI, n_("tutti.action.reload.ui"),
                SwingUtil.createActionIcon("reload-ui"),
                new Runnable() {

                    @Override
                    public void run() {
                        reloadUI();
                    }
                }
        ).registerCallBack(
                CALLBACK_APPLICATION, n_("tutti.action.reload.application"),
                SwingUtil.createActionIcon("reload-application"),
                new Runnable() {

                    @Override
                    public void run() {
                        reloadApplication();
                    }
                }
        ).registerCallBack(
                CALLBACK_SHORTCUT, n_("tutti.action.reload.actions"),
                SwingUtil.createActionIcon("reload-shortcut"),
                new Runnable() {

                    @Override
                    public void run() {

                        reloadShortcuts();
                    }
                }
        );

        // APPLICATION

        helper.addCategory(n_("tutti.config.category.applications"),
                           n_("tutti.config.category.applications.description"),
                           CALLBACK_APPLICATION)
                .addOption(TuttiServiceConfigOption.DATA_DIRECTORY)
                .addOption(TuttiServiceConfigOption.SITE_URL)
                .addOption(TuttiConfigOption.UI_CONFIG_FILE);

        // COLOR
        helper.addCategory(n_("tutti.config.category.colors"),
                           n_("tutti.config.category.colors.description"),
                           CALLBACK_UI)
                .addOption(TuttiConfigOption.COLOR_ROW_INVALID)
                .addOption(TuttiConfigOption.COLOR_ROW_READ_ONLY);

        // SHORTCUT

        helper.addCategory(n_("tutti.config.category.shortcuts"),
                           n_("tutti.config.category.shortcuts.description"),
                           CALLBACK_SHORTCUT)
                .addOption(TuttiConfigOption.SHORTCUT_CLOSE_POPUP);

        helper.setFinalizer(new MainCallBackFinalizer(CALLBACK_APPLICATION));

        ConfigUI configUI = helper.buildUI(
                mainUI,
                "tutti.config.category.applications");

        helper.displayUI(mainUI, false);

        mainUI.getHandler().getContext().getSwingSession().add(configUI);
    }

    protected void reloadApplication() {
        mainUI.getHandler().reloadApplication();
    }

    protected void reloadUI() {
        mainUI.getHandler().reloadTutti();
    }

    protected void reloadShortcuts() {
        mainUI.getHandler().reloadShortcuts();
    }
}
