/*
 * Decompiled with CFR 0.152.
 */
package winstone.jndi;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import winstone.jndi.ContainerJNDIManager;

public class WinstoneNameEnumeration
implements NamingEnumeration {
    private Enumeration nameEnumeration;

    public WinstoneNameEnumeration(Map bindings) {
        Object[] keys = bindings.keySet().toArray();
        Arrays.sort(keys);
        Vector<NameClassPair> nameClassPairs = new Vector<NameClassPair>();
        for (int n = 0; n < keys.length; ++n) {
            nameClassPairs.add(new NameClassPair((String)keys[n], bindings.get(keys[n]).getClass().getName()));
        }
        this.nameEnumeration = nameClassPairs.elements();
    }

    public void close() throws NamingException {
        this.nameEnumeration = null;
    }

    public boolean hasMore() throws NamingException {
        if (this.nameEnumeration == null) {
            throw new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneNameEnumeration.AlreadyClosed"));
        }
        return this.nameEnumeration.hasMoreElements();
    }

    public Object next() throws NamingException {
        if (this.hasMore()) {
            return this.nameEnumeration.nextElement();
        }
        return null;
    }

    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException err) {
            return false;
        }
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException err) {
            return null;
        }
    }
}

