/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.internal.OptionGroupModelImpl;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.util.AbstractSelectModel;
import org.slf4j.Logger;

public class GenericSelectModel<T>
extends AbstractSelectModel {
    private List<T> list;
    private Map<String, List<T>> map;
    private PropertyAdapter labelFieldAdapter;
    private PropertyAdapter idFieldAdapter;
    @Inject
    private Logger log;

    public GenericSelectModel(List<T> list, Class<T> clazz, String labelField, String idField, PropertyAccess access) {
        this.init(clazz, labelField, idField, access);
        this.list = list;
    }

    public GenericSelectModel(Map<String, List<T>> map, Class<T> clazz, String labelField, String idField, PropertyAccess access) {
        this.init(clazz, labelField, idField, access);
        this.map = map;
    }

    private void init(Class<T> clazz, String labelField, String idField, PropertyAccess access) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is required.");
        }
        if (idField == null) {
            throw new IllegalArgumentException("idField is required.");
        }
        if (labelField == null) {
            throw new IllegalArgumentException("labelField is required.");
        }
        this.idFieldAdapter = access.getAdapter(clazz).getPropertyAdapter(idField);
        this.labelFieldAdapter = access.getAdapter(clazz).getPropertyAdapter(labelField);
        if (this.idFieldAdapter == null) {
            throw new IllegalArgumentException("idField " + idField + " does not exist in class " + clazz + ".");
        }
        if (this.labelFieldAdapter == null) {
            throw new IllegalArgumentException("labelField " + idField + " does not exist in class " + clazz + ".");
        }
    }

    public List<OptionGroupModel> getOptionGroups() {
        if (this.list != null) {
            return null;
        }
        ArrayList<OptionGroupModel> optionGroupModelList = new ArrayList<OptionGroupModel>();
        for (String key : this.map.keySet()) {
            optionGroupModelList.add((OptionGroupModel)new OptionGroupModelImpl(key, false, this.getOptions((List)this.map.get(key)), new String[0]));
        }
        return optionGroupModelList;
    }

    public List<OptionModel> getOptions() {
        if (this.map != null) {
            return null;
        }
        return this.getOptions(this.list);
    }

    private List<OptionModel> getOptions(List<T> list) {
        ArrayList<OptionModel> optionModelList = new ArrayList<OptionModel>();
        for (T obj : list) {
            optionModelList.add((OptionModel)new OptionModelImpl(this.nvl(this.labelFieldAdapter.get(obj)), this.idFieldAdapter.get(obj)));
        }
        return optionModelList;
    }

    public List<T> getList() {
        ArrayList results;
        if (this.map != null) {
            results = new ArrayList();
            for (String key : this.map.keySet()) {
                results.addAll((Collection)this.map.get(key));
            }
        } else {
            results = this.list;
        }
        return results;
    }

    public T findObject(String id) {
        if (id != null) {
            for (Object current : this.getList()) {
                Object currentId = this.idFieldAdapter.get(current);
                if (!currentId.equals(id)) continue;
                return (T)current;
            }
        }
        return null;
    }

    private String nvl(Object o) {
        return o == null ? "" : o.toString();
    }
}

